/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttributeMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientManager;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskAttachmentHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.Messages;
import org.eclipse.mylyn.internal.bugzilla.core.UnrecognizedReponseException;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaRepositoryConnector
extends AbstractRepositoryConnector {
    private static final String BUG_ID = "&bug_id=";
    private static final String CHANGED_BUGS_CGI_ENDDATE = "&chfieldto=Now";
    private static final String CHANGED_BUGS_CGI_QUERY = "/buglist.cgi?query_format=advanced&chfieldfrom=";
    private static final String CLIENT_LABEL = Messages.BugzillaRepositoryConnector_BUGZILLA_SUPPORTS_2_18_TO_3_0;
    private static final String COMMENT_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String DEADLINE_FORMAT = "yyyy-MM-dd";
    private static final long HOUR = 3600000L;
    private final BugzillaTaskAttachmentHandler attachmentHandler = new BugzillaTaskAttachmentHandler(this);
    private final BugzillaTaskDataHandler taskDataHandler = new BugzillaTaskDataHandler(this);
    protected BugzillaClientManager clientManager;
    protected static BugzillaLanguageSettings enSetting;
    protected static final Set<BugzillaLanguageSettings> languages;

    static {
        languages = new LinkedHashSet<BugzillaLanguageSettings>();
    }

    public String getLabel() {
        return CLIENT_LABEL;
    }

    public AbstractTaskAttachmentHandler getTaskAttachmentHandler() {
        return this.attachmentHandler;
    }

    public String getConnectorKind() {
        return "bugzilla";
    }

    public void updateTaskFromTaskData(TaskRepository repository, ITask task, TaskData taskData) {
        TaskMapper scheme = this.getTaskMapping(taskData);
        scheme.applyTo(task);
        task.setUrl(BugzillaClient.getBugUrlWithoutLogin(repository.getRepositoryUrl(), taskData.getTaskId()));
        boolean isComplete = false;
        TaskAttribute attributeStatus = taskData.getRoot().getMappedAttribute("task.common.status");
        if (attributeStatus != null) {
            boolean bl = isComplete = attributeStatus.getValue().equals("RESOLVED") || attributeStatus.getValue().equals("CLOSED") || attributeStatus.getValue().equals("VERIFIED");
        }
        if (taskData.isPartial()) {
            if (isComplete) {
                if (task.getCompletionDate() == null) {
                    task.setCompletionDate(new Date(0L));
                }
            } else if (task.getCompletionDate() != null) {
                task.setCompletionDate(null);
            }
        } else {
            TaskAttribute attrSeverity;
            if (isComplete) {
                TaskAttribute attributeLastModified;
                TaskAttribute attributeCommentDate;
                TaskAttribute lastComment;
                Date completionDate = null;
                List taskComments = taskData.getAttributeMapper().getAttributesByType(taskData, "comment");
                if (taskComments != null && taskComments.size() > 0 && (lastComment = (TaskAttribute)taskComments.get(taskComments.size() - 1)) != null && (attributeCommentDate = lastComment.getMappedAttribute("task.common.comment.date")) != null) {
                    try {
                        completionDate = new SimpleDateFormat(COMMENT_FORMAT).parse(attributeCommentDate.getValue());
                    }
                    catch (ParseException parseException) {}
                }
                if (completionDate == null && (attributeLastModified = taskData.getRoot().getMappedAttribute("task.common.date.modified")) != null && attributeLastModified.getValue().length() > 0) {
                    completionDate = taskData.getAttributeMapper().getDateValue(attributeLastModified);
                }
                if (completionDate == null) {
                    completionDate = new Date();
                }
                task.setCompletionDate(completionDate);
            } else {
                task.setCompletionDate(null);
            }
            if (scheme.getProduct() != null) {
                task.setAttribute("task.common.product", scheme.getProduct());
            }
            if ((attrSeverity = taskData.getRoot().getMappedAttribute(BugzillaAttribute.BUG_SEVERITY.getKey())) != null && !attrSeverity.getValue().equals("")) {
                task.setAttribute(BugzillaAttribute.BUG_SEVERITY.getKey(), attrSeverity.getValue());
            }
        }
        this.updateExtendedAttributes(task, taskData);
    }

    private void updateExtendedAttributes(ITask task, TaskData taskData) {
        BugzillaAttribute[] bugzillaAttributeArray = BugzillaAttribute.EXTENDED_ATTRIBUTES;
        int n = BugzillaAttribute.EXTENDED_ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            BugzillaAttribute bugzillaReportElement = bugzillaAttributeArray[n2];
            TaskAttribute taskAttribute = taskData.getRoot().getAttribute(bugzillaReportElement.getKey());
            if (taskAttribute != null) {
                task.setAttribute(bugzillaReportElement.getKey(), taskAttribute.getValue());
            }
            ++n2;
        }
    }

    public void preSynchronization(ISynchronizationSession session, IProgressMonitor monitor) throws CoreException {
        TaskRepository repository = session.getTaskRepository();
        if (session.getTasks().isEmpty()) {
            return;
        }
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask(Messages.BugzillaRepositoryConnector_checking_for_changed_tasks, session.getTasks().size());
            if (repository.getSynchronizationTimeStamp() == null) {
                for (ITask task : session.getTasks()) {
                    session.markStale(task);
                }
                return;
            }
            try {
                String dateString = repository.getSynchronizationTimeStamp();
                if (dateString == null) {
                    dateString = "";
                }
                String urlQueryBase = String.valueOf(repository.getRepositoryUrl()) + CHANGED_BUGS_CGI_QUERY + URLEncoder.encode(dateString, repository.getCharacterEncoding()) + CHANGED_BUGS_CGI_ENDDATE;
                StringBuilder urlQueryString = new StringBuilder(Math.min(30 + 9 * session.getTasks().size(), 7009));
                urlQueryString.append(String.valueOf(urlQueryBase) + BUG_ID);
                HashSet<ITask> changedTasks = new HashSet<ITask>();
                Iterator itr = session.getTasks().iterator();
                int queryCounter = 0;
                HashSet<ITask> checking = new HashSet<ITask>();
                while (itr.hasNext()) {
                    ITask task = (ITask)itr.next();
                    checking.add(task);
                    ++queryCounter;
                    urlQueryString.append(URLEncoder.encode(String.valueOf(task.getTaskId()) + ",", repository.getCharacterEncoding()));
                    if (urlQueryString.length() >= 7000) {
                        this.queryForChanged(repository, changedTasks, urlQueryString.toString(), session, (IProgressMonitor)new SubProgressMonitor(monitor, queryCounter));
                        queryCounter = 0;
                        urlQueryString.setLength(0);
                        urlQueryString.append(String.valueOf(urlQueryBase) + BUG_ID);
                    }
                    if (itr.hasNext() || queryCounter == 0) continue;
                    this.queryForChanged(repository, changedTasks, urlQueryString.toString(), session, (IProgressMonitor)new SubProgressMonitor(monitor, queryCounter));
                }
                for (ITask task : session.getTasks()) {
                    if (!changedTasks.contains(task)) continue;
                    session.markStale(task);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Repository configured with unsupported encoding: " + repository.getCharacterEncoding() + "\n\n Unable to determine changed tasks.", (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void queryForChanged(TaskRepository repository, Set<ITask> changedTasks, String urlQueryString, ISynchronizationSession context, IProgressMonitor monitor) throws UnsupportedEncodingException, CoreException {
        HashMap<String, ITask> taskById = new HashMap<String, ITask>();
        for (ITask task : context.getTasks()) {
            taskById.put(task.getTaskId(), task);
        }
        final HashSet changedTaskData = new HashSet();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData.add(taskData);
            }
        };
        RepositoryQuery query = new RepositoryQuery(repository.getConnectorKind(), "");
        query.setSummary(Messages.BugzillaRepositoryConnector_Query_for_changed_tasks);
        query.setUrl(urlQueryString);
        this.performQuery(repository, (IRepositoryQuery)query, collector, context, monitor);
        for (TaskData data : changedTaskData) {
            ITask changedTask = (ITask)taskById.get(data.getTaskId());
            if (changedTask == null) continue;
            changedTasks.add(changedTask);
        }
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector resultCollector, ISynchronizationSession event, IProgressMonitor monitor) {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask(Messages.BugzillaRepositoryConnector_running_query, -1);
            BugzillaClient client = this.getClientManager().getClient(repository, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            TaskAttributeMapper mapper = this.getTaskDataHandler().getAttributeMapper(repository);
            boolean hitsReceived = client.getSearchHits(query, resultCollector, mapper, monitor);
            if (!hitsReceived) {
                client.logout(monitor);
                client.getSearchHits(query, resultCollector, mapper, monitor);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (UnrecognizedReponseException e) {
            Status status = new Status(4, "org.eclipse.mylyn.bugzilla", 1, Messages.BugzillaRepositoryConnector_Unrecognized_response_from_server, (Throwable)e);
            return status;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.mylyn.bugzilla", 4, MessageFormat.format(Messages.BugzillaRepositoryConnector_Check_repository_configuration, e.getMessage()), (Throwable)e);
            return status;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf("/show_bug.cgi?id=");
        return index == -1 ? null : url.substring(0, index);
    }

    public String getTaskIdFromTaskUrl(String url) {
        int index;
        if (url == null) {
            return null;
        }
        int anchorIndex = url.lastIndexOf("#");
        String bugUrl = url;
        if (anchorIndex != -1) {
            bugUrl = url.substring(0, anchorIndex);
        }
        return (index = bugUrl.indexOf("/show_bug.cgi?id=")) == -1 ? null : bugUrl.substring(index + "/show_bug.cgi?id=".length());
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        try {
            return BugzillaClient.getBugUrlWithoutLogin(repositoryUrl, taskId);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Error constructing task url for " + repositoryUrl + "  id:" + taskId, (Throwable)e));
            return null;
        }
    }

    public String getTaskIdPrefix() {
        return "bug";
    }

    public BugzillaClientManager getClientManager() {
        if (this.clientManager == null) {
            this.clientManager = new BugzillaClientManager();
            BugzillaCorePlugin.setConnector(this);
            enSetting = new BugzillaLanguageSettings("en (default)");
            enSetting.addLanguageAttribute("error_login", "Login");
            enSetting.addLanguageAttribute("error_login", "log in");
            enSetting.addLanguageAttribute("error_login", "check e-mail");
            enSetting.addLanguageAttribute("error_login", "Invalid Username Or Password");
            enSetting.addLanguageAttribute("error_collision", "Mid-air collision!");
            enSetting.addLanguageAttribute("error_comment_required", "Comment Required");
            enSetting.addLanguageAttribute("error_logged_out", "logged out");
            enSetting.addLanguageAttribute("bad_login", "Login");
            enSetting.addLanguageAttribute("bad_login", "log in");
            enSetting.addLanguageAttribute("bad_login", "check e-mail");
            enSetting.addLanguageAttribute("bad_login", "Invalid Username Or Password");
            enSetting.addLanguageAttribute("bad_login", "error");
            enSetting.addLanguageAttribute("processed", "processed");
            enSetting.addLanguageAttribute("changes_submitted", "Changes submitted");
            enSetting.addLanguageAttribute("changes_submitted", "added to Bug");
            enSetting.addLanguageAttribute("bug", "Bug");
            enSetting.addLanguageAttribute("bug", "Issue");
            enSetting.addLanguageAttribute("submitted", "Submitted");
            enSetting.addLanguageAttribute("submitted", "posted");
            enSetting.addLanguageAttribute("suspicious_action", "Suspicious action");
            languages.add(enSetting);
        }
        return this.clientManager;
    }

    public void updateRepositoryConfiguration(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        if (repository != null) {
            BugzillaCorePlugin.getRepositoryConfiguration(repository, true, monitor);
        }
    }

    public boolean isRepositoryConfigurationStale(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        if (super.isRepositoryConfigurationStale(repository, monitor)) {
            String timestamp;
            boolean result = true;
            BugzillaClient client = this.getClientManager().getClient(repository, monitor);
            if (client != null && (timestamp = client.getConfigurationTimestamp(monitor)) != null) {
                String oldTimestamp = repository.getProperty("org.eclipse.mylyn.tasklist.repositories.config.timestamp");
                if (oldTimestamp != null) {
                    result = !timestamp.equals(oldTimestamp);
                }
                repository.setProperty("org.eclipse.mylyn.tasklist.repositories.config.timestamp", timestamp);
            }
            return result;
        }
        return false;
    }

    public static void addLanguageSetting(BugzillaLanguageSettings language) {
        if (!languages.contains(language)) {
            languages.add(language);
        }
    }

    public static Set<BugzillaLanguageSettings> getLanguageSettings() {
        return languages;
    }

    public static BugzillaLanguageSettings getLanguageSetting(String label) {
        for (BugzillaLanguageSettings language : BugzillaRepositoryConnector.getLanguageSettings()) {
            if (!language.getLanguageName().equals(label)) continue;
            return language;
        }
        return enSetting;
    }

    public void postSynchronization(ISynchronizationSession event, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 1);
            if (event.isFullSynchronization() && event.getStatus() == null) {
                event.getTaskRepository().setSynchronizationTimeStamp(this.getSynchronizationTimestamp(event));
            }
        }
        finally {
            monitor.done();
        }
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        return this.taskDataHandler.getTaskData(repository, taskId, monitor);
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public boolean hasTaskChanged(TaskRepository taskRepository, ITask task, TaskData taskData) {
        TaskAttribute attrModification;
        String lastKnownMod;
        if (taskData.isPartial() && task.getCreationDate() != null) {
            return false;
        }
        TaskAttribute attrSecurityToken = taskData.getRoot().getMappedAttribute(BugzillaAttribute.TOKEN.getKey());
        if (attrSecurityToken != null && !attrSecurityToken.getValue().equals("")) {
            task.setAttribute(BugzillaAttribute.TOKEN.getKey(), attrSecurityToken.getValue());
        }
        if ((lastKnownMod = task.getAttribute(BugzillaAttribute.DELTA_TS.getKey())) != null && (attrModification = taskData.getRoot().getMappedAttribute("task.common.date.modified")) != null && attrModification.getValue() != null && attrModification.getValue().length() > 0) {
            boolean cachedHasTZ = this.hasTimzone(lastKnownMod);
            boolean repoHasTZ = this.hasTimzone(attrModification.getValue());
            if (!cachedHasTZ && !repoHasTZ) {
                return !lastKnownMod.equals(attrModification.getValue());
            }
            BugzillaAttributeMapper mapper = (BugzillaAttributeMapper)taskData.getAttributeMapper();
            Date oldModDate = mapper.getDate(BugzillaAttribute.DELTA_TS.getKey(), lastKnownMod);
            Date newModDate = mapper.getDateValue(attrModification);
            if (oldModDate == null) {
                ((AbstractTask)task).setStatus((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Unable to parse cached task modification timestamp " + lastKnownMod));
                return !lastKnownMod.equals(attrModification.getValue());
            }
            if (newModDate == null) {
                ((AbstractTask)task).setStatus((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Unable to parse incoming task modification timestamp " + attrModification.getValue()));
                return !lastKnownMod.equals(attrModification.getValue());
            }
            if (cachedHasTZ && !repoHasTZ || !cachedHasTZ && repoHasTZ) {
                long delta = Math.abs(newModDate.getTime() - oldModDate.getTime());
                if (delta == 0L) {
                    return false;
                }
                return delta <= 0L || delta % 3600000L != 0L || delta >= 86400000L;
            }
            if (cachedHasTZ && repoHasTZ) {
                return oldModDate.compareTo(newModDate) != 0;
            }
        }
        return true;
    }

    private boolean hasTimzone(String dateString) {
        if (dateString == null || dateString.length() == 0) {
            return false;
        }
        String[] parts = dateString.split(" ");
        boolean hasTimeZone = parts != null && parts.length == 3;
        return hasTimeZone;
    }

    public Collection<TaskRelation> getTaskRelations(TaskData taskData) {
        ArrayList<TaskRelation> relations = new ArrayList<TaskRelation>();
        TaskAttribute attribute = taskData.getRoot().getAttribute(BugzillaAttribute.DEPENDSON.getKey());
        if (attribute != null && attribute.getValue().length() > 0) {
            String[] stringArray = attribute.getValue().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String taskId = stringArray[n2];
                relations.add(TaskRelation.subtask((String)taskId.trim()));
                ++n2;
            }
        }
        return relations;
    }

    private String getSynchronizationTimestamp(ISynchronizationSession event) {
        Date mostRecent = new Date(0L);
        String mostRecentTimeStamp = event.getTaskRepository().getSynchronizationTimeStamp();
        for (ITask task : event.getChangedTasks()) {
            Date taskModifiedDate = task.getModificationDate();
            if (taskModifiedDate == null || !taskModifiedDate.after(mostRecent)) continue;
            mostRecent = taskModifiedDate;
            mostRecentTimeStamp = task.getAttribute(BugzillaAttribute.DELTA_TS.getKey());
        }
        return mostRecentTimeStamp;
    }

    public boolean hasRepositoryDueDate(TaskRepository taskRepository, ITask task, TaskData taskData) {
        return taskData.getRoot().getAttribute(BugzillaAttribute.ESTIMATED_TIME.getKey()) != null;
    }

    public TaskMapper getTaskMapping(final TaskData taskData) {
        return new TaskMapper(taskData){

            public String getTaskKey() {
                TaskAttribute attribute = this.getTaskData().getRoot().getAttribute(BugzillaAttribute.BUG_ID.getKey());
                if (attribute != null) {
                    return attribute.getValue();
                }
                return super.getTaskKey();
            }

            public String getTaskKind() {
                return taskData.getConnectorKind();
            }

            public String getTaskUrl() {
                return taskData.getRepositoryUrl();
            }
        };
    }
}

