/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksReminderDialog
extends Dialog {
    private List<AbstractTask> tasks = null;
    private Table table = null;
    private TableViewer tableViewer = null;
    private final String[] columnNames = new String[]{Messages.TasksReminderDialog_Description, Messages.TasksReminderDialog_Priority, Messages.TasksReminderDialog_Reminder_Day};
    private static final int DISMISS_ALL_ID = 200;
    private static final int DISMISS_ID = 201;
    private static final int SNOOZE_ID = 202;
    private static long DAY = 86400000L;

    public TasksReminderDialog(Shell parentShell, List<AbstractTask> remTasks) {
        super(parentShell);
        this.tasks = remTasks;
        this.setShellStyle(2272);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.TasksReminderDialog_Reminders);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setBlockOnOpen(false);
        GridLayout gl = new GridLayout(1, false);
        composite.setLayout((Layout)gl);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Composite container = new Composite(composite, 0);
        gl = new GridLayout(1, false);
        container.setLayout((Layout)gl);
        this.createTable(container);
        this.createTableViewer();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 200, Messages.TasksReminderDialog_Dismiss_All, false);
        this.createButton(parent, 201, Messages.TasksReminderDialog_Dismiss_Selected, false);
        this.createButton(parent, 202, Messages.TasksReminderDialog_Remind_tommorrow, true);
    }

    private void createTable(Composite parent) {
        int style = 101124;
        this.table = new Table(parent, style);
        GridLayout tlayout = new GridLayout();
        this.table.setLayout((Layout)tlayout);
        GridData wd = new GridData(1808);
        wd.heightHint = 300;
        this.table.setLayoutData((Object)wd);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText(this.columnNames[0]);
        column.setWidth(180);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksReminderDialog.this.tableViewer.setSorter((ViewerSorter)new ReminderTaskSorter(1));
            }
        });
        column = new TableColumn(this.table, 16384, 1);
        column.setText(this.columnNames[1]);
        column.setWidth(50);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksReminderDialog.this.tableViewer.setSorter((ViewerSorter)new ReminderTaskSorter(2));
            }
        });
        column = new TableColumn(this.table, 16384, 2);
        column.setText(this.columnNames[2]);
        column.setWidth(100);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksReminderDialog.this.tableViewer.setSorter((ViewerSorter)new ReminderTaskSorter(3));
            }
        });
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)new ReminderTasksContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ReminderTasksLabelProvider());
        this.tableViewer.setInput(this.tasks);
    }

    protected void buttonPressed(int buttonId) {
        Object object;
        if (buttonId == 200) {
            for (ITask iTask : this.tasks) {
                ((AbstractTask)iTask).setReminded(true);
            }
            this.okPressed();
        } else if (buttonId == 201) {
            Object object2 = ((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
            if (object2 != null && object2 instanceof ITask) {
                ITask t = (ITask)object2;
                ((AbstractTask)t).setReminded(true);
                this.tasks.remove(t);
                if (this.tasks.isEmpty()) {
                    this.okPressed();
                } else {
                    this.tableViewer.refresh();
                }
            }
        } else if (buttonId == 202 && (object = ((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement()) != null && object instanceof ITask) {
            ITask t = (ITask)object;
            ((AbstractTask)t).setReminded(false);
            ((AbstractTask)t).setScheduledForDate((DateRange)TaskActivityUtil.getDayOf((Date)new Date(new Date().getTime() + DAY)));
            this.tasks.remove(t);
            if (this.tasks.isEmpty()) {
                this.okPressed();
            } else {
                this.tableViewer.refresh();
            }
        }
        super.buttonPressed(buttonId);
    }

    private static class ReminderTaskSorter
    extends ViewerSorter {
        public static final int DESCRIPTION = 1;
        public static final int PRIORITY = 2;
        public static final int DATE = 3;
        private final int criteria;

        public ReminderTaskSorter(int criteria) {
            this.criteria = criteria;
        }

        public int compare(Viewer viewer, Object obj1, Object obj2) {
            ITask t1 = (ITask)obj1;
            ITask t2 = (ITask)obj2;
            switch (this.criteria) {
                case 1: {
                    return this.compareDescription(t1, t2);
                }
                case 2: {
                    return this.comparePriority(t1, t2);
                }
                case 3: {
                    return this.compareDate((AbstractTask)t1, (AbstractTask)t2);
                }
            }
            return 0;
        }

        private int compareDescription(ITask task1, ITask task2) {
            return task1.getSummary().compareToIgnoreCase(task2.getSummary());
        }

        private int comparePriority(ITask task1, ITask task2) {
            return task1.getPriority().compareTo(task2.getPriority());
        }

        private int compareDate(AbstractTask task1, AbstractTask task2) {
            return task2.getScheduledForDate().compareTo(task1.getScheduledForDate());
        }
    }

    private class ReminderTasksContentProvider
    implements IStructuredContentProvider {
        private ReminderTasksContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return TasksReminderDialog.this.tasks.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ReminderTasksLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ReminderTasksLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ITask) {
                AbstractTask task = (AbstractTask)element;
                switch (columnIndex) {
                    case 0: {
                        return task.getSummary();
                    }
                    case 1: {
                        return task.getPriority();
                    }
                    case 2: {
                        return DateFormat.getDateInstance((int)2).format((Object)task.getScheduledForDate());
                    }
                }
            }
            return null;
        }
    }
}

