/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.ICoreRunnable;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AutomaticRepositoryTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.internal.WorkbenchImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.delete";

    public DeleteAction() {
        super(Messages.DeleteAction_Delete);
        this.setId(ID);
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_DELETE"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void run() {
        this.doDelete(this.getStructuredSelection().toList());
    }

    protected void doDelete(final List<?> toDelete) {
        Object object;
        String elements = "";
        int i = 0;
        for (Object object2 : toDelete) {
            if (object2 instanceof UnmatchedTaskContainer) continue;
            if (++i < 20) {
                if (!(object2 instanceof IRepositoryElement)) continue;
                elements = String.valueOf(elements) + "    " + ((IRepositoryElement)object2).getSummary() + "\n";
                continue;
            }
            elements = String.valueOf(elements) + "...";
            break;
        }
        String message = toDelete.size() == 1 ? ((object = toDelete.get(0)) instanceof ITask ? (((AbstractTask)object).isLocal() ? Messages.DeleteAction_Permanently_delete_the_task_listed_below : Messages.DeleteAction_Delete_the_planning_information_and_context_for_the_repository_task) : (object instanceof TaskCategory ? Messages.DeleteAction_Permanently_delete_the_category : (object instanceof IRepositoryQuery ? Messages.DeleteAction_Permanently_delete_the_query : (object instanceof UnmatchedTaskContainer ? Messages.DeleteAction_Delete_the_planning_information_and_context_of_all_unmatched_tasks : (object instanceof UnsubmittedTaskContainer ? Messages.DeleteAction_Delete_all_of_the_unsubmitted_tasks : Messages.DeleteAction_Permanently_delete_the_element_listed_below))))) : Messages.DeleteAction_Delete_the_elements_listed_below;
        message = String.valueOf(message) + "\n\n" + elements;
        if (toDelete.isEmpty()) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DeleteAction_Delete_failed, (String)Messages.DeleteAction_Nothing_selected);
        } else {
            boolean deleteConfirmed = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DeleteAction_Confirm_Delete, (String)message);
            if (deleteConfirmed) {
                ICoreRunnable op = new ICoreRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            monitor.beginTask(Messages.DeleteAction_Delete_in_progress, -1);
                            DeleteAction.prepareDeletion(toDelete);
                            TasksUiPlugin.getTaskList().run(new ITaskListRunnable(){

                                public void execute(IProgressMonitor monitor) throws CoreException {
                                    DeleteAction.performDeletion(toDelete);
                                }
                            }, monitor);
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                try {
                    CommonUiUtil.runInUi((ICoreRunnable)op, null);
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Problems encountered deleting task list elements: {0}", (Object)e.getMessage()), (Throwable)e);
                    TasksUiInternal.logAndDisplayStatus(Messages.DeleteTaskRepositoryAction_Delete_Task_Repository_Failed, (IStatus)status);
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
        }
    }

    public static void prepareDeletion(Collection<?> toDelete) {
        for (Object selectedObject : toDelete) {
            if (selectedObject instanceof AbstractTask) {
                AbstractTask task = (AbstractTask)selectedObject;
                TasksUi.getTaskActivityManager().deactivateTask((ITask)task);
                TasksUiInternal.closeTaskEditorInAllPages((ITask)task, false);
                continue;
            }
            if (!(selectedObject instanceof AutomaticRepositoryTaskContainer) || toDelete.size() != 1) continue;
            DeleteAction.prepareDeletion(((AutomaticRepositoryTaskContainer)selectedObject).getChildren());
        }
    }

    public static void performDeletion(Collection<?> toDelete) {
        for (Object selectedObject : toDelete) {
            if (selectedObject instanceof AbstractTask) {
                AbstractTask task = (AbstractTask)selectedObject;
                TasksUiInternal.getTaskList().deleteTask((ITask)task);
                try {
                    TasksUiPlugin.getTaskDataManager().deleteTaskData((ITask)task);
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to delete task data", (Throwable)e));
                }
                ContextCore.getContextManager().deleteContext(task.getHandleIdentifier());
                continue;
            }
            if (selectedObject instanceof IRepositoryQuery) {
                TasksUiInternal.getTaskList().deleteQuery((RepositoryQuery)selectedObject);
                continue;
            }
            if (selectedObject instanceof TaskCategory) {
                TasksUiInternal.getTaskList().deleteCategory((AbstractTaskCategory)((TaskCategory)selectedObject));
                continue;
            }
            if (!(selectedObject instanceof AutomaticRepositoryTaskContainer) || toDelete.size() != 1) continue;
            DeleteAction.performDeletion(((AutomaticRepositoryTaskContainer)selectedObject).getChildren());
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        List elements = selection.toList();
        for (Object object : elements) {
            if (!(object instanceof UncategorizedTaskContainer)) continue;
            return false;
        }
        return true;
    }
}

