/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.lang.reflect.Field;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonFormUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonTextSupport;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskAttachmentWizard;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.TaskFormPage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.internal.EditorAreaHelper;
import org.eclipse.ui.internal.WorkbenchPage;

public class EditorUtil {
    private static final int PAGE_H_SCROLL_INCREMENT = 64;
    public static final int HEADER_COLUMN_MARGIN = 6;
    static final String KEY_MARKER = "marker";
    static final String KEY_TEXT_VIEWER = "textViewer";
    public static final int MAXIMUM_HEIGHT = 140;
    public static final int MAXIMUM_WIDTH = 300;
    public static final Font TEXT_FONT = JFaceResources.getDefaultFont();
    public static final String KEY_TOGGLE_TO_MAXIMIZE_ACTION = "maximizeAction";

    static boolean canDoGlobalAction(String actionId, TextViewer textViewer) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            return textViewer.canDoOperation(3);
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            return textViewer.canDoOperation(4);
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            return textViewer.canDoOperation(5);
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            return textViewer.canDoOperation(6);
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            return textViewer.canDoOperation(1);
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            return textViewer.canDoOperation(2);
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            return textViewer.canDoOperation(7);
        }
        return false;
    }

    @Deprecated
    public static boolean canPerformAction(String actionId, Control focusControl) {
        return CommonTextSupport.canPerformAction((String)actionId, (Control)focusControl);
    }

    @Deprecated
    public static void doAction(String actionId, Control focusControl) {
        CommonTextSupport.doAction((String)actionId, (Control)focusControl);
    }

    private static Control findControl(Composite composite, String key) {
        if (!composite.isDisposed()) {
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control found;
                Control child = controlArray[n2];
                if (key.equals(EditorUtil.getMarker((Widget)child))) {
                    return child;
                }
                if (child instanceof Composite && (found = EditorUtil.findControl((Composite)child, key)) != null) {
                    return found;
                }
                ++n2;
            }
        }
        return null;
    }

    private static void focusOn(ScrolledForm form, Control control) {
        int pos = 0;
        control.setEnabled(true);
        control.setFocus();
        control.forceFocus();
        while (control != null && control != form.getBody()) {
            pos += control.getLocation().y;
            control = control.getParent();
        }
        pos -= 60;
        if (!form.getBody().isDisposed()) {
            form.setOrigin(0, pos);
        }
    }

    static DateFormat getDateFormat() {
        return DateFormat.getDateInstance(2);
    }

    static String formatDate(Date date) {
        return EditorUtil.getDateFormat().format(date);
    }

    static String formatDateTime(Date date) {
        return EditorUtil.getDateTimeFormat().format(date);
    }

    static DateFormat getDateTimeFormat() {
        return DateFormat.getDateTimeInstance(2, 3);
    }

    public static Control getFocusControl(IFormPage page) {
        if (page == null) {
            return null;
        }
        IManagedForm form = page.getManagedForm();
        if (form == null) {
            return null;
        }
        ScrolledForm control = form.getForm();
        if (control == null || control.isDisposed()) {
            return null;
        }
        Display display = control.getDisplay();
        Control focusControl = display.getFocusControl();
        if (focusControl == null || focusControl.isDisposed()) {
            return null;
        }
        return focusControl;
    }

    public static String getMarker(Widget widget) {
        return (String)widget.getData(KEY_MARKER);
    }

    @Deprecated
    public static TextViewer getTextViewer(Widget widget) {
        return CommonTextSupport.getTextViewer((Widget)widget);
    }

    public static NewAttachmentWizardDialog openNewAttachmentWizard(final AbstractTaskEditorPage page, TaskAttachmentWizard.Mode mode, AbstractTaskAttachmentSource source) {
        TaskAttributeMapper mapper = page.getModel().getTaskData().getAttributeMapper();
        TaskAttribute attribute = mapper.createTaskAttachment(page.getModel().getTaskData());
        final NewAttachmentWizardDialog dialog = TasksUiInternal.openNewAttachmentWizard(page.getSite().getShell(), page.getTaskRepository(), page.getTask(), attribute, mode, source);
        dialog.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (dialog.getReturnCode() == 0) {
                    page.getTaskEditor().refreshPages();
                }
            }
        });
        return dialog;
    }

    public static boolean reveal(ScrolledForm form, String key) {
        Control control = EditorUtil.findControl(form.getBody(), key);
        if (control != null) {
            ExpandableComposite ex;
            if (control instanceof ExpandableComposite && !(ex = (ExpandableComposite)control).isExpanded()) {
                CommonFormUtil.setExpanded((ExpandableComposite)ex, (boolean)true);
            }
            Composite comp = control.getParent();
            while (comp != null) {
                if (comp instanceof Section) {
                    if (!((Section)comp).isExpanded()) {
                        ((Section)comp).setExpanded(true);
                    }
                } else if (comp instanceof ExpandableComposite) {
                    ExpandableComposite ex2 = (ExpandableComposite)comp;
                    if (!ex2.isExpanded()) {
                        CommonFormUtil.setExpanded((ExpandableComposite)ex2, (boolean)true);
                    }
                    if (ex2.getData() != null && ex2.getData() instanceof Composite) {
                        ((Composite)ex2.getData()).setVisible(true);
                    }
                }
                comp = comp.getParent();
            }
            EditorUtil.focusOn(form, control);
        }
        return true;
    }

    @Deprecated
    public static void setEnabledState(Composite composite, boolean enabled) {
        CommonUiUtil.setEnabled((Composite)composite, (boolean)enabled);
    }

    public static void setMarker(Widget widget, String text) {
        widget.setData(KEY_MARKER, (Object)text);
    }

    @Deprecated
    public static void setTextViewer(Widget widget, TextViewer textViewer) {
        CommonTextSupport.setTextViewer((Widget)widget, (TextViewer)textViewer);
    }

    @Deprecated
    public static void toggleExpandableComposite(boolean expanded, ExpandableComposite comp) {
        CommonFormUtil.setExpanded((ExpandableComposite)comp, (boolean)expanded);
    }

    @Deprecated
    public static void disableScrollingOnFocus(ScrolledForm form) {
        CommonFormUtil.disableScrollingOnFocus((ScrolledForm)form);
    }

    @Deprecated
    public static void ensureVisible(Control control) {
        CommonFormUtil.ensureVisible((Control)control);
    }

    public static void reflow(Control control) {
        Composite c = control.getParent();
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite) break;
        }
        for (c = control.getParent(); c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof SharedScrolledComposite)) continue;
            ((SharedScrolledComposite)c).reflow(true);
            break;
        }
        c = control.getParent();
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite) break;
        }
    }

    public static Composite getLayoutAdvisor(AbstractTaskEditorPage page) {
        Composite layoutAdvisor = page.getEditorComposite();
        while (!((layoutAdvisor = layoutAdvisor.getParent()) instanceof CTabFolder)) {
        }
        return layoutAdvisor.getParent();
    }

    @Deprecated
    public static void setMenu(Composite composite, Menu menu) {
        CommonUiUtil.setMenu((Composite)composite, (Menu)menu);
    }

    public static void center(RowLayout rowLayout) {
        try {
            Field field = RowLayout.class.getDeclaredField("center");
            field.set(rowLayout, Boolean.TRUE);
        }
        catch (Throwable throwable) {}
    }

    public static Composite createBorder(Composite composite, final FormToolkit toolkit, boolean paintBorder) {
        final Composite roundedBorder = toolkit.createComposite(composite);
        if (paintBorder) {
            roundedBorder.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setForeground(toolkit.getColors().getBorderColor());
                    Point size = roundedBorder.getSize();
                    e.gc.drawRoundRectangle(0, 2, size.x - 1, size.y - 5, 5, 5);
                }
            });
            roundedBorder.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(4, 6).create());
        } else {
            roundedBorder.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 6).create());
        }
        GridDataFactory.fillDefaults().align(4, 1).hint(300, -1).grab(true, false).applyTo((Control)roundedBorder);
        return roundedBorder;
    }

    public static Composite createBorder(Composite composite, FormToolkit toolkit) {
        return EditorUtil.createBorder(composite, toolkit, true);
    }

    public static Font setHeaderFontSizeAndStyle(Control text) {
        FontData[] fontData;
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(text);
        float sizeFactor = 1.1f;
        Font initialFont = text.getFont();
        FontData[] fontDataArray = fontData = initialFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData element = fontDataArray[n2];
            element.setHeight((int)((float)element.getHeight() * sizeFactor));
            element.setStyle(element.getStyle() | 1);
            ++n2;
        }
        final Font textFont = new Font((Device)text.getDisplay(), fontData);
        text.setFont(textFont);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                textFont.dispose();
            }
        });
        Color color = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.completed");
        text.setForeground(color);
        return textFont;
    }

    public static GridData getTextControlLayoutData(TaskFormPage page, Control control, boolean expandVertically) {
        GridData gd = new GridData();
        int width = EditorUtil.getEditorWidth(page);
        Point size = control.computeSize(width, -1, true);
        gd.widthHint = 300;
        gd.minimumWidth = 300;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = Math.min(Math.max(140, size.y), 420);
        if (expandVertically) {
            gd.verticalAlignment = 4;
            gd.grabExcessVerticalSpace = true;
        }
        return gd;
    }

    private static int getEditorWidth(TaskFormPage page) {
        EditorAreaHelper editorManager;
        int widthHint = 0;
        if (page.getManagedForm() != null && page.getManagedForm().getForm() != null) {
            widthHint = page.getManagedForm().getForm().getClientArea().width - 90;
        }
        if (widthHint <= 0 && page.getEditor().getEditorSite() != null && page.getEditor().getEditorSite().getPage() != null && (editorManager = ((WorkbenchPage)page.getEditor().getEditorSite().getPage()).getEditorPresentation()) != null && editorManager.getLayoutPart() != null) {
            widthHint = editorManager.getLayoutPart().getControl().getBounds().width - 90;
        }
        if (widthHint <= 0) {
            widthHint = 300;
        }
        return widthHint;
    }

    public static GridLayout createSectionClientLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginTop = 2;
        layout.marginBottom = 8;
        return layout;
    }

    public static void initializeScrollbars(ScrolledForm form) {
        ScrollBar hbar = form.getHorizontalBar();
        if (hbar != null) {
            hbar.setIncrement(64);
        }
    }
}

