/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.util.ImportExportUtil;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;

public class TaskDragSourceListener
extends DragSourceAdapter {
    private IStructuredSelection currentSelection;
    private final ISelectionProvider selectionProvider;

    public TaskDragSourceListener(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.selectionProvider.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.currentSelection = (IStructuredSelection)selection;
            for (Object item : this.currentSelection) {
                if (!(item instanceof AbstractTask)) continue;
                AbstractTask task = (AbstractTask)item;
                for (AbstractTaskContainer container : task.getParentContainers()) {
                    if (!(container instanceof UnsubmittedTaskContainer)) continue;
                    event.doit = false;
                    return;
                }
            }
        } else {
            this.currentSelection = null;
            event.doit = false;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (this.currentSelection == null || this.currentSelection.isEmpty()) {
            return;
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            LocalSelectionTransfer.getTransfer().setSelection((ISelection)this.currentSelection);
        } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
            try {
                File file = File.createTempFile("mylyn-tasks", ".xml.zip");
                file.deleteOnExit();
                ImportExportUtil.export(file, this.currentSelection);
                String[] paths = new String[]{file.getAbsolutePath()};
                event.data = paths;
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Problems encountered dragging task", (Throwable)e));
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Problems encountered dragging task", (Throwable)e));
            }
        } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = CopyTaskDetailsAction.getTextForTask(this.currentSelection.getFirstElement());
        }
    }

    public void dragFinished(DragSourceEvent event) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            LocalSelectionTransfer.getTransfer().setSelection(null);
        }
    }
}

