/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.registry.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.eclipse.swordfish.registry.InMemoryRepository;
import org.eclipse.swordfish.registry.PolicyResource;
import org.eclipse.swordfish.registry.domain.Binding;
import org.eclipse.swordfish.registry.domain.BindingImpl;
import org.eclipse.swordfish.registry.domain.Definition;
import org.eclipse.swordfish.registry.domain.PolicyExtension;
import org.eclipse.swordfish.registry.domain.PortType;
import org.eclipse.swordfish.registry.domain.PortTypeImpl;
import org.eclipse.swordfish.registry.domain.Service;
import org.eclipse.swordfish.registry.domain.ServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionImpl
implements Definition {
    private String id;
    private javax.wsdl.Definition wsdl4j;

    public DefinitionImpl(String id, javax.wsdl.Definition wsdl4j) {
        this.id = id;
        this.wsdl4j = wsdl4j;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Iterable<PortType> getAllPortTypes() {
        ArrayList<PortType> allPortTypes = new ArrayList<PortType>();
        Collection allWsdl4jPortTypes = this.wsdl4j.getPortTypes().values();
        for (javax.wsdl.PortType wsdl4jPortType : allWsdl4jPortTypes) {
            if (wsdl4jPortType.isUndefined()) continue;
            allPortTypes.add(new PortTypeImpl(wsdl4jPortType, (Definition)this));
        }
        return allPortTypes;
    }

    @Override
    public PortType getPortType(QName portTypeName) {
        javax.wsdl.PortType wsdl4jPortType = this.wsdl4j.getPortType(portTypeName);
        if (wsdl4jPortType != null && !wsdl4jPortType.isUndefined()) {
            return new PortTypeImpl(wsdl4jPortType, (Definition)this);
        }
        return null;
    }

    @Override
    public Iterable<Binding> getBindingsWithType(QName portTypeName) {
        ArrayList<Binding> result = new ArrayList<Binding>();
        Collection bindings = this.wsdl4j.getBindings().values();
        for (javax.wsdl.Binding binding : bindings) {
            javax.wsdl.PortType portType;
            if (binding.isUndefined() || !(portType = binding.getPortType()).getQName().equals(portTypeName)) continue;
            result.add(new BindingImpl(binding, (Definition)this));
        }
        return result;
    }

    @Override
    public Iterable<Service> getServicesWithBinding(QName bindingName) {
        ArrayList<Service> result = new ArrayList<Service>();
        Collection services = this.wsdl4j.getServices().values();
        for (javax.wsdl.Service service : services) {
            Collection ports = service.getPorts().values();
            for (Port port : ports) {
                javax.wsdl.Binding binding = port.getBinding();
                if (!binding.getQName().equals(bindingName)) continue;
                result.add(new ServiceImpl(service, (Definition)this));
            }
        }
        return result;
    }

    @Override
    public Iterable<PolicyResource> getPoliciesForBinding(QName bindingName) {
        javax.wsdl.Binding binding = this.wsdl4j.getBinding(bindingName);
        if (binding != null) {
            return this.getPoliciesForBinding(binding);
        }
        return Collections.emptyList();
    }

    private Iterable<PolicyResource> getPoliciesForBinding(javax.wsdl.Binding binding) {
        ArrayList<PolicyResource> policyResources = new ArrayList<PolicyResource>();
        for (ExtensibilityElement extensibilityEl : binding.getExtensibilityElements()) {
            if (!(extensibilityEl instanceof PolicyExtension)) continue;
            PolicyExtension policy = (PolicyExtension)extensibilityEl;
            policyResources.add(new PolicyResource(policy.getId(), policy.getPolicy()));
        }
        return policyResources;
    }

    @Override
    public void register(InMemoryRepository repository) {
        repository.registerWSDLDefinition(this.id, this);
        Collection portTypes = this.wsdl4j.getPortTypes().values();
        for (javax.wsdl.PortType portType : portTypes) {
            if (portType.isUndefined()) continue;
            repository.registerPortTypeWSDL(portType.getQName(), this);
        }
        Collection bindings = this.wsdl4j.getBindings().values();
        for (javax.wsdl.Binding binding : bindings) {
            if (binding.isUndefined()) continue;
            for (PolicyResource policyResource : this.getPoliciesForBinding(binding)) {
                repository.registerPolicy(policyResource);
            }
        }
    }

    @Override
    public void deregister(InMemoryRepository repository) {
        repository.deregisterWSDLDefinition(this.id);
        Collection portTypes = this.wsdl4j.getPortTypes().values();
        for (javax.wsdl.PortType portType : portTypes) {
            if (portType.isUndefined()) continue;
            repository.deregisterPortTypeWSDL(portType.getQName(), this);
        }
        Collection bindings = this.wsdl4j.getBindings().values();
        for (javax.wsdl.Binding binding : bindings) {
            if (binding.isUndefined()) continue;
            for (PolicyResource policyResource : this.getPoliciesForBinding(binding)) {
                repository.registerPolicy(policyResource);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DefinitionImpl)) {
            return false;
        }
        DefinitionImpl other = (DefinitionImpl)obj;
        return this.wsdl4j == other.wsdl4j;
    }

    public int hashCode() {
        return this.wsdl4j.hashCode();
    }

    public String toString() {
        return "DefinitionImpl[" + this.wsdl4j + "]";
    }
}

