/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.api.tools.internal.model.PluginProjectApiComponent;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.builder.IApiProblemDetector;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;

public abstract class AbstractProblemDetector
implements IApiProblemDetector {
    protected static boolean DEBUG = Util.DEBUG;
    private List fPotentialProblems = new LinkedList();

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    protected void retainReference(IReference reference) {
        this.fPotentialProblems.add(reference);
    }

    protected List getRetainedReferences() {
        return this.fPotentialProblems;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IApiProblem createProblem(IReference reference, IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        if (ApiPlugin.getDefault().getSeverityLevel(this.getSeverityKey(), project) == 0) {
            return null;
        }
        try {
            String lookupName = this.getTypeName(reference.getMember()).replace('$', '.');
            IType type = javaProject.findType(lookupName, (IProgressMonitor)new NullProgressMonitor());
            if (type == null) {
                return null;
            }
            ICompilationUnit compilationUnit = type.getCompilationUnit();
            if (compilationUnit == null) {
                return null;
            }
            IResource resource = Util.getResource(project, type);
            if (resource == null) {
                return null;
            }
            int charStart = -1;
            int charEnd = -1;
            int lineNumber = reference.getLineNumber();
            ICompilationUnit element = compilationUnit;
            if (!Util.isManifest(resource.getProjectRelativePath()) && !type.isBinary()) {
                IDocument document = Util.getDocument(compilationUnit);
                if (lineNumber > 0) {
                    --lineNumber;
                }
                try {
                    Position pos = this.getSourceRange(type, document, reference);
                    if (pos != null && (charStart = pos.getOffset()) != -1) {
                        charEnd = charStart + pos.getLength();
                        lineNumber = document.getLineOfOffset(charStart);
                    }
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                    return null;
                }
                catch (BadLocationException e) {
                    ApiPlugin.log(e);
                    return null;
                }
                if (charStart > -1) {
                    element = compilationUnit.getElementAt(charStart);
                }
            }
            return ApiProblemFactory.newApiUsageProblem(resource.getProjectRelativePath().toPortableString(), type.getFullyQualifiedName(), this.getMessageArgs(reference), new String[]{"org.eclipse.jdt.internal.core.JavaModelManager.handleId", "apiMarkerID"}, new Object[]{element == null ? compilationUnit.getHandleIdentifier() : element.getHandleIdentifier(), new Integer(3)}, lineNumber, charStart, charEnd, this.getElementType(reference), this.getProblemKind(), this.getProblemFlags(reference));
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
            return null;
        }
    }

    protected abstract Position getSourceRange(IType var1, IDocument var2, IReference var3) throws CoreException, BadLocationException;

    protected abstract int getElementType(IReference var1);

    protected abstract int getProblemFlags(IReference var1);

    protected abstract String[] getMessageArgs(IReference var1) throws CoreException;

    protected abstract String[] getQualifiedMessageArgs(IReference var1) throws CoreException;

    protected abstract int getProblemKind();

    protected abstract String getSeverityKey();

    protected String getTypeName(IApiMember member) throws CoreException {
        switch (member.getType()) {
            case 2: {
                IApiType type = (IApiType)member;
                if (type.isAnonymous()) {
                    return this.getTypeName(member.getEnclosingType());
                }
                if (type.isLocal()) {
                    return this.getTypeName(member.getEnclosingType());
                }
                return member.getName();
            }
        }
        return this.getTypeName(member.getEnclosingType());
    }

    protected String getQualifiedTypeName(IApiMember member) throws CoreException {
        switch (member.getType()) {
            case 2: {
                IApiType type = (IApiType)member;
                if (type.isAnonymous()) {
                    return this.getQualifiedTypeName(member.getEnclosingType());
                }
                if (type.isLocal()) {
                    String name = this.getTypeName(member.getEnclosingType());
                    int idx = name.indexOf(36);
                    if (idx > -1) {
                        return name.substring(0, idx);
                    }
                    return name;
                }
                return Signatures.getQualifiedTypeSignature((IApiType)member);
            }
        }
        return this.getQualifiedTypeName(member.getEnclosingType());
    }

    protected String getSimpleTypeName(IApiMember member) throws CoreException {
        switch (member.getType()) {
            case 2: {
                IApiType type = (IApiType)member;
                if (type.isAnonymous()) {
                    return this.getSimpleTypeName(type.getEnclosingType());
                }
                if (type.isLocal()) {
                    String name = this.getSimpleTypeName(member.getEnclosingType());
                    int idx = name.indexOf(36);
                    if (idx > -1) {
                        return name.substring(0, idx);
                    }
                    return name;
                }
                return Signatures.getTypeName(Signatures.getTypeSignature(type));
            }
        }
        return this.getSimpleTypeName(member.getEnclosingType());
    }

    protected Position defaultSourcePosition(IType type, IReference reference) throws CoreException {
        ISourceRange range;
        if (type != null && (range = type.getNameRange()) != null) {
            return new Position(range.getOffset(), range.getLength());
        }
        return null;
    }

    protected int findMethodNameStart(String namepart, String line, int index) {
        int start = line.indexOf(namepart, index);
        if (start < 0) {
            return -1;
        }
        int offset = start + namepart.length();
        while (line.charAt(offset) == ' ') {
            ++offset;
        }
        if (line.charAt(offset) == '(' || line.charAt(offset) == '<') {
            return start;
        }
        return this.findMethodNameStart(namepart, line, offset);
    }

    public List createProblems() {
        List references = this.getRetainedReferences();
        LinkedList<IApiProblem> problems = new LinkedList<IApiProblem>();
        Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            IReference reference = (IReference)iterator.next();
            if (reference.getResolvedReference() == null || !this.isProblem(reference)) continue;
            try {
                IApiProblem problem = null;
                IApiComponent component = reference.getMember().getApiComponent();
                if (component instanceof PluginProjectApiComponent) {
                    PluginProjectApiComponent ppac = (PluginProjectApiComponent)component;
                    IJavaProject project = ppac.getJavaProject();
                    problem = this.createProblem(reference, project);
                } else {
                    problem = this.createProblem(reference);
                }
                if (problem == null) continue;
                problems.add(problem);
            }
            catch (CoreException e) {
                ApiPlugin.log(e.getStatus());
            }
        }
        return problems;
    }

    protected boolean isProblem(IReference reference) {
        IApiMember member = reference.getResolvedReference();
        if (member != null) {
            IApiMember local = reference.getMember();
            try {
                IApiComponent lcomp = local.getApiComponent();
                if (lcomp != null && lcomp.isFragment()) {
                    return !lcomp.getHost().equals(member.getApiComponent());
                }
            }
            catch (CoreException ce) {
                ApiPlugin.log(ce);
            }
        }
        return true;
    }

    protected IMethod findMethodInType(IType type, IApiMethod method) throws JavaModelException, CoreException {
        String[] parameterTypes = Signature.getParameterTypes((String)method.getSignature());
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = parameterTypes[i].replace('/', '.');
            ++i;
        }
        String methodname = method.getName();
        if (method.isConstructor()) {
            IApiType enclosingType = method.getEnclosingType();
            if (enclosingType.isMemberType() && !Flags.isStatic((int)enclosingType.getModifiers())) {
                int length = parameterTypes.length - 1;
                String[] stringArray = parameterTypes;
                parameterTypes = new String[length];
                System.arraycopy(stringArray, 1, parameterTypes, 0, length);
            }
            methodname = enclosingType.getSimpleName();
        }
        IMethod Qmethod = type.getMethod(methodname, parameterTypes);
        IMethod[] methods = type.getMethods();
        IMethod match = null;
        int i2 = 0;
        while (i2 < methods.length) {
            IMethod m = methods[i2];
            if (m.isSimilar(Qmethod)) {
                match = m;
                break;
            }
            ++i2;
        }
        return match;
    }

    protected Position getSourceRangeForMethod(IType type, IReference reference, IApiMethod method) throws CoreException, JavaModelException {
        ISourceRange range;
        IMethod match = this.findMethodInType(type, method);
        Position pos = null;
        if (match != null && (range = match.getNameRange()) != null) {
            pos = new Position(range.getOffset(), range.getLength());
        }
        if (pos == null) {
            return this.defaultSourcePosition(type, reference);
        }
        return pos;
    }

    protected Position getSourceRangeForField(IType type, IReference reference, IApiField field) throws JavaModelException, CoreException {
        ISourceRange range;
        IField javaField = type.getField(field.getName());
        Position pos = null;
        if (javaField.exists() && (range = javaField.getNameRange()) != null) {
            pos = new Position(range.getOffset(), range.getLength());
        }
        if (pos == null) {
            return this.defaultSourcePosition(type, reference);
        }
        return pos;
    }

    protected Position getFieldNameRange(IApiField field, IDocument document, IReference reference) throws BadLocationException, CoreException {
        return this.getFieldNameRange(field.getEnclosingType().getName(), field.getName(), document, reference);
    }

    protected Position getFieldNameRange(String typeName, String fieldName, IDocument document, IReference reference) throws BadLocationException, CoreException {
        int linenumber = reference.getLineNumber();
        if (linenumber > 0) {
            --linenumber;
        }
        if (linenumber > 0) {
            String qname;
            int offset = document.getLineOffset(linenumber);
            String line = document.get(offset, document.getLineLength(linenumber));
            int first = line.indexOf(qname = String.valueOf(typeName) + "." + fieldName);
            if (first < 0) {
                qname = "super." + fieldName;
                first = line.indexOf(qname);
            }
            if (first < 0) {
                qname = "this." + fieldName;
                first = line.indexOf(qname);
            }
            if (first < 0) {
                int idx = line.indexOf(fieldName);
                while (idx > -1) {
                    if (line.charAt(idx - 1) == '.') {
                        first = idx;
                        qname = fieldName;
                        break;
                    }
                    idx = line.indexOf(fieldName, idx + 1);
                }
            }
            Position pos = null;
            pos = first > -1 ? new Position(offset + first, qname.length()) : new Position(offset, line.length());
            return pos;
        }
        return null;
    }

    protected Position getMethodNameRange(boolean isContructor, String name, IDocument document, IReference reference) throws CoreException, BadLocationException {
        int first;
        int offset;
        String line;
        int start;
        String methodname;
        int idx;
        int linenumber = reference.getLineNumber();
        if (linenumber > 0) {
            --linenumber;
        }
        if ((idx = (methodname = name).indexOf(36)) > -1) {
            methodname = methodname.substring(0, idx);
        }
        if ((idx = methodname.indexOf(Signatures.getLT())) > -1) {
            methodname = methodname.substring(0, idx);
        }
        if ((start = (line = document.get(offset = document.getLineOffset(linenumber), document.getLineLength(linenumber))).indexOf(61)) < 0) {
            if (isContructor) {
                start = line.indexOf("new");
                if (start < 0) {
                    start = 0;
                }
            } else {
                start = 0;
            }
        } else {
            char charat = line.charAt(start - 1);
            if (line.charAt(start + 1) == '=' || charat == '!' || charat == '<' || charat == '>') {
                start = 0;
            }
        }
        if ((first = this.findMethodNameStart(methodname, line, start)) < 0) {
            methodname = "super";
            first = this.findMethodNameStart(methodname, line, start);
        }
        if (first > -1) {
            return new Position(offset + first, methodname.length());
        }
        return null;
    }

    protected IApiProblem createProblem(IReference reference) throws CoreException {
        int lineNumber = reference.getLineNumber();
        if (lineNumber > 0) {
            --lineNumber;
        }
        String ltypename = this.getTypeName(reference.getMember());
        return ApiProblemFactory.newApiUsageProblem(null, ltypename, this.getQualifiedMessageArgs(reference), new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, this.getElementType(reference), this.getProblemKind(), this.getProblemFlags(reference));
    }
}

