/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import com.ibm.icu.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.builder.ProblemDetectorBuilder;
import org.eclipse.pde.api.tools.internal.builder.ReferenceResolver;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IApiProblemDetector;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ReferenceAnalyzer {
    private static final double LOG2 = Math.log(2.0);
    private static boolean DEBUG = Util.DEBUG;
    private static final IApiProblem[] EMPTY_RESULT = new IApiProblem[0];
    private static final IApiProblemDetector[] NO_PROBLEM_DETECTORS = new IApiProblemDetector[0];
    private MultiStatus fStatus;
    private int fAllReferenceKinds = 0;
    private List fReferences = new LinkedList();
    private IApiProblemDetector[][] fIndexedDetectors;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    private IApiProblem[] analyze(IApiTypeContainer scope, IApiProblemDetector[] detectors, IProgressMonitor monitor) throws CoreException {
        try {
            this.indexProblemDetectors(detectors);
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.ReferenceAnalyzer_analyzing_api, (int)3);
            localMonitor.subTask(BuilderMessages.ReferenceAnalyzer_analyzing_api_checking_use);
            this.extractReferences(scope, (IProgressMonitor)localMonitor);
            localMonitor.worked(1);
            if (localMonitor.isCanceled()) {
                IApiProblem[] iApiProblemArray = EMPTY_RESULT;
                return iApiProblemArray;
            }
            localMonitor.subTask(BuilderMessages.ReferenceAnalyzer_analyzing_api_checking_use);
            if (this.fReferences.size() != 0) {
                ReferenceResolver.resolveReferences(this.fReferences, (IProgressMonitor)localMonitor);
            }
            localMonitor.worked(1);
            if (localMonitor.isCanceled()) {
                IApiProblem[] iApiProblemArray = EMPTY_RESULT;
                return iApiProblemArray;
            }
            LinkedList allProblems = new LinkedList();
            localMonitor.subTask(BuilderMessages.ReferenceAnalyzer_analyzing_api_checking_use);
            int i = 0;
            while (i < detectors.length) {
                IApiProblemDetector detector = detectors[i];
                List problems = detector.createProblems();
                allProblems.addAll(problems);
                if (localMonitor.isCanceled()) {
                    IApiProblem[] iApiProblemArray = EMPTY_RESULT;
                    return iApiProblemArray;
                }
                ++i;
            }
            IApiProblem[] array = allProblems.toArray(new IApiProblem[allProblems.size()]);
            localMonitor.worked(1);
            localMonitor.done();
            IApiProblem[] iApiProblemArray = array;
            return iApiProblemArray;
        }
        finally {
            this.fIndexedDetectors = null;
            this.fReferences.clear();
        }
    }

    private void indexProblemDetectors(IApiProblemDetector[] detectors) {
        this.fIndexedDetectors = new IApiProblemDetector[32][];
        int i = 0;
        while (i < detectors.length) {
            IApiProblemDetector detector = detectors[i];
            int kinds = detector.getReferenceKinds();
            this.fAllReferenceKinds |= kinds;
            int mask = 1;
            int bit = 0;
            while (bit < 32) {
                if ((mask & kinds) > 0) {
                    IApiProblemDetector[] indexed = this.fIndexedDetectors[bit];
                    if (indexed == null) {
                        this.fIndexedDetectors[bit] = new IApiProblemDetector[]{detector};
                    } else {
                        IApiProblemDetector[] next = new IApiProblemDetector[indexed.length + 1];
                        System.arraycopy(indexed, 0, next, 0, indexed.length);
                        next[indexed.length] = detector;
                        this.fIndexedDetectors[bit] = next;
                    }
                }
                mask <<= 1;
                ++bit;
            }
            ++i;
        }
    }

    private int getLog2(int bitConstant) {
        double logX = Math.log(bitConstant);
        double pow = logX / LOG2;
        return (int)Math.round(pow);
    }

    private void extractReferences(IApiTypeContainer scope, IProgressMonitor monitor) throws CoreException {
        this.fStatus = new MultiStatus("org.eclipse.pde.api.tools", 0, BuilderMessages.ReferenceAnalyzer_api_analysis_error, null);
        String[] packageNames = scope.getPackageNames();
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)packageNames.length);
        Visitor visitor = new Visitor((IProgressMonitor)localMonitor);
        long start = System.currentTimeMillis();
        try {
            scope.accept(visitor);
        }
        catch (CoreException e) {
            this.fStatus.add(e.getStatus());
        }
        long end = System.currentTimeMillis();
        if (!this.fStatus.isOK()) {
            throw new CoreException((IStatus)this.fStatus);
        }
        localMonitor.done();
        if (DEBUG) {
            System.out.println("Reference Analyzer: extracted " + this.fReferences.size() + " references in " + (end - start) + "ms");
        }
    }

    public IApiProblem[] analyze(IApiComponent component, IApiTypeContainer scope, IProgressMonitor monitor) throws CoreException {
        IApiProblemDetector[] detectors = this.buildProblemDetectors(component);
        return this.analyze(scope, detectors, monitor);
    }

    private IApiProblemDetector[] buildProblemDetectors(IApiComponent component) {
        try {
            long start = System.currentTimeMillis();
            IApiComponent[] components = component.getBaseline().getPrerequisiteComponents(new IApiComponent[]{component});
            final ProblemDetectorBuilder visitor = new ProblemDetectorBuilder(component);
            int i = 0;
            while (i < components.length) {
                IApiComponent prereq = components[i];
                if (!prereq.equals(component)) {
                    visitor.setOwningComponent(prereq);
                    try {
                        prereq.getApiDescription().accept(visitor);
                    }
                    catch (CoreException e) {
                        ApiPlugin.log(e.getStatus());
                    }
                }
                ++i;
            }
            long end = System.currentTimeMillis();
            if (DEBUG) {
                System.out.println("Time to build problem detectors: " + (end - start) + "ms");
            }
            ApiDescriptionVisitor nameVisitor = new ApiDescriptionVisitor(){

                public boolean visitElement(IElementDescriptor element, IApiAnnotations description) {
                    if (element.getElementType() == 1 && VisibilityModifiers.isPrivate(description.getVisibility())) {
                        visitor.addNonApiPackageName(((IPackageDescriptor)element).getName());
                    }
                    return false;
                }
            };
            component.getApiDescription().accept(nameVisitor);
            List detectors = visitor.getProblemDetectors();
            int size = detectors.size();
            if (size == 0) {
                return NO_PROBLEM_DETECTORS;
            }
            return detectors.toArray(new IApiProblemDetector[size]);
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
            return NO_PROBLEM_DETECTORS;
        }
    }

    class Visitor
    extends ApiTypeContainerVisitor {
        private IProgressMonitor fMonitor = null;

        public Visitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public boolean visitPackage(String packageName) {
            this.fMonitor.subTask(MessageFormat.format((String)BuilderMessages.ReferenceAnalyzer_checking_api_used_by, (Object[])new String[]{packageName}));
            return true;
        }

        public void endVisitPackage(String packageName) {
            this.fMonitor.worked(1);
        }

        public void visit(String packageName, IApiTypeRoot classFile) {
            if (!this.fMonitor.isCanceled()) {
                try {
                    if (classFile.getTypeName().indexOf(36) > -1) {
                        return;
                    }
                    IApiType type = classFile.getStructure();
                    List references = type.extractReferences(ReferenceAnalyzer.this.fAllReferenceKinds, null);
                    Iterator iterator = references.iterator();
                    while (iterator.hasNext()) {
                        IReference ref = (IReference)iterator.next();
                        int index = ReferenceAnalyzer.this.getLog2(ref.getReferenceKind());
                        IApiProblemDetector[] detectors = ReferenceAnalyzer.this.fIndexedDetectors[index];
                        boolean added = false;
                        if (detectors == null) continue;
                        int i = 0;
                        while (i < detectors.length) {
                            IApiProblemDetector detector = detectors[i];
                            if (detector.considerReference(ref) && !added) {
                                ReferenceAnalyzer.this.fReferences.add(ref);
                                added = true;
                            }
                            ++i;
                        }
                    }
                }
                catch (CoreException e) {
                    ReferenceAnalyzer.this.fStatus.add(e.getStatus());
                }
            }
        }
    }
}

