/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.model.TypeStructureBuilder;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Util;

public abstract class AbstractApiTypeRoot
extends ApiElement
implements IApiTypeRoot {
    protected AbstractApiTypeRoot(IApiElement parent, String name) {
        super(parent, 7, name);
    }

    public byte[] getContents() throws CoreException {
        InputStream inputStream = this.getInputStream();
        try {
            byte[] byArray = Util.getInputStreamAsByteArray(inputStream, -1);
            return byArray;
        }
        catch (IOException e) {
            this.abort("Unable to read class file: " + this.getTypeName(), e);
            return null;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
        }
    }

    public abstract InputStream getInputStream() throws CoreException;

    public IApiType getStructure() throws CoreException {
        return TypeStructureBuilder.buildTypeStructure(this.getContents(), this.getApiComponent(), this);
    }

    public IApiComponent getApiComponent() {
        return (IApiComponent)this.getAncestor(1);
    }
}

