/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.AbstractApiTypeRoot;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;

public class DirectoryApiTypeContainer
extends ApiElement
implements IApiTypeContainer {
    private Map fPackages;
    private String[] fPackageNames;

    public DirectoryApiTypeContainer(IApiElement parent, String location) {
        super(parent, 3, location);
    }

    /*
     * Unable to fully structure code
     */
    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        this.init();
        packageNames = this.getPackageNames();
        i = 0;
        while (i < packageNames.length) {
            pkg = packageNames[i];
            if (visitor.visitPackage(pkg)) {
                location = (String)this.fPackages.get(pkg);
                if (location != null && (dir = new File(location)).exists()) {
                    files = dir.listFiles(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isFile() && file.getName().endsWith(".class");
                        }
                    });
                    if (files != null) {
                        classFiles = new ArrayList<LocalApiTypeRoot>();
                        j = 0;
                        while (j < files.length) {
                            name = files[j].getName();
                            typeName = name.substring(0, name.length() - 6);
                            if (pkg.length() > 0) {
                                typeName = String.valueOf(pkg) + "." + typeName;
                            }
                            classFiles.add(new LocalApiTypeRoot(this, files[j].getAbsolutePath(), typeName));
                            ++j;
                        }
                        Collections.sort(classFiles);
                        cfIterator = classFiles.iterator();
                        while (cfIterator.hasNext()) {
                            classFile = (IApiTypeRoot)cfIterator.next();
                            visitor.visit(pkg, classFile);
                            visitor.end(pkg, classFile);
                        }
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else lbl-1000:
            // 4 sources

            {
                visitor.endVisitPackage(pkg);
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Directory Class File Container: " + this.getName());
        return buff.toString();
    }

    public synchronized void close() throws CoreException {
        this.fPackages = null;
        this.fPackageNames = null;
    }

    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        File file;
        String location;
        this.init();
        int index = qualifiedName.lastIndexOf(46);
        String cfName = qualifiedName;
        String pkg = "";
        if (index > 0) {
            pkg = qualifiedName.substring(0, index);
            cfName = qualifiedName.substring(index + 1);
        }
        if ((location = (String)this.fPackages.get(pkg)) != null && (file = new File(location, String.valueOf(cfName) + ".class")).exists()) {
            return new LocalApiTypeRoot(this, file.getAbsolutePath(), qualifiedName);
        }
        return null;
    }

    public String[] getPackageNames() throws CoreException {
        this.init();
        if (this.fPackageNames == null) {
            ArrayList names = new ArrayList(this.fPackages.keySet());
            Object[] result = new String[names.size()];
            names.toArray(result);
            Arrays.sort(result);
            this.fPackageNames = result;
        }
        return this.fPackageNames;
    }

    private synchronized void init() {
        if (this.fPackages == null) {
            this.fPackages = new HashMap();
            this.processDirectory("", new File(this.getName()));
        }
    }

    private void processDirectory(String packageName, File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            boolean hasClassFiles = false;
            ArrayList<File> dirs = new ArrayList<File>();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory()) {
                    dirs.add(file.getAbsoluteFile());
                } else if (!hasClassFiles && file.getName().endsWith(".class")) {
                    this.fPackages.put(packageName, dir.getAbsolutePath());
                    hasClassFiles = true;
                }
                ++i;
            }
            Iterator iterator = dirs.iterator();
            while (iterator.hasNext()) {
                File child = (File)iterator.next();
                String nextName = null;
                nextName = packageName.length() == 0 ? child.getName() : String.valueOf(packageName) + "." + child.getName();
                this.processDirectory(nextName, child);
            }
        }
    }

    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        return this.findTypeRoot(qualifiedName);
    }

    static class LocalApiTypeRoot
    extends AbstractApiTypeRoot
    implements Comparable {
        String fLocation = null;

        public LocalApiTypeRoot(DirectoryApiTypeContainer directory, String location, String typeName) {
            super(directory, typeName);
            this.fLocation = location;
        }

        public String getTypeName() {
            return this.getName();
        }

        public int compareTo(Object o) {
            return this.getName().compareTo(((LocalApiTypeRoot)o).getName());
        }

        public boolean equals(Object obj) {
            if (obj instanceof LocalApiTypeRoot) {
                return ((LocalApiTypeRoot)obj).getName().equals(this.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public InputStream getInputStream() throws CoreException {
            try {
                return new FileInputStream(new File(this.fLocation));
            }
            catch (FileNotFoundException e) {
                this.abort("File not found", e);
                return null;
            }
        }
    }
}

