/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.model.StubArchiveApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.SystemLibraryApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.ProfileModifiers;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;

public class StubApiComponent
extends SystemLibraryApiComponent {
    private static final String STUB_PATH = "/org/eclipse/pde/api/tools/internal/api_stubs/";
    private static Map AllSystemLibraryApiComponents;
    static /* synthetic */ Class class$0;

    public static IApiComponent getStubApiComponent(int eeValue) {
        String name;
        IApiComponent component;
        if (AllSystemLibraryApiComponents == null) {
            AllSystemLibraryApiComponents = new HashMap();
        }
        if ((component = (IApiComponent)AllSystemLibraryApiComponents.get(name = ProfileModifiers.getName(eeValue))) == null) {
            File stubFile = StubApiComponent.getFileFor(eeValue, name);
            if (stubFile == null) {
                return null;
            }
            component = new StubApiComponent(ApiBaselineManager.getManager().getWorkspaceBaseline(), stubFile.getAbsolutePath(), name);
            AllSystemLibraryApiComponents.put(name, component);
        }
        return component;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File getFileFor(int eeValue, String name) {
        try {
            switch (eeValue) {
                case 1: 
                case 2: 
                case 256: 
                case 512: 
                case 1024: {
                    name = name.replace('/', '_');
                    break;
                }
            }
            String stubName = String.valueOf(name) + ".zip";
            URL stub = null;
            if (Platform.isRunning()) {
                stub = ApiPlugin.getDefault().getBundle().getResource(STUB_PATH + stubName);
                if (stub == null) {
                    return null;
                }
                stub = FileLocator.toFileURL((URL)stub);
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.pde.api.tools.internal.provisional.ApiPlugin");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                if ((stub = clazz.getResource(STUB_PATH + stubName)) == null) {
                    return null;
                }
            }
            File stubFile = new File(stub.getFile());
            if (!stubFile.exists()) {
                return null;
            }
            return stubFile;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String[] getInstalledMetadata() {
        ArrayList<String> allEEs = new ArrayList<String>();
        int[] allEEsValues = ProfileModifiers.getAllIds();
        String name = null;
        File stubFile = null;
        int eeValue = -1;
        int i = 0;
        while (i < allEEsValues.length) {
            eeValue = allEEsValues[i];
            name = ProfileModifiers.getName(eeValue);
            switch (eeValue) {
                case 1: 
                case 2: 
                case 256: 
                case 512: 
                case 1024: {
                    name = name.replace('/', '_');
                }
            }
            stubFile = StubApiComponent.getFileFor(eeValue, name);
            if (stubFile != null) {
                allEEs.add(ProfileModifiers.getName(eeValue));
            }
            ++i;
        }
        Object[] result = new String[allEEs.size()];
        allEEs.toArray(result);
        Arrays.sort(result);
        return result;
    }

    private StubApiComponent(IApiBaseline profile, String fileName, String profileName) {
        super(profile);
        Path path = new Path(fileName);
        this.fLibraries = new LibraryLocation[]{new LibraryLocation((IPath)path, null, null)};
        this.fExecEnv = new String[]{profileName};
        this.fVersion = this.fExecEnv[0];
        this.setName(this.fExecEnv[0]);
        this.fLocation = path.toOSString();
    }

    protected IApiDescription createApiDescription() throws CoreException {
        return null;
    }

    protected IApiFilterStore createApiFilterStore() {
        return null;
    }

    protected List createApiTypeContainers() throws CoreException {
        ArrayList<StubArchiveApiTypeContainer> libs = new ArrayList<StubArchiveApiTypeContainer>(this.fLibraries.length);
        int i = 0;
        while (i < this.fLibraries.length) {
            LibraryLocation lib = this.fLibraries[i];
            libs.add(new StubArchiveApiTypeContainer(this, lib.getSystemLibraryPath().toOSString()));
            ++i;
        }
        return libs;
    }

    public boolean isSystemComponent() {
        return false;
    }

    public static void disposeAllCaches() {
        if (AllSystemLibraryApiComponents != null) {
            Iterator iterator = AllSystemLibraryApiComponents.values().iterator();
            while (iterator.hasNext()) {
                IApiComponent apiComponent = (IApiComponent)iterator.next();
                apiComponent.dispose();
            }
        }
    }

    public static boolean isInstalled(int eeValue) {
        String name = ProfileModifiers.getName(eeValue);
        switch (eeValue) {
            case 1: 
            case 2: 
            case 256: 
            case 512: 
            case 1024: {
                name = name.replace('/', '_');
            }
        }
        File stubFile = StubApiComponent.getFileFor(eeValue, name);
        return stubFile != null;
    }
}

