/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.comparator;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.model.Messages;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiScopeVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiScope;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ApiScope
implements IApiScope {
    private static final IApiElement[] NO_ELEMENTS = new IApiElement[0];
    Set apiElements;

    public void accept(ApiScopeVisitor visitor) throws CoreException {
        IApiElement[] elements = this.getApiElements();
        int i = 0;
        while (i < elements.length) {
            IApiElement apiElement = elements[i];
            int type = apiElement.getType();
            switch (type) {
                case 3: {
                    IApiTypeContainer container = (IApiTypeContainer)apiElement;
                    visitor.visit(container);
                    visitor.endVisit(container);
                    break;
                }
                case 7: {
                    IApiTypeRoot root = (IApiTypeRoot)apiElement;
                    visitor.visit(root);
                    visitor.endVisit(root);
                    break;
                }
                case 4: {
                    IApiBaseline baseline = (IApiBaseline)apiElement;
                    visitor.visit(baseline);
                    visitor.endVisit(baseline);
                    break;
                }
                case 1: {
                    IApiComponent component = (IApiComponent)apiElement;
                    visitor.visit(component);
                    visitor.endVisit(component);
                    break;
                }
                default: {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", Messages.bind((String)Messages.ApiScope_0, (Object)Util.getApiElementType(type))));
                }
            }
            ++i;
        }
    }

    public void add(IApiElement apiElement) {
        if (this.apiElements == null) {
            this.apiElements = new HashSet();
        }
        this.apiElements.add(apiElement);
    }

    public IApiElement[] getApiElements() {
        if (this.apiElements == null || this.apiElements.size() == 0) {
            return NO_ELEMENTS;
        }
        return this.apiElements.toArray(new IApiElement[this.apiElements.size()]);
    }
}

