/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.model.PluginProjectApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchRequestor;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchScope;
import org.eclipse.pde.api.tools.internal.search.ApiUseSearchScope;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ApiUseSearchRequestor
implements IApiSearchRequestor {
    private Set fComponentIds = null;
    private int fSearchMask = 0;
    private Set fExcludeList = null;
    private IApiSearchScope fScope = null;
    public static final Comparator componentsorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof IApiComponent && o2 instanceof IApiComponent) {
                try {
                    return ((IApiComponent)o1).getId().compareTo(((IApiComponent)o2).getId());
                }
                catch (CoreException coreException) {}
            }
            return -1;
        }
    };

    public ApiUseSearchRequestor(Set elementnames, IApiElement[] scope, int searchkinds, Set excludelist) {
        this.fSearchMask = searchkinds;
        this.fComponentIds = elementnames;
        this.fExcludeList = excludelist;
        this.prepareScope(scope);
    }

    public boolean acceptComponent(IApiComponent component) {
        return true;
    }

    public boolean acceptMember(IApiMember member) {
        return true;
    }

    public boolean acceptReference(IReference reference) {
        block7: {
            int vis;
            block11: {
                IApiComponent component;
                IApiMember member;
                block10: {
                    block9: {
                        block8: {
                            member = reference.getResolvedReference();
                            if (member == null) break block7;
                            component = member.getApiComponent();
                            if (this.fComponentIds.contains(component.getId())) break block8;
                            return false;
                        }
                        if (!component.equals(reference.getMember().getApiComponent())) break block9;
                        return false;
                    }
                    if (this.fSearchMask <= 0) break block7;
                    if (!this.includesAPI() || !this.includesInternal()) break block10;
                    return true;
                }
                IApiAnnotations annots = component.getApiDescription().resolveAnnotations(member.getHandle());
                if (annots == null) break block7;
                vis = annots.getVisibility();
                if (!VisibilityModifiers.isAPI(vis) || !this.includesAPI()) break block11;
                return true;
            }
            try {
                if (VisibilityModifiers.isPrivate(vis) && this.includesInternal()) {
                    return true;
                }
            }
            catch (CoreException ce) {
                ApiPlugin.log(ce);
            }
        }
        return false;
    }

    public int getReferenceKinds() {
        int kinds = 0x7BFFFFFF;
        return kinds;
    }

    private void prepareScope(IApiElement[] elements) {
        if (elements != null) {
            try {
                TreeSet<IApiElement> comps = new TreeSet<IApiElement>(componentsorter);
                IApiElement[] components = null;
                IApiComponent component = null;
                int i = 0;
                while (i < elements.length) {
                    component = elements[i].getApiComponent();
                    if (!component.isSystemComponent()) {
                        comps.add(component);
                        components = ((ApiBaseline)component.getBaseline()).getVisibleDependentComponents(new IApiComponent[]{component});
                        int j = 0;
                        while (j < components.length) {
                            if (this.acceptComponent0((IApiComponent)components[j])) {
                                comps.add(components[j]);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                components = comps.toArray(new IApiComponent[comps.size()]);
                this.fScope = new ApiUseSearchScope(components);
            }
            catch (CoreException coreException) {}
        }
    }

    public IApiSearchScope getScope() {
        return this.fScope;
    }

    private boolean acceptComponent0(IApiComponent component) throws CoreException {
        return component != null && !this.fExcludeList.contains(component.getId()) && this.isApiComponent(component);
    }

    private boolean isApiComponent(IApiComponent component) {
        if (this.includesNonApiProjects()) {
            return true;
        }
        if (component instanceof PluginProjectApiComponent) {
            PluginProjectApiComponent comp = (PluginProjectApiComponent)component;
            return comp.hasApiDescription();
        }
        return Util.isApiToolsComponent(component);
    }

    public boolean includesAPI() {
        return (this.fSearchMask & 1) > 0;
    }

    public boolean includesInternal() {
        return (this.fSearchMask & 2) > 0;
    }

    public boolean includesNonApiProjects() {
        return (this.fSearchMask & 4) > 0;
    }
}

