/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.card;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public class MaxWatchCard
implements Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int degree;
    private final int[] lits;
    private boolean moreThan;
    private int watchCumul;
    private final ILits voc;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.minisat.constraints.card.MaxWatchCard");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private MaxWatchCard(ILits iLits, IVecInt iVecInt, boolean bl, int n) {
        this.voc = iLits;
        this.degree = n;
        this.moreThan = bl;
        int[] nArray = new int[iLits.nVars() * 2 + 2];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = 0;
            ++n2;
        }
        n2 = 0;
        while (n2 < iVecInt.size()) {
            if (nArray[iVecInt.get(n2) ^ 1] == 0) {
                int n3 = iVecInt.get(n2);
                nArray[n3] = nArray[n3] + 1;
            } else {
                int n4 = iVecInt.get(n2) ^ 1;
                nArray[n4] = nArray[n4] - 1;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < iVecInt.size()) {
            if (nArray[iVecInt.get(n2)] > 0) {
                int n5 = iVecInt.get(n2);
                nArray[n5] = nArray[n5] - 1;
                ++n2;
                continue;
            }
            if ((iVecInt.get(n2) & 1) != 0) {
                --this.degree;
            }
            iVecInt.set(n2, iVecInt.last());
            iVecInt.pop();
        }
        this.lits = new int[iVecInt.size()];
        iVecInt.moveTo(this.lits);
        this.normalize();
        this.watchCumul = 0;
        int n6 = 0;
        while (n6 < this.lits.length) {
            if (!iLits.isFalsified(this.lits[n6])) {
                ++this.watchCumul;
                iLits.watch(this.lits[n6] ^ 1, this);
            }
            ++n6;
        }
    }

    public void calcReason(int n, IVecInt iVecInt) {
        int n2 = 0;
        while (n2 < this.lits.length) {
            if (this.voc.isFalsified(this.lits[n2])) {
                iVecInt.push(this.lits[n2] ^ 1);
            }
            ++n2;
        }
    }

    public double getActivity() {
        return 0.0;
    }

    public void incActivity(double d) {
    }

    public boolean learnt() {
        return false;
    }

    public boolean locked() {
        return true;
    }

    public static MaxWatchCard maxWatchCardNew(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, boolean bl, int n) throws ContradictionException {
        MaxWatchCard maxWatchCard = null;
        if (iVecInt.size() == 0) {
            throw new ContradictionException("Creating empty clause");
        }
        if (iVecInt.size() == n) {
            int n2 = 0;
            while (n2 < iVecInt.size()) {
                if (!unitPropagationListener.enqueue(iVecInt.get(n2))) {
                    throw new ContradictionException("Contradiction with implied literal");
                }
                ++n2;
            }
            return null;
        }
        maxWatchCard = new MaxWatchCard(iLits, iVecInt, bl, n);
        if (maxWatchCard.degree <= 0) {
            return null;
        }
        if (maxWatchCard.watchCumul < maxWatchCard.degree) {
            throw new ContradictionException();
        }
        if (maxWatchCard.watchCumul == maxWatchCard.degree) {
            int n3 = 0;
            while (n3 < maxWatchCard.lits.length) {
                if (!unitPropagationListener.enqueue(maxWatchCard.lits[n3])) {
                    throw new ContradictionException("Contradiction with implied literal");
                }
                ++n3;
            }
            return null;
        }
        return maxWatchCard;
    }

    public final void normalize() {
        if (!this.moreThan) {
            this.degree = 0 - this.degree;
            int n = 0;
            while (n < this.lits.length) {
                this.lits[n] = this.lits[n] ^ 1;
                ++this.degree;
                ++n;
            }
            this.moreThan = true;
        }
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        this.voc.watch(n, this);
        if (!$assertionsDisabled && this.voc.isFalsified(n)) {
            throw new AssertionError();
        }
        if (this.watchCumul == this.degree) {
            return false;
        }
        this.voc.undos(n).push(this);
        --this.watchCumul;
        if (this.watchCumul == this.degree) {
            int[] nArray = this.lits;
            int n2 = this.lits.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray[n3];
                if (this.voc.isUnassigned(n4) && !unitPropagationListener.enqueue(n4, this)) {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            this.voc.watches(n3 ^ 1).remove(this);
            ++n2;
        }
    }

    public void rescaleBy(double d) {
    }

    public boolean simplify() {
        int n = 0;
        int n2 = this.watchCumul;
        while (n < this.lits.length) {
            if (!this.voc.isUnassigned(this.lits[n++]) || --n2 >= this.degree) continue;
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lits.length > 0) {
            if (this.voc.isUnassigned(this.lits[0])) {
                stringBuffer.append(Lits.toString(this.lits[0]));
                stringBuffer.append(" ");
            }
            int n = 1;
            while (n < this.lits.length) {
                if (this.voc.isUnassigned(this.lits[n])) {
                    stringBuffer.append(" + ");
                    stringBuffer.append(Lits.toString(this.lits[n]));
                    stringBuffer.append(" ");
                }
                ++n;
            }
            stringBuffer.append(">= ");
            stringBuffer.append(this.degree);
        }
        return stringBuffer.toString();
    }

    public void undo(int n) {
        ++this.watchCumul;
    }

    public void setLearnt() {
        throw new UnsupportedOperationException();
    }

    public void register() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.lits.length;
    }

    public int get(int n) {
        return this.lits[n];
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        throw new UnsupportedOperationException();
    }

    public BigInteger getCoef(int n) {
        return BigInteger.ONE;
    }

    public BigInteger getDegree() {
        return BigInteger.valueOf(this.degree);
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public void forwardActivity(double d) {
    }
}

