/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.ui.preferences;

import com.ibm.icu.text.MessageFormat;
import java.util.Date;
import org.eclipse.epp.usagedata.internal.gathering.UsageDataCaptureActivator;
import org.eclipse.epp.usagedata.internal.recording.UsageDataRecordingActivator;
import org.eclipse.epp.usagedata.internal.recording.settings.UsageDataRecordingSettings;
import org.eclipse.epp.usagedata.internal.ui.preferences.Messages;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class UsageDataUploadingPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int MILLISECONDS_IN_ONE_DAY = 86400000;
    private static final long MINIMUM_PERIOD_IN_DAYS = 0L;
    private static final long MAXIMUM_PERIOD_IN_DAYS = 90L;
    private Text uploadPeriodText;
    private Label label;
    private Text lastUploadText;
    private Button askBeforeUploadingCheckbox;
    private Button uploadNowButton;
    IPropertyChangeListener capturePropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("org.eclipse.epp.usagedata.gathering.enabled".equals(event.getProperty())) {
                UsageDataUploadingPreferencesPage.this.updateButtons();
                return;
            }
        }
    };
    IPropertyChangeListener recordingPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("org.eclipse.epp.usagedata.recording.ask".equals(event.getProperty())) {
                UsageDataUploadingPreferencesPage.this.getControl().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        UsageDataUploadingPreferencesPage.this.updateAskToUploadCheckbox();
                    }
                });
                return;
            }
            if ("org.eclipse.epp.usagedata.recording.period".equals(event.getProperty())) {
                UsageDataUploadingPreferencesPage.this.getControl().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        UsageDataUploadingPreferencesPage.this.updateUploadPeriodText();
                    }
                });
                return;
            }
            if ("org.eclipse.epp.usagedata.recording.last-upload".equals(event.getProperty())) {
                UsageDataUploadingPreferencesPage.this.getControl().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        UsageDataUploadingPreferencesPage.this.updateLastUploadText();
                    }
                });
                return;
            }
        }
    };

    public UsageDataUploadingPreferencesPage() {
        this.setDescription(Messages.UsageDataUploadingPreferencesPage_0);
        this.setPreferenceStore(UsageDataRecordingActivator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
        this.getCapturePreferenceStore().addPropertyChangeListener(this.capturePropertyChangeListener);
        this.getPreferenceStore().addPropertyChangeListener(this.recordingPropertyChangeListener);
    }

    public void dispose() {
        this.getCapturePreferenceStore().removePropertyChangeListener(this.capturePropertyChangeListener);
        this.getPreferenceStore().removePropertyChangeListener(this.recordingPropertyChangeListener);
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.createGeneralInformationArea(composite);
        this.createUploadingArea(composite);
        this.createButtonsArea(composite);
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData(16384, 128, true, true));
        this.initialize();
        return composite;
    }

    private void initialize() {
        this.updateAskToUploadCheckbox();
        this.updateUploadPeriodText();
        this.updateLastUploadText();
        this.updateButtons();
    }

    private void updateLastUploadText() {
        this.lastUploadText.setText(this.getLastUploadDateAsString());
    }

    private void updateUploadPeriodText() {
        this.uploadPeriodText.setText(String.valueOf(this.getRecordingPreferences().getLong("org.eclipse.epp.usagedata.recording.period") / 86400000L));
    }

    private void updateAskToUploadCheckbox() {
        this.askBeforeUploadingCheckbox.setSelection(this.getRecordingPreferences().getBoolean("org.eclipse.epp.usagedata.recording.ask"));
    }

    private void updateButtons() {
        this.uploadNowButton.setEnabled(this.getCapturePreferenceStore().getBoolean("org.eclipse.epp.usagedata.gathering.enabled"));
    }

    private IPreferenceStore getCapturePreferenceStore() {
        return UsageDataCaptureActivator.getDefault().getPreferenceStore();
    }

    public boolean performOk() {
        this.getRecordingPreferences().setValue("org.eclipse.epp.usagedata.recording.ask", this.askBeforeUploadingCheckbox.getSelection());
        this.getRecordingPreferences().setValue("org.eclipse.epp.usagedata.recording.period", Long.valueOf(this.uploadPeriodText.getText()) * 86400000L);
        return super.performOk();
    }

    public boolean isValid() {
        return this.isValidUploadPeriod(this.uploadPeriodText.getText());
    }

    protected void performDefaults() {
        this.askBeforeUploadingCheckbox.setSelection(this.getRecordingPreferences().getDefaultBoolean("org.eclipse.epp.usagedata.recording.ask"));
        this.uploadPeriodText.setText(String.valueOf(this.getRecordingPreferences().getDefaultLong("org.eclipse.epp.usagedata.recording.period") / 86400000L));
        this.updateLastUploadText();
        super.performDefaults();
    }

    private void createGeneralInformationArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(16384, 128, true, false));
        composite.setLayout((Layout)new GridLayout());
        this.askBeforeUploadingCheckbox = new Button(composite, 16416);
        this.askBeforeUploadingCheckbox.setText(Messages.UsageDataUploadingPreferencesPage_1);
    }

    private void createUploadingArea(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.UsageDataUploadingPreferencesPage_2);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(3, false));
        GridData fieldLayoutData = new GridData(4, 0x1000000, true, false);
        fieldLayoutData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        this.createUploadPeriodField(group);
        this.createLastUploadField(group);
    }

    private void createUploadPeriodField(Group composite) {
        Label label = new Label((Composite)composite, 0);
        label.setText(Messages.UsageDataUploadingPreferencesPage_3);
        this.uploadPeriodText = new Text((Composite)composite, 133124);
        this.uploadPeriodText.setTextLimit(2);
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        gridData.horizontalSpan = 1;
        GC gc = new GC((Drawable)this.uploadPeriodText.getDisplay());
        gc.setFont(this.uploadPeriodText.getFont());
        gridData.widthHint = gc.stringExtent((String)String.valueOf((long)90L)).x;
        gc.dispose();
        this.uploadPeriodText.setLayoutData((Object)gridData);
        new Label((Composite)composite, 0).setText(Messages.UsageDataUploadingPreferencesPage_4);
        final ControlDecoration rangeErrorDecoration = new ControlDecoration((Control)this.uploadPeriodText, 16512);
        rangeErrorDecoration.setDescriptionText(MessageFormat.format((String)Messages.UsageDataUploadingPreferencesPage_5, (Object[])new Object[]{0L, 90L}));
        rangeErrorDecoration.setImage(this.getErrorImage());
        rangeErrorDecoration.hide();
        this.uploadPeriodText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String contents = UsageDataUploadingPreferencesPage.this.uploadPeriodText.getText();
                if (UsageDataUploadingPreferencesPage.this.isValidUploadPeriod(contents)) {
                    rangeErrorDecoration.hide();
                } else {
                    rangeErrorDecoration.show();
                }
                UsageDataUploadingPreferencesPage.this.updateApplyButton();
                UsageDataUploadingPreferencesPage.this.getContainer().updateButtons();
            }
        });
        if (System.getProperty("org.eclipse.epp.usagedata.recording.period") != null) {
            this.addOverrideWarning((Control)this.uploadPeriodText);
        }
    }

    private boolean isValidUploadPeriod(String text) {
        long value;
        block3: {
            try {
                value = Long.parseLong(text);
                if (value >= 0L) break block3;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return value <= 90L;
    }

    private Image getErrorImage() {
        return FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    }

    private void createLastUploadField(Group composite) {
        this.label = new Label((Composite)composite, 0);
        this.label.setText(Messages.UsageDataUploadingPreferencesPage_6);
        this.lastUploadText = new Text((Composite)composite, 2052);
        this.lastUploadText.setEnabled(false);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        gridData.horizontalSpan = 2;
        this.lastUploadText.setLayoutData((Object)gridData);
    }

    private void createButtonsArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setLayout((Layout)new RowLayout());
        this.createUploadNowButton(composite);
    }

    protected IWorkbenchPage getPage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    protected UsageDataRecordingSettings getSettings() {
        return UsageDataRecordingActivator.getDefault().getSettings();
    }

    private void createUploadNowButton(Composite composite) {
        this.uploadNowButton = new Button(composite, 8);
        this.uploadNowButton.setText(Messages.UsageDataUploadingPreferencesPage_7);
        this.uploadNowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageDataRecordingActivator.getDefault().getUploadManager().startUpload();
            }
        });
    }

    private void addOverrideWarning(Control control) {
        FieldDecoration decoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
        ControlDecoration warning = new ControlDecoration(control, 17408);
        warning.setImage(decoration.getImage());
        warning.setDescriptionText(Messages.UsageDataUploadingPreferencesPage_8);
    }

    private String getLastUploadDateAsString() {
        long time = this.getRecordingSettings().getLastUploadTime();
        Date date = new Date(time);
        return date.toString();
    }

    private IPreferenceStore getRecordingPreferences() {
        return UsageDataRecordingActivator.getDefault().getPreferenceStore();
    }

    private UsageDataRecordingSettings getRecordingSettings() {
        return UsageDataRecordingActivator.getDefault().getSettings();
    }
}

