/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.configuration;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swordfish.core.configuration.ConfigurationConsumer;
import org.eclipse.swordfish.internal.core.configuration.ManagedServiceAdapter;
import org.eclipse.swordfish.internal.core.util.RegistryImpl;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationConsumerRegistry
extends RegistryImpl<ConfigurationConsumer>
implements BundleContextAware {
    protected ConcurrentHashMap<ConfigurationConsumer, ServiceRegistration> registrations = new ConcurrentHashMap();

    protected void doRegister(ConfigurationConsumer configurationConsumer, Map<String, ?> properties) throws Exception {
        Assert.notNull((Object)configurationConsumer);
        String consumerId = configurationConsumer.getId();
        this.LOG.info((Object)("Registering configurationConsumer with id = " + consumerId));
        Assert.notNull((Object)consumerId, (String)"Need a valid consumer id");
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", consumerId);
        this.registrations.put(configurationConsumer, this.bundleContext.registerService(ManagedService.class.getName(), (Object)new ManagedServiceAdapter(configurationConsumer), props));
        super.doRegister((Object)configurationConsumer, properties);
    }

    protected void doUnregister(ConfigurationConsumer key, Map<String, ?> properties) throws Exception {
        ServiceRegistration serviceRegistration = this.registrations.remove(key);
        if (serviceRegistration != null) {
            try {
                serviceRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        super.doUnregister((Object)key, properties);
    }

    protected void doDestroy() throws Exception {
        for (ConfigurationConsumer key : this.registrations.keySet()) {
            this.doUnregister((Object)key, null);
        }
        super.doDestroy();
    }
}

