/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.configuration;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.configuration.ConfigurationService;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationServiceImpl
implements ConfigurationService {
    private ConfigurationAdmin configurationAdmin;

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public <T> void updateConfiguration(String id, Map<String, T> configurationData) {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration(id);
            Assert.notNull((Object)configuration, (String)("Could not find configuration by id = " + id));
            if (configurationData == null) {
                configuration.update(null);
                return;
            }
            Hashtable<String, T> properties = new Hashtable<String, T>();
            for (String key : configurationData.keySet()) {
                ((Dictionary)properties).put(key, configurationData.get(key));
            }
            configuration.update(properties);
        }
        catch (Exception ex) {
            throw new SwordfishException((Throwable)ex);
        }
    }
}

