/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.IUProfilePropertyQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.AbstractTargetHandle;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.LocalTargetHandle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.NameVersionDescriptor;
import org.eclipse.pde.internal.core.target.TargetDefinitionPersistenceHelper;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetHandle;
import org.xml.sax.SAXException;

public class TargetDefinition
implements ITargetDefinition {
    private String fName;
    private String fProgramArgs;
    private String fVMArgs;
    private IPath fJREContainer;
    private String fArch;
    private String fOS;
    private String fWS;
    private String fNL;
    private IBundleContainer[] fContainers;
    private ITargetHandle fHandle;
    private BundleInfo[] fImplicit;

    TargetDefinition(ITargetHandle handle) {
        this.fHandle = handle;
    }

    public String getArch() {
        return this.fArch;
    }

    public IBundleContainer[] getBundleContainers() {
        return this.fContainers;
    }

    public String getNL() {
        return this.fNL;
    }

    public String getName() {
        return this.fName;
    }

    public String getOS() {
        return this.fOS;
    }

    public String getProgramArguments() {
        return this.fProgramArgs;
    }

    public String getVMArguments() {
        return this.fVMArgs;
    }

    public String getWS() {
        return this.fWS;
    }

    public void setArch(String arch) {
        this.fArch = arch;
    }

    public void setNL(String nl) {
        this.fNL = nl;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setOS(String os) {
        this.fOS = os;
    }

    public void setProgramArguments(String args) {
        if (args != null && args.length() == 0) {
            args = null;
        }
        this.fProgramArgs = args;
    }

    public void setVMArguments(String args) {
        if (args != null && args.length() == 0) {
            args = null;
        }
        this.fVMArgs = args;
    }

    public void setWS(String ws) {
        this.fWS = ws;
    }

    public void setBundleContainers(IBundleContainer[] containers) {
        if (containers != null && containers.length == 0) {
            containers = null;
        }
        this.fContainers = containers;
    }

    public IStatus resolve(IProgressMonitor monitor) {
        IBundleContainer[] containers = this.getBundleContainers();
        int num = 0;
        if (containers != null) {
            num = containers.length;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.TargetDefinition_1, (int)(num * 10));
        try {
            MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, Messages.TargetDefinition_2, null);
            if (containers != null) {
                int i = 0;
                while (i < containers.length) {
                    if (subMonitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    subMonitor.subTask(Messages.TargetDefinition_4);
                    IStatus s = containers[i].resolve(this, (IProgressMonitor)subMonitor.newChild(10));
                    if (!s.isOK()) {
                        status.add(s);
                    }
                    ++i;
                }
            }
            if (status.isOK()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            MultiStatus multiStatus = status;
            return multiStatus;
        }
        finally {
            subMonitor.done();
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public boolean isResolved() {
        IBundleContainer[] containers = this.getBundleContainers();
        if (containers != null) {
            int i = 0;
            while (i < containers.length) {
                IBundleContainer container = containers[i];
                if (!container.isResolved()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public IStatus getBundleStatus() {
        if (this.isResolved()) {
            IBundleContainer[] containers = this.getBundleContainers();
            if (containers != null) {
                MultiStatus result = new MultiStatus("org.eclipse.pde.core", 0, Messages.TargetDefinition_5, null);
                int i = 0;
                while (i < containers.length) {
                    IBundleContainer container = containers[i];
                    IStatus containerStatus = container.getBundleStatus();
                    if (containerStatus != null) {
                        result.add(containerStatus);
                    }
                    ++i;
                }
                if (result.isOK()) {
                    return Status.OK_STATUS;
                }
                return result;
            }
            return Status.OK_STATUS;
        }
        return null;
    }

    public IResolvedBundle[] getBundles() {
        return this.getBundles(false);
    }

    public IResolvedBundle[] getAllBundles() {
        return this.getBundles(true);
    }

    private IResolvedBundle[] getBundles(boolean allBundles) {
        if (this.isResolved()) {
            IBundleContainer[] containers = this.getBundleContainers();
            if (containers != null) {
                ArrayList<IResolvedBundle> all = new ArrayList<IResolvedBundle>();
                int i = 0;
                while (i < containers.length) {
                    IBundleContainer container = containers[i];
                    IResolvedBundle[] bundles = null;
                    bundles = allBundles ? container.getAllBundles() : container.getBundles();
                    int j = 0;
                    while (j < bundles.length) {
                        IResolvedBundle rb = bundles[j];
                        all.add(rb);
                        ++j;
                    }
                    ++i;
                }
                return all.toArray(new IResolvedBundle[all.size()]);
            }
            return new IResolvedBundle[0];
        }
        return null;
    }

    public ITargetHandle getHandle() {
        return this.fHandle;
    }

    void setContents(InputStream stream) throws CoreException {
        try {
            this.fArch = null;
            this.fContainers = null;
            this.fImplicit = null;
            this.fJREContainer = null;
            this.fName = null;
            this.fNL = null;
            this.fOS = null;
            this.fProgramArgs = null;
            this.fVMArgs = null;
            this.fWS = null;
            TargetDefinitionPersistenceHelper.initFromXML(this, stream);
        }
        catch (ParserConfigurationException e) {
            this.abort(Messages.TargetDefinition_0, e);
        }
        catch (SAXException e) {
            this.abort(Messages.TargetDefinition_0, e);
        }
        catch (IOException e) {
            this.abort(Messages.TargetDefinition_0, e);
        }
    }

    void write(OutputStream stream) throws CoreException {
        try {
            TargetDefinitionPersistenceHelper.persistXML(this, stream);
        }
        catch (IOException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
        catch (ParserConfigurationException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
        catch (TransformerException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
    }

    private void abort(String message, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", message, (Throwable)e));
    }

    public BundleInfo[] getImplicitDependencies() {
        return this.fImplicit;
    }

    public IResolvedBundle[] getResolvedImplicitDependencies() {
        int size = 0;
        if (this.fImplicit != null) {
            size = this.fImplicit.length;
        }
        if (size == 0) {
            return new IResolvedBundle[0];
        }
        return AbstractBundleContainer.getMatchingBundles(this.getBundles(), this.fImplicit, null, null);
    }

    public void setImplicitDependencies(BundleInfo[] bundles) {
        if (bundles != null && bundles.length == 0) {
            bundles = null;
        }
        this.fImplicit = bundles;
    }

    public IPath getJREContainer() {
        return this.fJREContainer;
    }

    public void setJREContainer(IPath containerPath) {
        this.fJREContainer = containerPath;
    }

    public boolean isContentEqual(ITargetDefinition definition) {
        IBundleContainer[] c2;
        IBundleContainer[] c1;
        if (this.isNullOrEqual(this.getName(), definition.getName()) && this.isNullOrEqual(this.getArch(), definition.getArch()) && this.isNullOrEqual(this.getNL(), definition.getNL()) && this.isNullOrEqual(this.getOS(), definition.getOS()) && this.isNullOrEqual(this.getWS(), definition.getWS()) && this.isNullOrEqual(this.getProgramArguments(), definition.getProgramArguments()) && this.isNullOrEqual(this.getVMArguments(), definition.getVMArguments()) && this.isNullOrEqual(this.getJREContainer(), definition.getJREContainer()) && this.areContainersEqual(c1 = this.getBundleContainers(), c2 = definition.getBundleContainers())) {
            return this.areEqual(this.getImplicitDependencies(), definition.getImplicitDependencies());
        }
        return false;
    }

    public boolean isContentEquivalent(ITargetDefinition definition) {
        IBundleContainer[] c2;
        IBundleContainer[] c1;
        if (this.isNullOrEqual(this.getArch(), definition.getArch()) && this.isNullOrEqual(this.getNL(), definition.getNL()) && this.isNullOrEqual(this.getOS(), definition.getOS()) && this.isNullOrEqual(this.getWS(), definition.getWS()) && this.isArgsNullOrEqual(this.getProgramArguments(), definition.getProgramArguments()) && this.isArgsNullOrEqual(this.getVMArguments(), definition.getVMArguments()) && this.isNullOrEqual(this.getJREContainer(), definition.getJREContainer()) && this.areContainersEqual(c1 = this.getBundleContainers(), c2 = definition.getBundleContainers())) {
            return this.areEqual(this.getImplicitDependencies(), definition.getImplicitDependencies());
        }
        return false;
    }

    private boolean areEqual(BundleInfo[] c1, BundleInfo[] c2) {
        if (c1 == null) {
            return c2 == null;
        }
        if (c2 == null) {
            return false;
        }
        if (c1.length == c2.length) {
            int i = 0;
            while (i < c2.length) {
                if (!c1[i].equals((Object)c2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean isNullOrEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private boolean isArgsNullOrEqual(String args1, String args2) {
        String[] a2;
        if (args1 == null) {
            return args2 == null;
        }
        if (args2 == null) {
            return false;
        }
        String[] a1 = DebugPlugin.parseArguments((String)args1);
        if (a1.length == (a2 = DebugPlugin.parseArguments((String)args2)).length) {
            int i = 0;
            while (i < a1.length) {
                if (!a1[i].equals(a2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean areContainersEqual(IBundleContainer[] c1, IBundleContainer[] c2) {
        if (c1 == null) {
            return c2 == null;
        }
        if (c2 == null) {
            return false;
        }
        if (c1.length == c2.length) {
            int i = 0;
            while (i < c2.length) {
                AbstractBundleContainer ac1 = (AbstractBundleContainer)c1[i];
                AbstractBundleContainer ac2 = (AbstractBundleContainer)c2[i];
                if (!ac1.isContentEqual(ac2)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.fName != null ? this.fName : "No Name");
        if (this.fContainers == null) {
            buf.append("\n\tNo containers");
        } else {
            int i = 0;
            while (i < this.fContainers.length) {
                buf.append("\n\t").append(this.fContainers.toString());
                ++i;
            }
        }
        buf.append("\nEnv: ").append(this.fOS).append("/").append(this.fWS).append("/").append(this.fArch).append("/").append(this.fNL);
        buf.append("\nJRE: ").append(this.fJREContainer);
        buf.append("\nArgs: ").append(this.fProgramArgs).append("/").append(this.fVMArgs);
        buf.append("\nImplicit: ").append(this.fImplicit == null ? "null" : Integer.toString(this.fImplicit.length));
        buf.append("\nHandle: ").append(this.fHandle.toString());
        return buf.toString();
    }

    public IProfile findProfile() {
        IProfileRegistry registry = AbstractTargetHandle.getProfileRegistry();
        if (registry != null) {
            AbstractTargetHandle handle = (AbstractTargetHandle)this.getHandle();
            try {
                String id = handle.getProfileId();
                return registry.getProfile(id);
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private boolean isAllEnvironments() {
        IBundleContainer[] containers = this.getBundleContainers();
        if (containers != null) {
            int i = 0;
            while (i < containers.length) {
                IUBundleContainer iu;
                if (containers[i] instanceof IUBundleContainer && (iu = (IUBundleContainer)containers[i]).getIncludeAllEnvironments()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private String getProvisionMode() {
        IBundleContainer[] containers = this.getBundleContainers();
        if (containers != null) {
            int i = 0;
            while (i < containers.length) {
                if (containers[i] instanceof IUBundleContainer) {
                    IUBundleContainer iu = (IUBundleContainer)containers[i];
                    if (iu.getIncludeAllRequired()) {
                        return "planner";
                    }
                    return "slicer";
                }
                ++i;
            }
        }
        return null;
    }

    public IProfile getProfile() throws CoreException {
        IProfileRegistry registry = AbstractTargetHandle.getProfileRegistry();
        if (registry == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.AbstractTargetHandle_0));
        }
        AbstractTargetHandle handle = (AbstractTargetHandle)this.getHandle();
        String id = handle.getProfileId();
        IProfile profile = registry.getProfile(id);
        if (profile != null) {
            Collector collector;
            Iterator iterator;
            String mode;
            boolean recreate = false;
            boolean all = false;
            String value = profile.getProperty("org.eclipse.pde.core.all_environments");
            if (value != null) {
                all = Boolean.valueOf(value);
                if (!Boolean.toString(this.isAllEnvironments()).equals(value)) {
                    recreate = true;
                }
            }
            String property = null;
            if (!(recreate || all || (property = this.generateEnvironmentProperties()).equals(value = profile.getProperty("org.eclipse.equinox.p2.environments")))) {
                recreate = true;
            }
            if ((mode = this.getProvisionMode()) != null && !mode.equals(value = profile.getProperty("org.eclipse.pde.core.provision_mode"))) {
                recreate = true;
            }
            if (!recreate && !(property = this.generateNLProperty()).equals(value = profile.getProperty("org.eclipse.equinox.p2.nl"))) {
                recreate = true;
            }
            if (!recreate && (iterator = (collector = profile.query((Query)new IUProfilePropertyQuery(profile, "org.eclipse.pde.core.installed_iu", Boolean.toString(true)), new Collector(), null)).iterator()).hasNext()) {
                HashSet<NameVersionDescriptor> installedIUs = new HashSet<NameVersionDescriptor>();
                while (iterator.hasNext()) {
                    IInstallableUnit unit = (IInstallableUnit)iterator.next();
                    installedIUs.add(new NameVersionDescriptor(unit.getId(), unit.getVersion().toString()));
                }
                IBundleContainer[] containers = this.getBundleContainers();
                if (containers != null) {
                    int i = 0;
                    while (i < containers.length) {
                        if (containers[i] instanceof IUBundleContainer) {
                            IUBundleContainer bc = (IUBundleContainer)containers[i];
                            String[] ids = bc.getIds();
                            Version[] versions = bc.getVersions();
                            int j = 0;
                            while (j < versions.length) {
                                installedIUs.remove(new NameVersionDescriptor(ids[j], versions[j].toString()));
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                if (!installedIUs.isEmpty()) {
                    recreate = true;
                }
            }
            if (recreate) {
                handle.deleteProfile();
                profile = null;
            }
        }
        if (profile == null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("org.eclipse.equinox.p2.installFolder", AbstractTargetHandle.INSTALL_FOLDERS.append(Long.toString(LocalTargetHandle.nextTimeStamp())).toOSString());
            properties.put("org.eclipse.equinox.p2.cache", AbstractTargetHandle.BUNDLE_POOL.toOSString());
            properties.put("org.eclipse.update.install.features", Boolean.TRUE.toString());
            properties.put("org.eclipse.equinox.p2.environments", this.generateEnvironmentProperties());
            properties.put("org.eclipse.equinox.p2.nl", this.generateNLProperty());
            String mode = this.getProvisionMode();
            if (mode != null) {
                properties.put("org.eclipse.pde.core.provision_mode", mode);
                properties.put("org.eclipse.pde.core.all_environments", Boolean.toString(this.isAllEnvironments()));
            }
            profile = registry.addProfile(id, properties);
        }
        return profile;
    }

    private String generateEnvironmentProperties() {
        StringBuffer env = new StringBuffer();
        String ws = this.getWS();
        if (ws == null) {
            ws = Platform.getWS();
        }
        env.append("osgi.ws=");
        env.append(ws);
        env.append(",");
        String os = this.getOS();
        if (os == null) {
            os = Platform.getOS();
        }
        env.append("osgi.os=");
        env.append(os);
        env.append(",");
        String arch = this.getArch();
        if (arch == null) {
            arch = Platform.getOSArch();
        }
        env.append("osgi.arch=");
        env.append(arch);
        return env.toString();
    }

    private String generateNLProperty() {
        String nl = this.getNL();
        if (nl == null) {
            nl = Platform.getNL();
        }
        return nl;
    }
}

