/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.exception;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.messaging.MessageExchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.InterceptorExceptionListener;
import org.eclipse.swordfish.core.event.EventFilter;
import org.eclipse.swordfish.core.event.EventHandler;
import org.eclipse.swordfish.internal.core.exception.InterceptorExceptionEvent;
import org.eclipse.swordfish.internal.core.util.RegistryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorExceptionListenerRegistry
extends RegistryImpl<InterceptorExceptionListener> {
    private static final Log LOG = LogFactory.getLog(InterceptorExceptionListenerRegistry.class);
    private Dictionary<String, Object> execptionProperties = new Hashtable<String, Object>();
    protected ConcurrentHashMap<InterceptorExceptionListener, ServiceRegistration> registrations = new ConcurrentHashMap();
    BundleContext bundleContext;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void doRegister(final InterceptorExceptionListener exceptionListener, Map<String, ?> properties) throws Exception {
        LOG.debug((Object)("Registeting Interceptor Exception Listener Service [" + exceptionListener + "]"));
        Assert.notNull((Object)exceptionListener);
        EventHandler<InterceptorExceptionEvent> exceptionHandler = new EventHandler<InterceptorExceptionEvent>(){

            public void handleEvent(InterceptorExceptionEvent event) {
                Exception exception = event.getException();
                MessageExchange exchange = event.getExchange();
                Interceptor interceptor = event.getInterceptor();
                exceptionListener.handle(exception, exchange, interceptor);
            }

            public EventFilter getEventFilter() {
                return null;
            }

            public String getSubscribedTopic() {
                return InterceptorExceptionEvent.TOPIC_INTECEPTOR_EXCEPTOIN_EVENT;
            }
        };
        this.bundleContext.registerService(EventHandler.class.getName(), (Object)exceptionHandler, this.execptionProperties);
        this.registrations.put(exceptionListener, this.bundleContext.registerService(EventHandler.class.getName(), (Object)exceptionHandler, null));
        super.doRegister((Object)exceptionListener, properties);
    }

    protected void doUnregister(InterceptorExceptionListener key, Map<String, ?> properties) throws Exception {
        ServiceRegistration serviceRegistration = this.registrations.get(key);
        Assert.notNull((Object)serviceRegistration, (String)String.format(" service registration for interceptor exception listener [%s] can not be found", key));
        serviceRegistration.unregister();
        super.doUnregister((Object)key, properties);
    }

    protected void doDestroy() throws Exception {
        for (ServiceRegistration registration : this.registrations.values()) {
            registration.unregister();
        }
        super.doDestroy();
    }
}

