/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.internal.core.target.DirectoryBundleContainer;
import org.eclipse.pde.internal.core.target.FeatureBundleContainer;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.shared.target.EditDirectoryContainerPage;
import org.eclipse.pde.internal.ui.shared.target.EditFeatureContainerPage;
import org.eclipse.pde.internal.ui.shared.target.EditIUContainerPage;
import org.eclipse.pde.internal.ui.shared.target.EditProfileContainerPage;
import org.eclipse.pde.internal.ui.shared.target.IEditBundleContainerPage;
import org.eclipse.pde.internal.ui.shared.target.Messages;

public class EditBundleContainerWizard
extends Wizard {
    private ITargetDefinition fTarget;
    private IBundleContainer fContainer;
    private IEditBundleContainerPage fPage;

    public EditBundleContainerWizard(ITargetDefinition target, IBundleContainer container) {
        this.fTarget = target;
        this.fContainer = container;
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection("editBundleContainerWizard");
        if (settings == null) {
            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection("editBundleContainerWizard");
        }
        this.setDialogSettings(settings);
        this.setWindowTitle(Messages.EditBundleContainerWizard_0);
    }

    public void addPages() {
        if (this.fContainer instanceof DirectoryBundleContainer) {
            this.fPage = new EditDirectoryContainerPage(this.fContainer);
        } else if (this.fContainer instanceof ProfileBundleContainer) {
            this.fPage = new EditProfileContainerPage(this.fContainer);
        } else if (this.fContainer instanceof FeatureBundleContainer) {
            this.fPage = new EditFeatureContainerPage(this.fContainer);
        } else if (this.fContainer instanceof IUBundleContainer) {
            try {
                this.fPage = new EditIUContainerPage((IUBundleContainer)this.fContainer, this.fTarget, ((TargetDefinition)this.fTarget).getProfile());
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
        }
        if (this.fPage != null) {
            this.addPage(this.fPage);
        }
    }

    public boolean performFinish() {
        if (this.fPage != null) {
            this.fPage.storeSettings();
            this.fContainer = this.fPage.getBundleContainer();
            return true;
        }
        return false;
    }

    public IBundleContainer getBundleContainer() {
        return this.fContainer;
    }
}

