/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.shared.target.ITargetChangedListener;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.BundleException;

public class TargetContentsGroup
extends FilteredTree {
    private CheckboxTreeViewer fTree;
    private Button fSelectButton;
    private Button fDeselectButton;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Button fSelectRequiredButton;
    private Label fShowLabel;
    private Button fShowSourceButton;
    private Button fShowPluginsButton;
    private Label fCountLabel;
    private Label fGroupLabel;
    private Combo fGroupCombo;
    private ComboPart fGroupComboPart;
    private ViewerFilter fSourceFilter;
    private ViewerFilter fPluginFilter;
    private List fAllBundles;
    private Set fAllChecked;
    private Map fContainerBundles;
    private Map fContainerChecked;
    private Map fFileBundles;
    private Map fFileChecked;
    private ITargetDefinition fTargetDefinition;
    private FormToolkit fToolkit;
    private int fGrouping;
    private static final int GROUP_BY_NONE = 0;
    private static final int GROUP_BY_FILE_LOC = 1;
    private static final int GROUP_BY_CONTAINER = 2;
    private ListenerList fChangeListeners = new ListenerList();

    public TargetContentsGroup(Composite parent) {
        super(parent, 0, null, true);
        PatternFilter filter = new PatternFilter();
        filter.setIncludeLeadingWildcard(true);
        super.init(0, filter);
    }

    public TargetContentsGroup(Composite parent, FormToolkit toolkit) {
        super(parent, 0, null, true);
        this.fToolkit = toolkit;
        PatternFilter filter = new PatternFilter();
        filter.setIncludeLeadingWildcard(true);
        super.init(0, filter);
    }

    public void addTargetChangedListener(ITargetChangedListener listener) {
        this.fChangeListeners.add((Object)listener);
    }

    public void contentChanged() {
        Object[] listeners = this.fChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITargetChangedListener)listeners[i]).contentsChanged(this.fTargetDefinition, (Object)this, false, false);
            ++i;
        }
    }

    protected void init(int treeStyle, PatternFilter filter) {
    }

    protected Control createTreeControl(Composite parent, int style) {
        this.fGrouping = 0;
        Composite treeComp = null;
        if (this.fToolkit != null) {
            treeComp = this.fToolkit.createComposite(parent);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            treeComp.setLayout((Layout)layout);
            treeComp.setLayoutData((Object)new GridData(1808));
        } else {
            treeComp = SWTFactory.createComposite(parent, 2, 1, 1808, 0, 0);
        }
        super.createTreeControl(treeComp, style);
        ((GridData)this.fTree.getControl().getLayoutData()).heightHint = 300;
        this.createButtons(treeComp);
        if (this.fToolkit != null) {
            this.fCountLabel = this.fToolkit.createLabel(treeComp, "");
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            this.fCountLabel.setLayoutData((Object)data);
        } else {
            this.fCountLabel = SWTFactory.createLabel(treeComp, "", 2);
        }
        this.updateButtons();
        this.initializeFilters();
        return treeComp;
    }

    protected WorkbenchJob doCreateRefreshJob() {
        WorkbenchJob job = super.doCreateRefreshJob();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().getSeverity() != 8 && TargetContentsGroup.this.fAllBundles != null) {
                    TargetContentsGroup.this.fTree.expandAll();
                    TargetContentsGroup.this.updateCheckState();
                }
            }
        });
        return job;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        Tree tree = null;
        tree = this.fToolkit != null ? this.fToolkit.createTree(parent, 2850) : new Tree(parent, style | 0x20 | 2 | 0x200 | 0x100 | 0x800);
        tree.setLayoutData((Object)new GridData(1808));
        this.fTree = new CheckboxTreeViewer(tree);
        this.fTree.setUseHashlookup(true);
        this.fTree.setContentProvider((IContentProvider)new TreeContentProvider());
        this.fTree.setLabelProvider((IBaseLabelProvider)new StyledBundleLabelProvider(true, false));
        this.fTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object first = selection.getFirstElement();
                TargetContentsGroup.this.handleCheck(new Object[]{selection.getFirstElement()}, !TargetContentsGroup.this.fTree.getChecked(first));
            }
        });
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TargetContentsGroup.this.handleCheck(new Object[]{event.getElement()}, TargetContentsGroup.this.fTree.getChecked(event.getElement()));
            }
        });
        this.fTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetContentsGroup.this.updateButtons();
            }
        });
        this.fTree.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IResolvedBundle && e2 instanceof IResolvedBundle) {
                    IStatus status1 = ((IResolvedBundle)e1).getStatus();
                    IStatus status2 = ((IResolvedBundle)e2).getStatus();
                    if (!status1.isOK() && status2.isOK()) {
                        return -1;
                    }
                    if (status1.isOK() && !status2.isOK()) {
                        return 1;
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
        return this.fTree;
    }

    protected Text doCreateFilterText(Composite parent) {
        Text parentText = super.doCreateFilterText(parent);
        if (this.fToolkit != null) {
            int style = parentText.getStyle();
            parentText.dispose();
            return this.fToolkit.createText(parent, null, style);
        }
        return parentText;
    }

    private void createButtons(Composite parent) {
        Composite buttonComp;
        if (this.fToolkit != null) {
            buttonComp = this.fToolkit.createComposite(parent);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            buttonComp.setLayout((Layout)layout);
            buttonComp.setLayoutData((Object)new GridData(1040));
            this.fSelectButton = this.fToolkit.createButton(buttonComp, Messages.IncludedBundlesTree_0, 8);
            this.fSelectButton.setLayoutData((Object)new GridData(768));
            this.fDeselectButton = this.fToolkit.createButton(buttonComp, Messages.IncludedBundlesTree_1, 8);
            this.fDeselectButton.setLayoutData((Object)new GridData(768));
            Label emptySpace = new Label(buttonComp, 0);
            GridData gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fSelectAllButton = this.fToolkit.createButton(buttonComp, Messages.IncludedBundlesTree_2, 8);
            this.fSelectAllButton.setLayoutData((Object)new GridData(768));
            this.fDeselectAllButton = this.fToolkit.createButton(buttonComp, Messages.IncludedBundlesTree_3, 8);
            this.fDeselectAllButton.setLayoutData((Object)new GridData(768));
            emptySpace = new Label(buttonComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fSelectRequiredButton = this.fToolkit.createButton(buttonComp, Messages.TargetContentsGroup_4, 8);
            this.fSelectRequiredButton.setLayoutData((Object)new GridData(768));
            Composite filterComp = this.fToolkit.createComposite(buttonComp);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            filterComp.setLayout((Layout)layout);
            filterComp.setLayoutData((Object)new GridData(16384, 1024, true, true));
            this.fShowLabel = this.fToolkit.createLabel(filterComp, Messages.BundleContainerTable_9);
            this.fShowPluginsButton = this.fToolkit.createButton(filterComp, Messages.BundleContainerTable_14, 32);
            this.fShowPluginsButton.setSelection(true);
            this.fShowSourceButton = this.fToolkit.createButton(filterComp, Messages.BundleContainerTable_15, 32);
            this.fShowSourceButton.setSelection(true);
            emptySpace = new Label(filterComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fGroupLabel = this.fToolkit.createLabel(filterComp, Messages.TargetContentsGroup_0);
            this.fGroupComboPart = new ComboPart();
            this.fGroupComboPart.createControl(filterComp, this.fToolkit, 2060);
            gd = new GridData(768);
            gd.horizontalIndent = 10;
            this.fGroupComboPart.getControl().setLayoutData((Object)gd);
            this.fGroupComboPart.setItems(new String[]{Messages.TargetContentsGroup_1, Messages.TargetContentsGroup_2, Messages.TargetContentsGroup_3});
            this.fGroupComboPart.setVisibleItemCount(30);
            this.fGroupComboPart.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TargetContentsGroup.this.handleGroupChange();
                }
            });
            this.fGroupComboPart.select(0);
        } else {
            buttonComp = SWTFactory.createComposite(parent, 1, 1, 1040, 0, 0);
            this.fSelectButton = SWTFactory.createPushButton(buttonComp, Messages.IncludedBundlesTree_0, null);
            this.fDeselectButton = SWTFactory.createPushButton(buttonComp, Messages.IncludedBundlesTree_1, null);
            Label emptySpace = new Label(buttonComp, 0);
            GridData gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fSelectAllButton = SWTFactory.createPushButton(buttonComp, Messages.IncludedBundlesTree_2, null);
            this.fDeselectAllButton = SWTFactory.createPushButton(buttonComp, Messages.IncludedBundlesTree_3, null);
            emptySpace = new Label(buttonComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fSelectRequiredButton = SWTFactory.createPushButton(buttonComp, Messages.TargetContentsGroup_4, null);
            Composite filterComp = SWTFactory.createComposite(buttonComp, 1, 1, 0, 0, 0);
            filterComp.setLayoutData((Object)new GridData(16384, 1024, true, true));
            this.fShowLabel = SWTFactory.createLabel(filterComp, Messages.BundleContainerTable_9, 1);
            this.fShowPluginsButton = SWTFactory.createCheckButton(filterComp, Messages.BundleContainerTable_14, null, true, 1);
            this.fShowSourceButton = SWTFactory.createCheckButton(filterComp, Messages.BundleContainerTable_15, null, true, 1);
            emptySpace = new Label(filterComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fGroupLabel = SWTFactory.createLabel(filterComp, Messages.TargetContentsGroup_0, 1);
            this.fGroupCombo = SWTFactory.createCombo(filterComp, 8, 1, new String[]{Messages.TargetContentsGroup_1, Messages.TargetContentsGroup_2, Messages.TargetContentsGroup_3});
            gd = new GridData(768);
            gd.horizontalIndent = 10;
            this.fGroupCombo.setLayoutData((Object)gd);
            this.fGroupCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TargetContentsGroup.this.handleGroupChange();
                }
            });
            this.fGroupCombo.select(0);
        }
        this.fSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TargetContentsGroup.this.fTree.getSelection().isEmpty()) {
                    Object[] selected = ((IStructuredSelection)TargetContentsGroup.this.fTree.getSelection()).toArray();
                    TargetContentsGroup.this.handleCheck(selected, true);
                }
            }
        });
        this.fDeselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TargetContentsGroup.this.fTree.getSelection().isEmpty()) {
                    Object[] selected = ((IStructuredSelection)TargetContentsGroup.this.fTree.getSelection()).toArray();
                    TargetContentsGroup.this.handleCheck(selected, false);
                }
            }
        });
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] elements = ((ITreeContentProvider)TargetContentsGroup.this.fTree.getContentProvider()).getElements(TargetContentsGroup.this.fTree.getInput());
                TargetContentsGroup.this.handleCheck(elements, true);
            }
        });
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] elements = ((ITreeContentProvider)TargetContentsGroup.this.fTree.getContentProvider()).getElements(TargetContentsGroup.this.fTree.getInput());
                TargetContentsGroup.this.handleCheck(elements, false);
            }
        });
        this.fSelectRequiredButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetContentsGroup.this.handleCheck(TargetContentsGroup.this.getRequiredElements(TargetContentsGroup.this.fAllBundles, TargetContentsGroup.this.fAllChecked), true);
            }
        });
        this.fShowPluginsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TargetContentsGroup.this.fShowPluginsButton.getSelection()) {
                    TargetContentsGroup.this.fTree.addFilter(TargetContentsGroup.this.fPluginFilter);
                } else {
                    TargetContentsGroup.this.fTree.removeFilter(TargetContentsGroup.this.fPluginFilter);
                    TargetContentsGroup.this.fTree.expandAll();
                    TargetContentsGroup.this.updateCheckState();
                }
                TargetContentsGroup.this.updateButtons();
            }
        });
        this.fShowPluginsButton.setSelection(true);
        GridData gd = new GridData();
        gd.horizontalIndent = 10;
        this.fShowPluginsButton.setLayoutData((Object)gd);
        this.fShowSourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TargetContentsGroup.this.fShowSourceButton.getSelection()) {
                    TargetContentsGroup.this.fTree.addFilter(TargetContentsGroup.this.fSourceFilter);
                } else {
                    TargetContentsGroup.this.fTree.removeFilter(TargetContentsGroup.this.fSourceFilter);
                    TargetContentsGroup.this.fTree.expandAll();
                    TargetContentsGroup.this.updateCheckState();
                }
                TargetContentsGroup.this.updateButtons();
            }
        });
        this.fShowSourceButton.setSelection(true);
        gd = new GridData();
        gd.horizontalIndent = 10;
        this.fShowSourceButton.setLayoutData((Object)gd);
    }

    private void initializeFilters() {
        this.fSourceFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof IResolvedBundle) || !((IResolvedBundle)element).isSourceBundle();
            }
        };
        this.fPluginFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof IResolvedBundle) || ((IResolvedBundle)element).isSourceBundle();
            }
        };
    }

    private IPath getParentPath(IResolvedBundle bundle) {
        URI location = bundle.getBundleInfo().getLocation();
        if (location == null) {
            return new Path(Messages.TargetContentsGroup_8);
        }
        Path path = new Path(URIUtil.toUnencodedString((URI)location));
        path = path.removeLastSegments(1);
        return path;
    }

    protected Map loadManifest(File bundleLocation) throws IOException {
        ZipFile jarFile = null;
        InputStream manifestStream = null;
        String extension = new Path(bundleLocation.getName()).getFileExtension();
        try {
            if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (manifestEntry != null) {
                    manifestStream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                File file = new File(bundleLocation, "META-INF/MANIFEST.MF");
                if (file.exists()) {
                    manifestStream = new FileInputStream(file);
                }
            }
            if (manifestStream == null) {
                return null;
            }
            Map map = ManifestElement.parseBundleManifest((InputStream)manifestStream, new Hashtable(10));
            return map;
        }
        catch (BundleException e) {
            PDEPlugin.log(e);
        }
        finally {
            try {
                if (manifestStream != null) {
                    manifestStream.close();
                }
            }
            catch (IOException e) {
                PDEPlugin.log(e);
            }
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                PDEPlugin.log(e);
            }
        }
        return null;
    }

    private Object[] getRequiredElements(final Collection allBundles, final Collection checkedBundles) {
        final HashSet dependencies = new HashSet();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.TargetContentsGroup_5, 150);
                    ArrayList<URL> allLocations = new ArrayList<URL>(allBundles.size());
                    Iterator iterator = allBundles.iterator();
                    while (iterator.hasNext()) {
                        IResolvedBundle current = (IResolvedBundle)iterator.next();
                        try {
                            URI location = current.getBundleInfo().getLocation();
                            if (location == null) continue;
                            allLocations.add(new File(location).toURL());
                        }
                        catch (MalformedURLException e) {
                            PDEPlugin.log(e);
                            monitor.setCanceled(true);
                            monitor.done();
                            return;
                        }
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                    monitor.worked(20);
                    PDEState state = new PDEState(allLocations.toArray(new URL[allLocations.size()]), true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    if (monitor.isCanceled()) {
                        return;
                    }
                    IPluginModelBase[] models = state.getTargetModels();
                    ArrayList<IPluginModelBase> checkedModels = new ArrayList<IPluginModelBase>(checkedBundles.size());
                    Iterator iterator2 = checkedBundles.iterator();
                    block10: while (iterator2.hasNext()) {
                        BundleInfo bundle = ((IResolvedBundle)iterator2.next()).getBundleInfo();
                        int j = 0;
                        while (j < models.length) {
                            if (models[j].getBundleDescription().getSymbolicName().equals(bundle.getSymbolicName()) && models[j].getBundleDescription().getVersion().toString().equals(bundle.getVersion())) {
                                checkedModels.add(models[j]);
                                continue block10;
                            }
                            ++j;
                        }
                    }
                    monitor.worked(20);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    BundleInfo[] implicitDependencies = TargetContentsGroup.this.fTargetDefinition.getImplicitDependencies();
                    ArrayList<String> implicitIDs = new ArrayList<String>();
                    if (implicitDependencies != null) {
                        int i = 0;
                        while (i < implicitDependencies.length) {
                            implicitIDs.add(implicitDependencies[i].getSymbolicName());
                            ++i;
                        }
                    }
                    monitor.worked(10);
                    dependencies.addAll(DependencyManager.getDependencies((Object[])checkedModels.toArray(), (String[])implicitIDs.toArray(new String[implicitIDs.size()]), (State)state.getState()));
                    monitor.worked(50);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, op);
            HashSet<String> checkedNames = new HashSet<String>(checkedBundles.size());
            Iterator iterator = checkedBundles.iterator();
            while (iterator.hasNext()) {
                IResolvedBundle current = (IResolvedBundle)iterator.next();
                checkedNames.add(current.getBundleInfo().getSymbolicName());
            }
            ArrayList<IResolvedBundle> toCheck = new ArrayList<IResolvedBundle>();
            Iterator iterator2 = this.fAllBundles.iterator();
            while (iterator2.hasNext()) {
                IResolvedBundle bundle = (IResolvedBundle)iterator2.next();
                if (bundle.isSourceBundle()) {
                    String name = bundle.getSourceTarget().getSymbolicName();
                    if (name == null || !dependencies.contains(name) && !checkedNames.contains(name)) continue;
                    toCheck.add(bundle);
                    continue;
                }
                if (!dependencies.contains(bundle.getBundleInfo().getSymbolicName())) continue;
                toCheck.add(bundle);
            }
            return toCheck.toArray();
        }
        catch (InvocationTargetException e) {
            PDEPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
        return new Object[0];
    }

    private void handleCheck(Object[] changedElements, boolean checkState) {
        if (changedElements.length > 0) {
            if (changedElements[0] instanceof IResolvedBundle) {
                Object parent;
                HashSet<IBundleContainer> changedContainers = new HashSet<IBundleContainer>();
                HashSet<IBundleContainer> changedFiles = new HashSet<IBundleContainer>();
                int i = 0;
                while (i < changedElements.length) {
                    parent = ((IResolvedBundle)changedElements[i]).getParentContainer();
                    changedContainers.add((IBundleContainer)parent);
                    Set containerChecked = (Set)this.fContainerChecked.get(parent);
                    parent = this.getParentPath((IResolvedBundle)changedElements[i]);
                    changedFiles.add((IBundleContainer)parent);
                    Set fileChecked = (Set)this.fFileChecked.get(parent);
                    if (checkState) {
                        this.fAllChecked.add(changedElements[i]);
                        containerChecked.add(changedElements[i]);
                        fileChecked.add(changedElements[i]);
                    } else {
                        this.fAllChecked.remove(changedElements[i]);
                        containerChecked.remove(changedElements[i]);
                        fileChecked.remove(changedElements[i]);
                    }
                    this.fTree.setChecked(changedElements[i], checkState);
                    ++i;
                }
                if (this.fGrouping != 0) {
                    Iterator iterator = this.fGrouping == 2 ? changedContainers.iterator() : changedFiles.iterator();
                    while (iterator.hasNext()) {
                        parent = iterator.next();
                        if (this.getChecked(parent).size() == 0) {
                            this.fTree.setGrayChecked(parent, false);
                            continue;
                        }
                        if (this.getChecked(parent).size() == this.getBundleChildren(parent).size()) {
                            this.fTree.setGrayed(parent, false);
                            this.fTree.setChecked(parent, true);
                            continue;
                        }
                        this.fTree.setGrayChecked(parent, true);
                    }
                }
                this.saveIncludedBundleState(changedContainers.toArray());
            } else {
                HashSet totalChanged = new HashSet();
                int i = 0;
                while (i < changedElements.length) {
                    List all;
                    Set checked;
                    this.fTree.setGrayed(changedElements[i], false);
                    this.fTree.setChecked(changedElements[i], checkState);
                    this.fTree.setSubtreeChecked(changedElements[i], checkState);
                    if (this.fGrouping == 2) {
                        checked = (Set)this.fContainerChecked.get(changedElements[i]);
                        all = (List)this.fContainerBundles.get(changedElements[i]);
                    } else {
                        checked = (Set)this.fFileChecked.get(changedElements[i]);
                        all = (List)this.fFileBundles.get(changedElements[i]);
                    }
                    if (checkState) {
                        checked.addAll(all);
                    } else {
                        checked.removeAll(all);
                    }
                    totalChanged.addAll(all);
                    ++i;
                }
                Iterator iterator = this.fGrouping == 2 ? this.fFileChecked.values().iterator() : this.fContainerChecked.values().iterator();
                while (iterator.hasNext()) {
                    Set current = (Set)iterator.next();
                    if (checkState) {
                        current.addAll(totalChanged);
                        continue;
                    }
                    current.removeAll(totalChanged);
                }
                if (checkState) {
                    this.fAllChecked.addAll(totalChanged);
                } else {
                    this.fAllChecked.removeAll(totalChanged);
                }
                if (this.fGrouping == 2) {
                    this.saveIncludedBundleState(changedElements);
                } else {
                    this.saveIncludedBundleState(this.fTargetDefinition.getBundleContainers());
                }
            }
            this.contentChanged();
            this.updateButtons();
            if (this.fGrouping == 2) {
                this.fTree.update(this.fContainerBundles.keySet().toArray(), new String[]{"org.eclipse.jface.text"});
            }
        }
    }

    private void handleGroupChange() {
        int index = this.fGroupCombo != null ? this.fGroupCombo.getSelectionIndex() : this.fGroupComboPart.getSelectionIndex();
        if (index != this.fGrouping) {
            this.fGrouping = index;
            this.fTree.getControl().setRedraw(false);
            this.fTree.refresh(false);
            this.fTree.expandAll();
            this.updateCheckState();
            this.updateButtons();
            this.fTree.getControl().setRedraw(true);
        }
    }

    private void updateCheckState() {
        Iterator iterator = this.fAllChecked.iterator();
        while (iterator.hasNext()) {
            this.fTree.setChecked(iterator.next(), true);
        }
        if (this.fGrouping != 0) {
            Map bundleMap = null;
            Map checkedMap = null;
            if (this.fGrouping == 2) {
                bundleMap = this.fContainerBundles;
                checkedMap = this.fContainerChecked;
            } else if (this.fGrouping == 1) {
                bundleMap = this.fFileBundles;
                checkedMap = this.fFileChecked;
            }
            Iterator iterator2 = bundleMap.keySet().iterator();
            while (iterator2.hasNext()) {
                Object currentParent = iterator2.next();
                Set checked = (Set)checkedMap.get(currentParent);
                if (checked.size() == 0) {
                    this.fTree.setGrayed(currentParent, false);
                    this.fTree.setChecked(currentParent, false);
                    continue;
                }
                if (checked.size() == ((List)bundleMap.get(currentParent)).size()) {
                    this.fTree.setGrayed(currentParent, false);
                    this.fTree.setChecked(currentParent, true);
                    continue;
                }
                this.fTree.setGrayChecked(currentParent, true);
            }
        }
    }

    private void updateButtons() {
        if (this.fTargetDefinition != null && !this.fTree.getSelection().isEmpty()) {
            Object[] selection = ((IStructuredSelection)this.fTree.getSelection()).toArray();
            boolean hasResolveBundle = false;
            boolean hasParent = false;
            boolean allSelected = true;
            boolean noneSelected = true;
            int i = 0;
            while (i < selection.length) {
                boolean checked;
                if (!hasResolveBundle || !hasParent) {
                    if (selection[i] instanceof IResolvedBundle) {
                        hasResolveBundle = true;
                    } else {
                        hasParent = true;
                    }
                }
                if (checked = this.fTree.getChecked(selection[i])) {
                    noneSelected = false;
                } else {
                    allSelected = false;
                }
                ++i;
            }
            this.fSelectButton.setEnabled(!allSelected && (!hasResolveBundle || !hasParent));
            this.fDeselectButton.setEnabled(!noneSelected && (!hasResolveBundle || !hasParent));
        } else {
            this.fSelectButton.setEnabled(false);
            this.fDeselectButton.setEnabled(false);
        }
        this.fSelectAllButton.setEnabled(this.fTargetDefinition != null && this.fAllChecked.size() != this.fAllBundles.size());
        this.fDeselectAllButton.setEnabled(this.fTargetDefinition != null && this.fAllChecked.size() != 0);
        this.fSelectRequiredButton.setEnabled(this.fTargetDefinition != null && this.fAllChecked.size() > 0 && this.fAllChecked.size() != this.fAllBundles.size());
        if (this.fTargetDefinition != null) {
            this.fCountLabel.setText(MessageFormat.format((String)Messages.TargetContentsGroup_9, (Object[])new String[]{Integer.toString(this.fAllChecked.size()), Integer.toString(this.fAllBundles.size())}));
        } else {
            this.fCountLabel.setText("");
        }
    }

    public void setInput(ITargetDefinition input) {
        this.fTargetDefinition = input;
        if (input == null || !input.isResolved()) {
            this.fTree.setInput((Object)Messages.TargetContentsGroup_10);
            this.setEnabled(false);
            return;
        }
        IResolvedBundle[] allResolvedBundles = input.getAllBundles();
        if (allResolvedBundles == null || allResolvedBundles.length == 0) {
            this.fTree.setInput((Object)Messages.TargetContentsGroup_11);
            this.setEnabled(false);
            return;
        }
        this.fTree.setInput((Object)Messages.TargetContentsGroup_12);
        this.setEnabled(false);
        InitalizeJob initJob = new InitalizeJob();
        initJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UIJob refreshJob = new UIJob(this, Messages.TargetContentsGroup_13){
                    final /* synthetic */ 18 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        TargetContentsGroup.access$16(18.access$0(this.this$1)).setInput((Object)TargetContentsGroup.access$4(18.access$0(this.this$1)));
                        TargetContentsGroup.access$16(18.access$0(this.this$1)).expandAll();
                        TargetContentsGroup.access$17(18.access$0(this.this$1));
                        TargetContentsGroup.access$19(18.access$0(this.this$1));
                        18.access$0(this.this$1).setEnabled(true);
                        return Status.OK_STATUS;
                    }
                };
                refreshJob.setSystem(true);
                refreshJob.schedule();
            }

            static /* synthetic */ TargetContentsGroup access$0(18 var0) {
                return var0.TargetContentsGroup.this;
            }
        });
        initJob.schedule();
    }

    private Set getChecked(Object parent) {
        Set result = null;
        if (parent == null) {
            result = this.fAllChecked;
        } else if (this.fGrouping == 2) {
            result = (Set)this.fContainerChecked.get(parent);
        } else if (this.fGrouping == 1) {
            result = (Set)this.fFileChecked.get(parent);
        }
        if (result == null) {
            return new HashSet(0);
        }
        return result;
    }

    private List getBundleChildren(Object parent) {
        List result = null;
        if (parent == null) {
            result = this.fAllBundles;
        } else if (this.fGrouping == 2) {
            result = (List)this.fContainerBundles.get(parent);
        } else if (this.fGrouping == 1) {
            result = (List)this.fFileBundles.get(parent);
        }
        if (result == null) {
            return new ArrayList(0);
        }
        return result;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.updateButtons();
        } else {
            this.fSelectButton.setEnabled(false);
            this.fSelectAllButton.setEnabled(false);
            this.fDeselectButton.setEnabled(false);
            this.fDeselectAllButton.setEnabled(false);
            this.fSelectRequiredButton.setEnabled(false);
            this.fCountLabel.setText("");
        }
        this.fShowLabel.setEnabled(enabled);
        this.fShowPluginsButton.setEnabled(enabled);
        this.fShowSourceButton.setEnabled(enabled);
        this.fGroupLabel.setEnabled(enabled);
        if (this.fGroupCombo != null) {
            this.fGroupCombo.setEnabled(enabled);
        } else {
            this.fGroupComboPart.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public void saveIncludedBundleState(Object[] changeContainers) {
        int i = 0;
        while (i < changeContainers.length) {
            if (changeContainers[i] instanceof IBundleContainer) {
                Set checked = (Set)this.fContainerChecked.get(changeContainers[i]);
                if (checked.size() == ((Collection)this.fContainerBundles.get(changeContainers[i])).size()) {
                    ((IBundleContainer)changeContainers[i]).setIncludedBundles(null);
                } else {
                    ArrayList<BundleInfo> included = new ArrayList<BundleInfo>(checked.size());
                    Iterator iterator = checked.iterator();
                    while (iterator.hasNext()) {
                        IResolvedBundle currentBundle = (IResolvedBundle)iterator.next();
                        included.add(new BundleInfo(currentBundle.getBundleInfo().getSymbolicName(), null, null, -1, false));
                    }
                    ((IBundleContainer)changeContainers[i]).setIncludedBundles(included.toArray(new BundleInfo[included.size()]));
                }
            }
            ++i;
        }
    }

    private class InitalizeJob
    extends Job {
        public InitalizeJob() {
            super(Messages.TargetContentsGroup_13);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Set<IResolvedBundle> checked;
            TargetContentsGroup.this.fAllBundles = new ArrayList();
            TargetContentsGroup.this.fAllChecked = new HashSet();
            TargetContentsGroup.this.fContainerBundles = new HashMap();
            TargetContentsGroup.this.fContainerChecked = new HashMap();
            IBundleContainer[] containers = TargetContentsGroup.this.fTargetDefinition.getBundleContainers();
            int i = 0;
            while (i < containers.length) {
                IResolvedBundle[] containerBundlesArray = containers[i].getAllBundles();
                ArrayList<IResolvedBundle> containerBundles = new ArrayList<IResolvedBundle>(containerBundlesArray.length);
                int j = 0;
                while (j < containerBundlesArray.length) {
                    containerBundles.add(containerBundlesArray[j]);
                    ++j;
                }
                TargetContentsGroup.this.fAllBundles.addAll(containerBundles);
                TargetContentsGroup.this.fContainerBundles.put(containers[i], containerBundles);
                if (containers[i].getIncludedBundles() == null) {
                    HashSet<IResolvedBundle> checked2 = new HashSet<IResolvedBundle>();
                    checked2.addAll(containerBundles);
                    TargetContentsGroup.this.fContainerChecked.put(containers[i], checked2);
                    TargetContentsGroup.this.fAllChecked.addAll(checked2);
                } else {
                    List<IResolvedBundle> includedBundles = Arrays.asList(containers[i].getBundles());
                    Iterator<IResolvedBundle> iterator = includedBundles.iterator();
                    while (iterator.hasNext()) {
                        IResolvedBundle currentIncluded = iterator.next();
                        if (currentIncluded.getStatus().isOK()) continue;
                        ((List)TargetContentsGroup.this.fContainerBundles.get(containers[i])).add(currentIncluded);
                        TargetContentsGroup.this.fAllBundles.add(currentIncluded);
                    }
                    checked = new HashSet();
                    checked.addAll(includedBundles);
                    TargetContentsGroup.this.fContainerChecked.put(containers[i], checked);
                    TargetContentsGroup.this.fAllChecked.addAll(checked);
                }
                ++i;
            }
            TargetContentsGroup.this.fFileBundles = new HashMap();
            TargetContentsGroup.this.fFileChecked = new HashMap();
            Iterator iterator = TargetContentsGroup.this.fAllBundles.iterator();
            while (iterator.hasNext()) {
                IResolvedBundle currentBundle = (IResolvedBundle)iterator.next();
                IPath parentPath = TargetContentsGroup.this.getParentPath(currentBundle);
                ArrayList<IResolvedBundle> bundles = (ArrayList<IResolvedBundle>)TargetContentsGroup.this.fFileBundles.get(parentPath);
                if (bundles == null) {
                    bundles = new ArrayList<IResolvedBundle>();
                    bundles.add(currentBundle);
                    TargetContentsGroup.this.fFileBundles.put(parentPath, bundles);
                    TargetContentsGroup.this.fFileChecked.put(parentPath, new HashSet());
                } else {
                    bundles.add(currentBundle);
                }
                if (!TargetContentsGroup.this.fAllChecked.contains(currentBundle)) continue;
                checked = (Set)TargetContentsGroup.this.fFileChecked.get(parentPath);
                if (checked == null) {
                    checked = new HashSet();
                    checked.add(currentBundle);
                    TargetContentsGroup.this.fFileChecked.put(parentPath, checked);
                    continue;
                }
                checked.add(currentBundle);
            }
            return Status.OK_STATUS;
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return TargetContentsGroup.this.getBundleChildren(parentElement).toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (TargetContentsGroup.this.fGrouping == 0 || element instanceof IResolvedBundle) {
                return false;
            }
            if (element instanceof IBundleContainer || element instanceof IPath) {
                return TargetContentsGroup.this.getBundleChildren(element).size() > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ITargetDefinition) {
                if (TargetContentsGroup.this.fGrouping == 0) {
                    return TargetContentsGroup.this.fAllBundles.toArray();
                }
                if (TargetContentsGroup.this.fGrouping == 2) {
                    return TargetContentsGroup.this.fContainerBundles.keySet().toArray();
                }
                return TargetContentsGroup.this.fFileBundles.keySet().toArray();
            }
            return new Object[]{inputElement};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

