/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.IProgressService;

public class FeatureImportWizardPage
extends WizardPage {
    private static final String SETTINGS_DROPLOCATION = "droplocation";
    private static final String SETTINGS_DOOTHER = "doother";
    private static final String SETTINGS_NOT_BINARY = "notbinary";
    private Label fOtherLocationLabel;
    private Button fRuntimeLocationButton;
    private Button fBrowseButton;
    private Combo fDropLocation;
    private boolean fSelfSetLocation;
    private String fCurrDropLocation;
    private CheckboxTableViewer fFeatureViewer;
    private TablePart fTablePart;
    private IFeatureModel[] fModels;
    private Button fBinaryButton;

    public FeatureImportWizardPage() {
        super("FeatureImportWizardPage");
        this.setTitle(PDEUIMessages.FeatureImportWizard_FirstPage_title);
        this.setDescription(PDEUIMessages.FeatureImportWizard_FirstPage_desc);
        this.fTablePart = new TablePart();
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.fRuntimeLocationButton = new Button(composite, 32);
        this.fillHorizontal((Control)this.fRuntimeLocationButton, 3, false);
        this.fRuntimeLocationButton.setText(PDEUIMessages.FeatureImportWizard_FirstPage_runtimeLocation);
        this.fOtherLocationLabel = new Label(composite, 0);
        this.fOtherLocationLabel.setText(PDEUIMessages.FeatureImportWizard_FirstPage_otherFolder);
        this.fDropLocation = new Combo(composite, 4);
        this.fillHorizontal((Control)this.fDropLocation, 1, true);
        this.fBrowseButton = new Button(composite, 8);
        this.fBrowseButton.setText(PDEUIMessages.FeatureImportWizard_FirstPage_browse);
        this.fBrowseButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseButton);
        this.creatFeatureTable(composite);
        this.fBinaryButton = new Button(composite, 32);
        GridData gd = this.fillHorizontal((Control)this.fBinaryButton, 3, false);
        gd.verticalIndent = 5;
        this.fBinaryButton.setText(PDEUIMessages.FeatureImportWizard_FirstPage_binaryImport);
        this.initializeFields(this.getDialogSettings());
        this.hookListeners();
        this.setControl((Control)composite);
        this.dialogChanged();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.feature_import_first_page");
    }

    private String getTargetHome() {
        PDEPreferencesManager preferences = PDECore.getDefault().getPreferencesManager();
        return preferences.getString("platform_path");
    }

    private void hookListeners() {
        this.fRuntimeLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureImportWizardPage.this.setOtherEnabled(!FeatureImportWizardPage.this.fRuntimeLocationButton.getSelection());
                FeatureImportWizardPage.this.setLocation(FeatureImportWizardPage.this.fRuntimeLocationButton.getSelection() ? FeatureImportWizardPage.this.getTargetHome() : FeatureImportWizardPage.this.fCurrDropLocation);
                FeatureImportWizardPage.this.loadFeatureTable();
            }
        });
        this.fDropLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FeatureImportWizardPage.this.validateDropLocation();
                if (!FeatureImportWizardPage.this.fRuntimeLocationButton.getSelection()) {
                    String newLoc = FeatureImportWizardPage.this.fDropLocation.getText();
                    if (FeatureImportWizardPage.this.getMessageType() != 2 && !newLoc.equals(FeatureImportWizardPage.this.fCurrDropLocation) && !FeatureImportWizardPage.this.fSelfSetLocation) {
                        FeatureImportWizardPage.this.setMessage(PDEUIMessages.FeatureImportWizardPage_reloadLocation, 2);
                    }
                    FeatureImportWizardPage.this.fCurrDropLocation = newLoc;
                }
            }
        });
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath chosen = FeatureImportWizardPage.this.chooseDropLocation();
                if (chosen != null) {
                    FeatureImportWizardPage.this.setLocation(chosen.toOSString());
                    FeatureImportWizardPage.this.loadFeatureTable();
                }
            }
        });
    }

    private GridData fillHorizontal(Control control, int span, boolean grab) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        gd.grabExcessHorizontalSpace = grab;
        control.setLayoutData((Object)gd);
        return gd;
    }

    private void initializeFields(IDialogSettings initialSettings) {
        String[] dropItems = new String[]{};
        boolean doOther = false;
        boolean binary = true;
        if (initialSettings != null) {
            doOther = initialSettings.getBoolean(SETTINGS_DOOTHER);
            binary = !initialSettings.getBoolean(SETTINGS_NOT_BINARY);
            ArrayList<String> items = new ArrayList<String>();
            int i = 0;
            while (i < 6) {
                String curr = initialSettings.get(SETTINGS_DROPLOCATION + String.valueOf(i));
                if (curr != null && !items.contains(curr)) {
                    items.add(curr);
                }
                ++i;
            }
            if (items.size() == 0) {
                items.add("");
            }
            dropItems = items.toArray(new String[items.size()]);
        }
        this.fDropLocation.setItems(dropItems);
        this.fRuntimeLocationButton.setSelection(!doOther);
        this.setOtherEnabled(doOther);
        this.fCurrDropLocation = doOther ? dropItems[0] : this.getTargetHome();
        this.setLocation(this.fCurrDropLocation);
        this.fBinaryButton.setSelection(binary);
        this.validateDropLocation();
        this.loadFeatureTable();
    }

    private void setOtherEnabled(boolean enabled) {
        this.fOtherLocationLabel.setEnabled(enabled);
        this.fDropLocation.setEnabled(enabled);
        this.fBrowseButton.setEnabled(enabled);
    }

    public void storeSettings(boolean finishPressed) {
        IDialogSettings settings = this.getDialogSettings();
        boolean other = !this.fRuntimeLocationButton.getSelection();
        boolean binary = this.fBinaryButton.getSelection();
        if (finishPressed || this.fDropLocation.getText().length() > 0 && other) {
            settings.put(SETTINGS_DROPLOCATION + String.valueOf(0), this.fDropLocation.getText());
            String[] items = this.fDropLocation.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(SETTINGS_DROPLOCATION + String.valueOf(i + 1), items[i]);
                ++i;
            }
        }
        if (finishPressed) {
            settings.put(SETTINGS_DOOTHER, other);
            settings.put(SETTINGS_NOT_BINARY, !binary);
        }
    }

    private IPath chooseDropLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.fDropLocation.getText());
        dialog.setText(PDEUIMessages.FeatureImportWizard_messages_folder_title);
        dialog.setMessage(PDEUIMessages.FeatureImportWizard_messages_folder_message);
        String res = dialog.open();
        return res != null ? new Path(res) : null;
    }

    private void validateDropLocation() {
        String errorMessage = null;
        if (this.isOtherLocation()) {
            IPath curr = this.getDropLocation();
            if (curr.segmentCount() == 0) {
                errorMessage = PDEUIMessages.FeatureImportWizard_errors_locationMissing;
            } else if (!Path.ROOT.isValidPath(this.fDropLocation.getText())) {
                errorMessage = PDEUIMessages.FeatureImportWizard_errors_buildFolderInvalid;
            } else {
                File file = curr.toFile();
                if (!file.exists() || !file.isDirectory()) {
                    errorMessage = PDEUIMessages.FeatureImportWizard_errors_buildFolderMissing;
                }
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
        this.fTablePart.setButtonEnabled(0, errorMessage == null);
    }

    public boolean isBinary() {
        return this.fBinaryButton.getSelection();
    }

    public IPath getDropLocation() {
        return new Path(this.fDropLocation.getText().trim());
    }

    public boolean isOtherLocation() {
        return !this.fRuntimeLocationButton.getSelection();
    }

    private void loadFeatureTable() {
        Object[] models = this.getModels();
        this.fFeatureViewer.setInput((Object)PDEPlugin.getDefault());
        if (models != null) {
            String currItem;
            if (this.getMessageType() == 2) {
                this.setMessage(null, 2);
            }
            if (!this.fRuntimeLocationButton.getSelection() && this.fDropLocation.indexOf(currItem = this.fDropLocation.getText()) == -1) {
                this.fDropLocation.add(currItem, 0);
                if (this.fDropLocation.getItemCount() > 6) {
                    this.fDropLocation.remove(6);
                }
                this.storeSettings(false);
            }
            this.fFeatureViewer.setCheckedElements(models);
        }
        this.fTablePart.updateCounter(models != null ? models.length : 0);
        this.fTablePart.getTableViewer().refresh();
        this.fTablePart.setButtonEnabled(1, models != null && models.length > 0);
        this.fTablePart.setButtonEnabled(2, models != null && models.length > 0);
        this.dialogChanged();
    }

    public void creatFeatureTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.verticalIndent = 5;
        gd.widthHint = 300;
        gd.heightHint = 300;
        container.setLayoutData((Object)gd);
        this.fTablePart.createControl(container);
        this.fFeatureViewer = this.fTablePart.getTableViewer();
        this.fFeatureViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fFeatureViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    public IFeatureModel[] getModels() {
        final IPath home = this.getDropLocation();
        final boolean useRuntimeLocation = this.fRuntimeLocationButton.getSelection() || this.getTargetHome().equals(this.fDropLocation.getText().trim());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(PDEUIMessages.FeatureImportWizard_messages_updating, -1);
                ArrayList<IFeatureModel> result = new ArrayList<IFeatureModel>();
                if (useRuntimeLocation) {
                    IFeatureModel[] allModels = PDECore.getDefault().getFeatureModelManager().getModels();
                    int i = 0;
                    while (i < allModels.length) {
                        if (allModels[i].getUnderlyingResource() == null) {
                            result.add(allModels[i]);
                        }
                        ++i;
                    }
                } else {
                    MultiStatus errors = FeatureImportWizardPage.this.doLoadFeatures(result, FeatureImportWizardPage.this.createPath(home));
                    if (errors != null && errors.getChildren().length > 0) {
                        PDEPlugin.log((IStatus)errors);
                    }
                }
                FeatureImportWizardPage.this.fModels = result.toArray(new IFeatureModel[result.size()]);
                monitor.done();
            }
        };
        IProgressService pservice = PlatformUI.getWorkbench().getProgressService();
        try {
            pservice.busyCursorWhile(runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return this.fModels;
    }

    private File createPath(IPath dropLocation) {
        File featuresDir = new File(dropLocation.toFile(), "features");
        if (featuresDir.exists()) {
            return featuresDir;
        }
        return null;
    }

    private MultiStatus doLoadFeatures(ArrayList result, File path) {
        if (path == null) {
            return null;
        }
        File[] dirs = path.listFiles();
        if (dirs == null) {
            return null;
        }
        ArrayList<IStatus> resultStatus = new ArrayList<IStatus>();
        int i = 0;
        while (i < dirs.length) {
            IStatus status;
            File manifest;
            File dir = dirs[i];
            if (dir.isDirectory() && (manifest = new File(dir, "feature.xml")).exists() && (status = this.doLoadFeature(dir, manifest, result)) != null) {
                resultStatus.add(status);
            }
            ++i;
        }
        return new MultiStatus("org.eclipse.pde.ui", 0, resultStatus.toArray(new IStatus[resultStatus.size()]), PDEUIMessages.FeatureImportWizard_DetailedPage_problemsLoading, null);
    }

    private IStatus doLoadFeature(File dir, File manifest, ArrayList result) {
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation(dir.getAbsolutePath());
        Status status = null;
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(manifest));
            model.load((InputStream)stream, false);
            if (!model.isValid()) {
                status = new Status(2, "org.eclipse.pde.ui", 0, NLS.bind((String)PDEUIMessages.FeatureImportWizardPage_importHasInvalid, (Object)dir), null);
            }
        }
        catch (Exception e) {
            status = new Status(4, "org.eclipse.pde.ui", 0, e.getMessage(), (Throwable)e);
        }
        if (stream != null) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        if (status == null) {
            result.add(model);
        }
        return status;
    }

    public IFeatureModel[] getSelectedModels() {
        Object[] selected = this.fFeatureViewer.getCheckedElements();
        IFeatureModel[] result = new IFeatureModel[selected.length];
        System.arraycopy(selected, 0, result, 0, selected.length);
        return result;
    }

    private void dialogChanged() {
        String message = null;
        if (this.fFeatureViewer != null && this.fFeatureViewer.getTable().getItemCount() == 0) {
            message = PDEUIMessages.FeatureImportWizard_messages_noFeatures;
        }
        this.setMessage(message, 1);
        this.setPageComplete(this.fTablePart.getSelectionCount() > 0);
    }

    public boolean isPageComplete() {
        return this.fTablePart.getSelectionCount() > 0;
    }

    private void setLocation(String location) {
        this.fSelfSetLocation = true;
        this.fDropLocation.setText(location);
        this.fSelfSetLocation = false;
    }

    class ContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (FeatureImportWizardPage.this.fModels != null) {
                return FeatureImportWizardPage.this.fModels;
            }
            return new Object[0];
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart() {
            super(null, new String[]{PDEUIMessages.FeatureImportWizardPage_reload, PDEUIMessages.WizardCheckboxTablePart_selectAll, PDEUIMessages.WizardCheckboxTablePart_deselectAll});
            this.setSelectAllIndex(1);
            this.setDeselectAllIndex(2);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            FeatureImportWizardPage.this.dialogChanged();
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
            viewer.setComparator(ListUtil.FEATURE_COMPARATOR);
            return viewer;
        }

        protected void buttonSelected(Button button, int index) {
            if (index == 0) {
                FeatureImportWizardPage.this.loadFeatureTable();
            } else {
                super.buttonSelected(button, index);
            }
        }
    }
}

