/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportHelper;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.osgi.framework.BundleException;

public class PluginImportOperation
extends WorkspaceJob {
    public static final int IMPORT_BINARY = 1;
    public static final int IMPORT_BINARY_WITH_LINKS = 2;
    public static final int IMPORT_WITH_SOURCE = 3;
    private static final String DEFAULT_SOURCE_DIR = "src";
    private static final String DEFAULT_LIBRARY_NAME = ".";
    private IPluginModelBase[] fModels;
    private int fImportType;
    private ImportQuery fReplaceQuery;
    private ImportQuery fExecutionQuery;
    private Hashtable fProjectClasspaths = new Hashtable();
    private boolean fForceAutobuild;
    private SourceLocationManager fAlternateSource;
    private boolean fPluginsAreInUse = false;

    public PluginImportOperation(IPluginModelBase[] models, int importType, boolean forceAutobuild) {
        super(PDEUIMessages.ImportWizard_title);
        this.fModels = models;
        this.fImportType = importType;
        this.fReplaceQuery = new ImportQuery();
        this.fExecutionQuery = new ImportQuery();
        this.fForceAutobuild = forceAutobuild;
    }

    public void setPluginsInUse(boolean pluginsInUse) {
        this.fPluginsAreInUse = pluginsInUse;
    }

    public void setAlternateSource(SourceLocationManager alternate) {
        this.fAlternateSource = alternate;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(PDEUIMessages.ImportWizard_operation_creating, this.fModels.length + 1);
            MultiStatus multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, PDEUIMessages.ImportWizard_operation_multiProblem, null);
            int i = 0;
            while (i < this.fModels.length) {
                monitor.setTaskName(NLS.bind((String)PDEUIMessages.PluginImportOperation_Importing_plugin, (Object)this.fModels[i].getPluginBase().getId()));
                try {
                    this.importPlugin(this.fModels[i], this.fImportType, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    multiStatus.merge(e.getStatus());
                }
                if (monitor.isCanceled()) {
                    try {
                        this.setClasspaths((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (JavaModelException javaModelException) {}
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                ++i;
            }
            monitor.setTaskName(PDEUIMessages.PluginImportOperation_Set_up_classpaths);
            try {
                this.setClasspaths((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (JavaModelException e) {
                multiStatus.merge(e.getStatus());
            }
            if (!ResourcesPlugin.getWorkspace().isAutoBuilding() && this.fForceAutobuild) {
                this.runBuildJob();
            }
            MultiStatus multiStatus2 = multiStatus;
            return multiStatus2;
        }
        finally {
            monitor.done();
        }
    }

    private void setClasspaths(IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", this.fProjectClasspaths.size());
            Enumeration keys = this.fProjectClasspaths.keys();
            while (keys.hasMoreElements()) {
                IProject project = (IProject)keys.nextElement();
                IClasspathEntry[] classpath = (IClasspathEntry[])this.fProjectClasspaths.get(project);
                monitor.subTask(project.getName());
                JavaCore.create((IProject)project).setRawClasspath(classpath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void importPlugin(IPluginModelBase model, int importType, IProgressMonitor monitor) throws CoreException {
        try {
            File location;
            monitor.beginTask("", 5);
            if (!this.testExecutionEnvironment(model)) {
                return;
            }
            IProject project = this.createProject(model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (project == null) {
                return;
            }
            if (Platform.inDevelopmentMode() && (location = new File(model.getInstallLocation())).isDirectory()) {
                File classpathFile = new File(location, ".classpath");
                File projectFile = new File(location, ".project");
                if (classpathFile.exists() && classpathFile.isFile() && projectFile.exists() && projectFile.isFile()) {
                    PluginImportHelper.importContent(location, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                    return;
                }
            }
            Map sourceMap = null;
            if (importType == 1 || this.isExempt(model, importType) || importType == 3 && !this.canFindSource(model)) {
                sourceMap = this.importAsBinary(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            } else if (importType == 2) {
                sourceMap = this.importAsBinaryWithLinks(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            } else if (importType == 3) {
                this.importAsSource(project, model, new SubProgressMonitor(monitor, 4));
            }
            this.setProjectNatures(project, model);
            if (project.hasNature("org.eclipse.jdt.core.javanature") && project.findMember(".classpath") == null) {
                this.fProjectClasspaths.put(project, ClasspathComputer.getClasspath((IProject)project, (IPluginModelBase)model, (Map)sourceMap, (boolean)true, (boolean)false));
            }
        }
        finally {
            monitor.done();
        }
    }

    private Map importAsBinary(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 4);
            File srcFile = new File(model.getInstallLocation());
            if (this.isJARd(model)) {
                PluginImportHelper.copyArchive(srcFile, project.getFile(srcFile.getName()), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                PluginImportHelper.importContent(new File(model.getInstallLocation()), project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            Map sourceMap = this.importSourceArchives(project, model, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.importAdditionalSourceFiles(project, model, new SubProgressMonitor(monitor, 1));
            this.importRequiredPluginFiles(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.modifyBundleClasspathHeader(project, model);
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.pde.core.BinaryRepositoryProvider");
            project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
            Map map = sourceMap;
            return map;
        }
        finally {
            monitor.done();
        }
    }

    private Map importAsBinaryWithLinks(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        try {
            IFile dstFile;
            monitor.beginTask("", 3);
            File srcFile = new File(model.getInstallLocation());
            if (srcFile.isFile()) {
                dstFile = project.getFile((IPath)new Path(srcFile.getName()));
                dstFile.createLink(srcFile.toURI(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                dstFile = project.getFolder((IPath)new Path(srcFile.getName()));
                dstFile.createLink(srcFile.toURI(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            Map sourceMap = this.importSourceArchives(project, model, 2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.importAdditionalSourceFiles(project, model, new SubProgressMonitor(monitor, 1));
            this.importRequiredPluginFiles(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.modifyBundleClasspathHeader(project, model);
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.pde.core.BinaryRepositoryProvider");
            project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
            Map map = sourceMap;
            return map;
        }
        finally {
            monitor.done();
        }
    }

    private void importAsSource(IProject project, IPluginModelBase model, SubProgressMonitor monitor) throws CoreException {
        try {
            try {
                monitor.beginTask("", 4);
                WorkspaceBuildModel buildModel = new WorkspaceBuildModel(project.getFile("build.properties"));
                HashMap packageLocations = new HashMap();
                boolean sourceFound = this.extractSourceFolders(project, model, buildModel, packageLocations, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
                if (!sourceFound) {
                    sourceFound = this.handleInternalSource(model, buildModel, packageLocations);
                }
                this.importAdditionalSourceFiles(project, model, new SubProgressMonitor((IProgressMonitor)monitor, 1));
                if (this.isJARd(model)) {
                    ZipFile zip = null;
                    try {
                        zip = new ZipFile(new File(model.getInstallLocation()));
                        ZipFileStructureProvider provider = new ZipFileStructureProvider(zip);
                        HashMap collected = new HashMap();
                        PluginImportHelper.collectBinaryFiles((IImportStructureProvider)provider, provider.getRoot(), packageLocations, collected);
                        Iterator iterator = collected.keySet().iterator();
                        while (iterator.hasNext()) {
                            IPath currentDestination = (IPath)iterator.next();
                            IPath destination = project.getFullPath();
                            destination = destination.append(currentDestination);
                            PluginImportHelper.importContent(provider.getRoot(), destination, (IImportStructureProvider)provider, (List)collected.get(currentDestination), (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    finally {
                        if (zip != null) {
                            zip.close();
                        }
                    }
                    monitor.worked(1);
                } else {
                    HashMap collected = new HashMap();
                    File srcFile = new File(model.getInstallLocation());
                    PluginImportHelper.collectBinaryFiles((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, srcFile, packageLocations, collected);
                    Iterator iterator = collected.keySet().iterator();
                    while (iterator.hasNext()) {
                        IPath currentDestination = (IPath)iterator.next();
                        IPath destination = project.getFullPath();
                        destination = destination.append(currentDestination);
                        PluginImportHelper.importContent(srcFile, destination, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (List)collected.get(currentDestination), (IProgressMonitor)new NullProgressMonitor());
                    }
                    monitor.worked(1);
                }
                this.configureBinIncludes(buildModel, model, project);
                buildModel.save();
                monitor.worked(1);
            }
            catch (ZipException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            monitor.done();
        }
    }

    private IProject createProject(IPluginModelBase model, IProgressMonitor monitor) throws TeamException, CoreException {
        try {
            monitor.beginTask("", 2);
            IProject project = this.findProject(model.getPluginBase().getId());
            if (project.exists() || new File(project.getParent().getLocation().toFile(), project.getName()).exists()) {
                switch (this.fReplaceQuery.doQuery(NLS.bind((String)PDEUIMessages.ImportWizard_messages_exists, (Object)project.getName()))) {
                    case 1: {
                        throw new OperationCanceledException();
                    }
                    case 3: {
                        return null;
                    }
                }
                if (RepositoryProvider.isShared((IProject)project)) {
                    RepositoryProvider.unmap((IProject)project);
                }
                if (!project.exists()) {
                    project.create((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                if (!this.safeDeleteCheck(project, monitor)) {
                    throw new CoreException((IStatus)new Status(4, PDEPlugin.getPluginId(), NLS.bind((String)PDEUIMessages.PluginImportOperation_could_not_delete_project, (Object)project.getName())));
                }
                project.delete(true, true, monitor);
            }
            project.create(monitor);
            if (!project.isOpen()) {
                project.open(monitor);
            }
            monitor.worked(1);
            IProject iProject = project;
            return iProject;
        }
        finally {
            monitor.done();
        }
    }

    private IProject findProject(String id) {
        IResource resource;
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model != null && (resource = model.getUnderlyingResource()) != null) {
            return resource.getProject();
        }
        return PDEPlugin.getWorkspace().getRoot().getProject(id);
    }

    private boolean safeDeleteCheck(IProject project, IProgressMonitor monitor) {
        if (!this.fPluginsAreInUse) {
            return true;
        }
        IPluginModelBase base = PluginRegistry.findModel((IProject)project);
        if (base != null) {
            IPluginLibrary[] libraries = base.getPluginBase().getLibraries();
            int i = 0;
            while (i < libraries.length) {
                IResource res = project.findMember(libraries[i].getName());
                if (res != null) {
                    try {
                        if (!ResourcesPlugin.getWorkspace().delete(new IResource[]{res}, true, monitor).isOK()) {
                            return false;
                        }
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private boolean canFindSource(IPluginModelBase model) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean testExecutionEnvironment(IPluginModelBase model) throws OperationCanceledException {
        BundleDescription desc = model.getBundleDescription();
        if (desc != null) {
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            String[] envs = desc.getExecutionEnvironments();
            boolean found = false;
            int i = 0;
            while (i < envs.length) {
                if (manager.getEnvironment(envs[i]) != null) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (envs.length > 0 && !found) {
                switch (this.fExecutionQuery.doQuery(NLS.bind((String)PDEUIMessages.PluginImportOperation_executionEnvironment, (Object)model.getPluginBase().getId(), (Object)envs[0]))) {
                    case 1: {
                        throw new OperationCanceledException();
                    }
                    case 3: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean isExempt(IPluginModelBase model, int importType) {
        String id = model.getPluginBase().getId();
        if (importType == 3 && ("org.apache.ant".equals(id) || "org.eclipse.osgi.util".equals(id) || "org.eclipse.osgi.services".equals(id) || "org.eclipse.core.runtime.compatibility.registry".equals(id))) {
            return true;
        }
        return "org.eclipse.swt".equals(id) && !this.isJARd(model);
    }

    private void runBuildJob() {
        Job buildJob = new Job(PDEUIMessages.CompilersConfigurationBlock_building){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_AUTO_BUILD == family;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PDEPlugin.getWorkspace().build(10, monitor);
                }
                catch (CoreException coreException) {}
                return Status.OK_STATUS;
            }
        };
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.schedule();
    }

    private Map importSourceArchives(IProject project, IPluginModelBase model, int mode, IProgressMonitor monitor) throws CoreException {
        String[] libraries = this.getLibraryNames(model);
        try {
            monitor.beginTask(PDEUIMessages.ImportWizard_operation_importingSource, libraries.length);
            HashMap<String, Path> sourceMap = new HashMap<String, Path>(libraries.length);
            SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
            int i = 0;
            while (i < libraries.length) {
                String zipName = ClasspathUtilCore.getSourceZipName((String)libraries[i]);
                IPluginBase pluginBase = model.getPluginBase();
                IPath srcPath = manager.findSourcePath(pluginBase, (IPath)new Path(zipName));
                if (srcPath == null && this.fAlternateSource != null) {
                    srcPath = this.fAlternateSource.findSourcePath(pluginBase, (IPath)new Path(zipName));
                }
                if (srcPath != null) {
                    zipName = srcPath.lastSegment();
                    Path dstPath = new Path(zipName);
                    sourceMap.put(libraries[i], dstPath);
                    if (project.findMember((IPath)dstPath) == null) {
                        if (mode == 1) {
                            PluginImportHelper.copyArchive(new File(srcPath.toOSString()), project.getFile((IPath)dstPath), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else if (mode == 2) {
                            IFile dstFile = project.getFile((IPath)dstPath);
                            dstFile.createLink(srcPath, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                }
                ++i;
            }
            HashMap<String, Path> hashMap = sourceMap;
            return hashMap;
        }
        finally {
            monitor.done();
        }
    }

    private boolean extractSourceFolders(IProject project, IPluginModelBase model, WorkspaceBuildModel buildModel, Map packageLocations, IProgressMonitor monitor) throws CoreException {
        try {
            String[] libraries = this.getLibraryNames(model);
            monitor.beginTask(PDEUIMessages.ImportWizard_operation_importingSource, libraries.length);
            SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
            if (manager.hasBundleManifestLocation(model.getPluginBase())) {
                File srcFile = manager.findSourcePlugin(model.getPluginBase());
                Set sourceRoots = manager.findSourceRoots(model.getPluginBase());
                int i = 0;
                while (i < libraries.length) {
                    Path sourceDir;
                    if (libraries[i].equals(DEFAULT_LIBRARY_NAME)) {
                        IFolder destination = project.getFolder(DEFAULT_SOURCE_DIR);
                        if (!destination.exists()) {
                            ArrayList<Path> excludeFolders = new ArrayList<Path>(sourceRoots.size());
                            Iterator iterator = sourceRoots.iterator();
                            while (iterator.hasNext()) {
                                String root = (String)iterator.next();
                                if (root.equals(DEFAULT_LIBRARY_NAME)) continue;
                                excludeFolders.add(new Path(root));
                            }
                            HashSet collectedPackages = new HashSet();
                            PluginImportHelper.extractJavaSourceFromArchive(srcFile, excludeFolders, destination.getFullPath(), collectedPackages, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            this.addBuildEntry(buildModel, "source..", "src/");
                            this.addPackageEntries(collectedPackages, (IPath)new Path(DEFAULT_SOURCE_DIR), packageLocations);
                        }
                    } else if (sourceRoots.contains(this.getSourceDirName(libraries[i])) && !project.getFolder((IPath)(sourceDir = new Path(this.getSourceDirName(libraries[i])))).exists()) {
                        HashSet collectedPackages = new HashSet();
                        PluginImportHelper.extractFolderFromArchive(srcFile, (IPath)sourceDir, project.getFullPath(), collectedPackages, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        this.addBuildEntry(buildModel, "source." + libraries[i], sourceDir.toString());
                        this.addPackageEntries(collectedPackages, (IPath)sourceDir, packageLocations);
                    }
                    ++i;
                }
                return true;
            }
            boolean sourceFound = false;
            int i = 0;
            while (i < libraries.length) {
                String zipName = ClasspathUtilCore.getSourceZipName((String)libraries[i]);
                IPath srcPath = manager.findSourcePath(model.getPluginBase(), (IPath)new Path(zipName));
                if (srcPath != null) {
                    sourceFound = true;
                    Path dstPath = new Path(this.getSourceDirName(libraries[i]));
                    IFolder destination = project.getFolder((IPath)dstPath);
                    if (!destination.exists()) {
                        HashSet collectedPackages = new HashSet();
                        PluginImportHelper.extractArchive(new File(srcPath.toOSString()), destination.getFullPath(), collectedPackages, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        this.addBuildEntry(buildModel, "source." + libraries[i], dstPath.toString());
                        this.addPackageEntries(collectedPackages, (IPath)dstPath, packageLocations);
                    }
                }
                ++i;
            }
            boolean bl = sourceFound;
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    private boolean handleInternalSource(IPluginModelBase model, WorkspaceBuildModel buildModel, Map packageLocations) throws CoreException, ZipException, IOException {
        ZipFile zip = null;
        try {
            Object root;
            FileSystemStructureProvider provider;
            if (this.isJARd(model)) {
                zip = new ZipFile(new File(model.getInstallLocation()));
                provider = new ZipFileStructureProvider(zip);
                root = ((ZipFileStructureProvider)provider).getRoot();
            } else {
                provider = FileSystemStructureProvider.INSTANCE;
                root = new File(model.getInstallLocation());
            }
            Path defaultSourcePath = new Path(DEFAULT_SOURCE_DIR);
            ArrayList collected = new ArrayList();
            PluginImportHelper.collectResourcesFromFolder((IImportStructureProvider)provider, root, (IPath)defaultSourcePath, collected);
            if (collected.size() > 0) {
                HashSet packages = new HashSet();
                PluginImportHelper.collectJavaPackages((IImportStructureProvider)provider, collected, (IPath)defaultSourcePath, packages);
                this.addPackageEntries(packages, (IPath)defaultSourcePath, packageLocations);
                this.addBuildEntry(buildModel, "source..", "src/");
                return true;
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
        return false;
    }

    private void addPackageEntries(Set packages, IPath destination, Map packageLocations) {
        Iterator iterator = packages.iterator();
        block0: while (iterator.hasNext()) {
            IPath currentPackage = (IPath)iterator.next();
            packageLocations.put(currentPackage, destination);
            while (currentPackage.segmentCount() > 1) {
                if (packageLocations.containsKey(currentPackage = currentPackage.removeLastSegments(1))) continue block0;
                packageLocations.put(currentPackage, destination);
            }
        }
    }

    private void importAdditionalSourceFiles(IProject project, IPluginModelBase model, SubProgressMonitor monitor) throws CoreException {
        File sourceLocation = PDECore.getDefault().getSourceLocationManager().findSourcePlugin(model.getPluginBase());
        if (sourceLocation != null) {
            if (sourceLocation.isFile()) {
                ZipFile zip = null;
                try {
                    try {
                        zip = new ZipFile(sourceLocation);
                        ZipFileStructureProvider provider = new ZipFileStructureProvider(zip);
                        ArrayList collected = new ArrayList();
                        PluginImportHelper.collectNonJavaNonBuildFiles((IImportStructureProvider)provider, provider.getRoot(), collected);
                        PluginImportHelper.importContent(provider.getRoot(), project.getFullPath(), (IImportStructureProvider)provider, collected, (IProgressMonitor)monitor);
                    }
                    catch (IOException e) {
                        Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                        throw new CoreException((IStatus)status);
                    }
                }
                catch (Throwable throwable) {
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                ArrayList collected = new ArrayList();
                PluginImportHelper.collectNonJavaNonBuildFiles((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, sourceLocation, collected);
                PluginImportHelper.importContent(sourceLocation, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, collected, (IProgressMonitor)monitor);
            }
        }
    }

    private void importRequiredPluginFiles(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        if (this.isJARd(model)) {
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(new File(model.getInstallLocation()));
                    ZipFileStructureProvider provider = new ZipFileStructureProvider(zip);
                    ArrayList collected = new ArrayList();
                    PluginImportHelper.collectRequiredBundleFiles((IImportStructureProvider)provider, provider.getRoot(), collected);
                    PluginImportHelper.importContent(provider.getRoot(), project.getFullPath(), (IImportStructureProvider)provider, collected, monitor);
                }
                catch (IOException e) {
                    Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            ArrayList collected = new ArrayList();
            File file = new File(model.getInstallLocation());
            PluginImportHelper.collectRequiredBundleFiles((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, file, collected);
            PluginImportHelper.importContent(file, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, collected, monitor);
        }
    }

    private String addBuildEntry(WorkspaceBuildModel model, String key, String value) throws CoreException {
        String[] tokens;
        IBuild build = model.getBuild(true);
        IBuildEntry entry = build.getEntry(key);
        if (entry == null) {
            entry = model.getFactory().createEntry(key);
            entry.addToken(value);
            build.add(entry);
        }
        return (tokens = entry.getTokens()).length > 0 ? tokens[0] : "src/";
    }

    private void configureBinIncludes(WorkspaceBuildModel buildModel, IPluginModelBase model, IProject project) throws CoreException {
        IBuild build = buildModel.getBuild(true);
        IBuildEntry entry = build.getEntry("bin.includes");
        HashMap libraryDirs = this.getSourceDirectories(build);
        if (entry == null) {
            entry = buildModel.getFactory().createEntry("bin.includes");
            File location = new File(model.getInstallLocation());
            if (location.isDirectory()) {
                File[] files = location.listFiles();
                int i = 0;
                while (i < files.length) {
                    String token = files[i].getName();
                    if (project.findMember(token) != null || build.getEntry("source." + token) != null) {
                        if (files[i].isDirectory() && libraryDirs.containsKey(token = String.valueOf(token) + "/")) {
                            token = libraryDirs.get(token).toString();
                        }
                        entry.addToken(token);
                    }
                    ++i;
                }
            } else {
                String[] tokens = PluginImportHelper.getTopLevelResources(location);
                int i = 0;
                while (i < tokens.length) {
                    IResource res = project.findMember(tokens[i]);
                    if (!(res == null && build.getEntry("source." + tokens[i]) == null || res instanceof IFolder && libraryDirs.containsKey(tokens[i]))) {
                        entry.addToken(tokens[i]);
                    }
                    ++i;
                }
            }
            buildModel.getBuild().add(entry);
        }
    }

    private HashMap getSourceDirectories(IBuild build) {
        HashMap<String, String> set = new HashMap<String, String>();
        IBuildEntry[] entries = build.getBuildEntries();
        int i = 0;
        while (i < entries.length) {
            String name = entries[i].getName();
            if (name.startsWith("source.")) {
                name = name.substring(7);
                String[] tokens = entries[i].getTokens();
                int j = 0;
                while (j < tokens.length) {
                    set.put(tokens[j], name);
                    ++j;
                }
            }
            ++i;
        }
        return set;
    }

    private void modifyBundleClasspathHeader(IProject project, IPluginModelBase base) {
        IFile file = project.getFile("META-INF/MANIFEST.MF");
        if (file.exists()) {
            WorkspaceBundleModel bmodel = new WorkspaceBundleModel(file);
            IBundle bundle = bmodel.getBundle();
            String classpath = bundle.getHeader("Bundle-ClassPath");
            if (classpath == null) {
                bundle.setHeader("Bundle-ClassPath", ClasspathUtilCore.getFilename((IPluginModelBase)base));
            } else {
                try {
                    ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)classpath);
                    StringBuffer buffer = new StringBuffer();
                    int i = 0;
                    while (i < elements.length) {
                        if (buffer.length() > 0) {
                            buffer.append(",");
                            buffer.append(System.getProperty("line.separator"));
                            buffer.append(" ");
                        }
                        if (elements[i].getValue().equals(DEFAULT_LIBRARY_NAME)) {
                            buffer.append(ClasspathUtilCore.getFilename((IPluginModelBase)base));
                        } else {
                            buffer.append(elements[i].getValue());
                        }
                        ++i;
                    }
                    bundle.setHeader("Bundle-ClassPath", buffer.toString());
                }
                catch (BundleException bundleException) {}
            }
            bmodel.save();
        }
    }

    private boolean needsJavaNature(IProject project, IPluginModelBase model) {
        IFile buildProperties;
        if (model.getPluginBase().getLibraries().length > 0) {
            return true;
        }
        BundleDescription desc = model.getBundleDescription();
        if (desc != null) {
            if (desc.getExecutionEnvironments().length > 0) {
                return true;
            }
            if (desc.getExportPackages().length > 0) {
                return true;
            }
        }
        if ((buildProperties = project.getFile("build.properties")).exists()) {
            WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildProperties);
            buildModel.load();
            IBuild build = buildModel.getBuild();
            if (build != null) {
                IBuildEntry buildEntry;
                IBuildEntry iBuildEntry = buildEntry = build == null ? null : build.getEntry("source..");
                if (buildEntry != null) {
                    return true;
                }
            }
        }
        return false;
    }

    private void setProjectNatures(IProject project, IPluginModelBase model) throws CoreException {
        IProjectDescription desc = project.getDescription();
        if (!desc.hasNature("org.eclipse.pde.PluginNature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", null);
        }
        if (!desc.hasNature("org.eclipse.jdt.core.javanature") && this.needsJavaNature(project, model)) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", null);
        }
    }

    private String[] getLibraryNames(IPluginModelBase model) {
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < libraries.length) {
            list.add(ClasspathUtilCore.expandLibraryName((String)libraries[i].getName()));
            ++i;
        }
        if (libraries.length == 0 && this.isJARd(model)) {
            list.add(DEFAULT_LIBRARY_NAME);
        }
        return list.toArray(new String[list.size()]);
    }

    private String getSourceDirName(String libraryName) {
        int dot = libraryName.lastIndexOf(46);
        return dot != -1 ? String.valueOf(libraryName.substring(0, dot)) + DEFAULT_SOURCE_DIR : libraryName;
    }

    private boolean isJARd(IPluginModelBase model) {
        return new File(model.getInstallLocation()).isFile();
    }

    private static class ImportQuery {
        private int fCreateDialog = 0;

        private ImportQuery() {
        }

        public int doQuery(String message) {
            if (this.fCreateDialog > 0) {
                return 2;
            }
            if (this.fCreateDialog < 0) {
                return 3;
            }
            int[] result = new int[]{1};
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(this, message, result){
                final /* synthetic */ ImportQuery this$1;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = importQuery;
                    this.val$message = string;
                    this.val$result = nArray;
                }

                public void run() {
                    MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), PDEUIMessages.ImportWizard_messages_title, null, this.val$message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    this.val$result[0] = dialog.open();
                }
            });
            switch (result[0]) {
                case 0: {
                    return 2;
                }
                case 1: {
                    this.fCreateDialog = 1;
                    return 2;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    this.fCreateDialog = -1;
                    return 3;
                }
            }
            return 1;
        }
    }
}

