/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.refactoring.PDERefactor;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifestsProcessor;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifestsWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OrganizeManifestsAction
implements IWorkbenchWindowActionDelegate {
    private ISelection fSelection;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (!PlatformUI.getWorkbench().saveAllEditors(true)) {
            return;
        }
        if (this.fSelection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.fSelection;
            Iterator it = ssel.iterator();
            ArrayList<IProject> projects = new ArrayList<IProject>();
            while (it.hasNext()) {
                Object element = it.next();
                IProject proj = null;
                if (element instanceof IFile) {
                    proj = ((IFile)element).getProject();
                } else if (element instanceof IProject) {
                    proj = (IProject)element;
                }
                if (proj == null || !proj.exists(ICoreConstants.MANIFEST_PATH)) continue;
                projects.add(proj);
            }
            if (projects.size() > 0) {
                OrganizeManifestsProcessor processor = new OrganizeManifestsProcessor(projects);
                PDERefactor refactor = new PDERefactor(processor);
                OrganizeManifestsWizard wizard = new OrganizeManifestsWizard(refactor);
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                try {
                    op.run(PDEPlugin.getActiveWorkbenchShell(), "");
                }
                catch (InterruptedException interruptedException) {}
            } else {
                MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.OrganizeManifestsWizardPage_title, (String)PDEUIMessages.OrganizeManifestsWizardPage_errorMsg);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }
}

