/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.text.NumberFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.ui.ValidationDialogServiceUI;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public abstract class SizeComputingWizardPage
extends ResolutionResultsWizardPage {
    protected Label sizeInfo;
    protected long size;
    Job sizingJob;
    private ProvisioningPlan lastComputedPlan = null;

    protected SizeComputingWizardPage(Policy policy, IUElementListRoot root, String profileID, PlannerResolutionOperation initialResolution) {
        super(policy, root, profileID, initialResolution);
        if (initialResolution != null) {
            this.computeSizing(initialResolution.getProvisioningPlan(), profileID, initialResolution.getProvisioningContext());
        } else {
            this.size = -3L;
        }
    }

    protected void computeSizing(final ProvisioningPlan plan, final String id, final ProvisioningContext provisioningContext) {
        if (plan == this.lastComputedPlan) {
            return;
        }
        this.lastComputedPlan = plan;
        this.size = -1L;
        this.updateSizingInfo();
        if (this.sizingJob != null) {
            this.sizingJob.cancel();
        }
        this.sizingJob = new Job(ProvUIMessages.SizeComputingWizardPage_SizeJobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    SizeComputingWizardPage.this.size = ProvisioningUtil.getSize(plan, id, provisioningContext, monitor);
                }
                catch (ProvisionException e) {
                    return e.getStatus();
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (SizeComputingWizardPage.this.display != null) {
                    SizeComputingWizardPage.this.display.asyncExec(new Runnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            1.access$0(this.this$1).updateSizingInfo();
                        }
                    });
                }
                return Status.OK_STATUS;
            }

            static /* synthetic */ SizeComputingWizardPage access$0(1 var0) {
                return var0.SizeComputingWizardPage.this;
            }
        };
        this.sizingJob.setUser(false);
        this.sizingJob.setSystem(true);
        this.sizingJob.setProperty(ValidationDialogServiceUI.SUPPRESS_AUTHENTICATION_JOB_MARKER, (Object)Boolean.toString(true));
        this.sizingJob.schedule();
        this.sizingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                SizeComputingWizardPage.this.sizingJob = null;
            }
        });
    }

    protected void createSizingInfo(Composite parent) {
        this.sizeInfo = new Label(parent, 0);
        GridData data = new GridData(4, 4, true, false);
        this.sizeInfo.setLayoutData((Object)data);
        this.updateSizingInfo();
    }

    protected void updateSizingInfo() {
        if (this.sizeInfo != null && !this.sizeInfo.isDisposed()) {
            if (this.size == -3L) {
                this.sizeInfo.setVisible(false);
            } else {
                this.sizeInfo.setText(NLS.bind((String)ProvUIMessages.UpdateOrInstallWizardPage_Size, (Object)this.getFormattedSize()));
                this.sizeInfo.setVisible(true);
            }
        }
    }

    protected String getFormattedSize() {
        if (this.size == -1L || this.size == -2L) {
            return ProvUIMessages.IUDetailsLabelProvider_Unknown;
        }
        if (this.size > 1000L) {
            long kb = this.size / 1000L;
            return NLS.bind((String)ProvUIMessages.IUDetailsLabelProvider_KB, (Object)NumberFormat.getInstance().format(new Long(kb)));
        }
        return NLS.bind((String)ProvUIMessages.IUDetailsLabelProvider_Bytes, (Object)NumberFormat.getInstance().format(new Long(this.size)));
    }

    public void dispose() {
        if (this.sizingJob != null) {
            this.sizingJob.cancel();
            this.sizingJob = null;
        }
    }

    public void updateStatus(IUElementListRoot root, PlannerResolutionOperation op) {
        super.updateStatus(root, op);
        if (op.getProvisioningPlan() != null) {
            this.computeSizing(op.getProvisioningPlan(), this.getProfileId(), op.getProvisioningContext());
        }
    }

    protected IQueryable getQueryable(ProvisioningPlan plan) {
        return plan.getAdditions();
    }
}

