/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.SelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.UpdateWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.WizardWithLicenses;
import org.eclipse.equinox.internal.p2.ui.model.AvailableUpdateElement;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerHelper;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.ui.ElementQueryDescriptor;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.provisional.p2.ui.model.Updates;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class UpdateWizard
extends WizardWithLicenses {
    IInstallableUnit[] iusToReplace;
    QueryableMetadataRepositoryManager manager;
    SelectableIUsPage mainPage;
    boolean skipSelectionsPage = false;
    static /* synthetic */ Class class$0;

    public static IInstallableUnit[] getIUsToReplace(Object[] replacementElements) {
        HashSet<IInstallableUnit> iusToReplace = new HashSet<IInstallableUnit>();
        int i = 0;
        while (i < replacementElements.length) {
            if (replacementElements[i] instanceof AvailableUpdateElement) {
                iusToReplace.add(((AvailableUpdateElement)replacementElements[i]).getIUToBeUpdated());
            }
            ++i;
        }
        return iusToReplace.toArray(new IInstallableUnit[iusToReplace.size()]);
    }

    public static IInstallableUnit[] getReplacementIUs(Object[] replacementElements) {
        HashSet<IInstallableUnit> replacements = new HashSet<IInstallableUnit>();
        int i = 0;
        while (i < replacementElements.length) {
            if (replacementElements[i] instanceof AvailableUpdateElement) {
                replacements.add(((AvailableUpdateElement)replacementElements[i]).getIU());
            }
            ++i;
        }
        return replacements.toArray(new IInstallableUnit[replacements.size()]);
    }

    public static ProfileChangeRequest createProfileChangeRequest(IInstallableUnit[] iusToUpdate, String profileId, IUElementListRoot root, Collection initialSelections, IProgressMonitor monitor) {
        IProfile profile;
        HashSet<IInstallableUnit> toBeUpdated = new HashSet<IInstallableUnit>();
        HashSet<AvailableUpdateElement> elementsToPlan = new HashSet<AvailableUpdateElement>();
        ArrayList<AvailableUpdateElement> allReplacements = new ArrayList<AvailableUpdateElement>();
        try {
            profile = ProvisioningUtil.getProfile(profileId);
            if (profile == null) {
                return null;
            }
        }
        catch (ProvisionException provisionException) {
            return null;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)ProvUIMessages.ProfileChangeRequestBuildingRequest, (int)(100 * iusToUpdate.length));
        int i = 0;
        while (i < iusToUpdate.length) {
            boolean selectionSpecified = false;
            ElementQueryDescriptor descriptor = Policy.getDefault().getQueryProvider().getQueryDescriptor(new Updates(profileId, new IInstallableUnit[]{iusToUpdate[i]}));
            Iterator iter = descriptor.performQuery((IProgressMonitor)sub).iterator();
            ArrayList<AvailableUpdateElement> currentReplacements = new ArrayList<AvailableUpdateElement>();
            while (iter.hasNext()) {
                Collector alreadyInstalled;
                IInstallableUnit iu;
                Object e = iter.next();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iu = (IInstallableUnit)ProvUI.getAdapter(e, clazz)) == null || !(alreadyInstalled = profile.query((Query)new InstallableUnitQuery(iu.getId(), iu.getVersion()), new Collector(), null)).isEmpty()) continue;
                toBeUpdated.add(iusToUpdate[i]);
                AvailableUpdateElement element = new AvailableUpdateElement(root, iu, iusToUpdate[i], profileId, true);
                currentReplacements.add(element);
                allReplacements.add(element);
                if (initialSelections == null || !initialSelections.contains(element)) continue;
                elementsToPlan.add(element);
                selectionSpecified = true;
            }
            if (!selectionSpecified) {
                HashMap<String, AvailableUpdateElement> latestVersions = new HashMap<String, AvailableUpdateElement>();
                boolean foundUpdate = false;
                boolean foundPatch = false;
                int j = 0;
                while (j < currentReplacements.size()) {
                    IInstallableUnit latestIU;
                    String key;
                    AvailableUpdateElement replacementElement = (AvailableUpdateElement)currentReplacements.get(j);
                    if (Boolean.toString(true).equals(replacementElement.getIU().getProperty("org.eclipse.equinox.p2.type.patch"))) {
                        foundPatch = true;
                        key = replacementElement.getIU().getId();
                    } else {
                        foundUpdate = true;
                        key = replacementElement.getIUToBeUpdated().getId();
                    }
                    AvailableUpdateElement latestElement = (AvailableUpdateElement)latestVersions.get(key);
                    IInstallableUnit iInstallableUnit = latestIU = latestElement == null ? null : latestElement.getIU();
                    if (latestIU == null || replacementElement.getIU().getVersion().compareTo((Object)latestIU.getVersion()) > 0) {
                        latestVersions.put(key, replacementElement);
                    }
                    ++j;
                }
                if (foundPatch && foundUpdate) {
                    HashSet keys = new HashSet();
                    keys.addAll(latestVersions.keySet());
                    Iterator keyIter = keys.iterator();
                    while (keyIter.hasNext()) {
                        String id = (String)keyIter.next();
                        if (id.equals(iusToUpdate[i].getId())) continue;
                        latestVersions.remove(id);
                    }
                }
                elementsToPlan.addAll(latestVersions.values());
            }
            sub.worked(100);
            ++i;
        }
        if (root != null) {
            root.setChildren(allReplacements.toArray());
        }
        if (toBeUpdated.size() <= 0 || elementsToPlan.isEmpty()) {
            sub.done();
            return null;
        }
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((String)profileId);
        Iterator iter = elementsToPlan.iterator();
        while (iter.hasNext()) {
            AvailableUpdateElement element = (AvailableUpdateElement)iter.next();
            IInstallableUnit theUpdate = element.getIU();
            if (initialSelections != null && !initialSelections.contains(element)) {
                initialSelections.add(element);
            }
            request.addInstallableUnits(new IInstallableUnit[]{theUpdate});
            request.setInstallableUnitProfileProperty(theUpdate, "org.eclipse.equinox.p2.type.root", (Object)Boolean.toString(true));
            if (Boolean.toString(true).equals(theUpdate.getProperty("org.eclipse.equinox.p2.type.patch"))) {
                request.setInstallableUnitInclusionRules(theUpdate, PlannerHelper.createOptionalInclusionRule((IInstallableUnit)theUpdate));
                continue;
            }
            request.removeInstallableUnits(new IInstallableUnit[]{element.getIUToBeUpdated()});
        }
        sub.done();
        return request;
    }

    public UpdateWizard(Policy policy, String profileId, IUElementListRoot root, Object[] initialSelections, PlannerResolutionOperation initialResolution, QueryableMetadataRepositoryManager manager) {
        super(policy, profileId, root, initialSelections, initialResolution);
        this.setWindowTitle(ProvUIMessages.UpdateAction_UpdatesAvailableTitle);
        this.setDefaultPageImageDescriptor(ProvUIImages.getImageDescriptor("wizban/update_wiz.gif"));
        this.manager = manager;
    }

    protected ISelectableIUsPage createMainPage(IUElementListRoot input, Object[] selections) {
        this.mainPage = new SelectableIUsPage(this.policy, input, selections, this.profileId);
        this.mainPage.setTitle(ProvUIMessages.UpdateAction_UpdatesAvailableTitle);
        this.mainPage.setDescription(ProvUIMessages.UpdateAction_UpdatesAvailableMessage);
        this.mainPage.updateStatus(input, this.resolutionOperation);
        return this.mainPage;
    }

    protected ResolutionResultsWizardPage createResolutionPage() {
        return new UpdateWizardPage(this.policy, this.root, this.profileId, this.resolutionOperation);
    }

    protected IUElementListRoot makeResolutionElementRoot(Object[] selectedElements) {
        IUElementListRoot elementRoot = new IUElementListRoot();
        ArrayList<AvailableUpdateElement> list = new ArrayList<AvailableUpdateElement>(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            if (selectedElements[i] instanceof AvailableUpdateElement) {
                AvailableUpdateElement element = (AvailableUpdateElement)selectedElements[i];
                AvailableUpdateElement newElement = new AvailableUpdateElement(elementRoot, element.getIU(), element.getIUToBeUpdated(), this.profileId, this.policy.getQueryContext().getShowProvisioningPlanChildren());
                list.add(newElement);
            }
            ++i;
        }
        elementRoot.setChildren(list.toArray());
        return elementRoot;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.manager != null) {
            pageContainer.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    UpdateWizard.this.manager.reportAccumulatedStatus();
                }
            });
        }
    }

    protected ProfileChangeRequest computeProfileChangeRequest(Object[] selectedElements, MultiStatus additionalStatus, IProgressMonitor monitor) {
        ArrayList<Object> initialSelections = new ArrayList<Object>();
        initialSelections.addAll(Arrays.asList(selectedElements));
        return UpdateWizard.createProfileChangeRequest(UpdateWizard.getIUsToReplace(selectedElements), this.profileId, null, initialSelections, monitor);
    }

    protected IResolutionErrorReportingPage getErrorReportingPage() {
        return this.mainPage;
    }

    public void setSkipSelectionsPage(boolean skipSelectionsPage) {
        this.skipSelectionsPage = skipSelectionsPage;
    }

    public IWizardPage getStartingPage() {
        IWizardPage page;
        if (this.skipSelectionsPage && (page = this.getNextPage(this.mainPage)) != null) {
            return page;
        }
        return this.mainPage;
    }
}

