/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.internal.ui.views.ViewContextService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ViewContextManager
implements IWindowListener {
    private Map fWindowToService = new HashMap();
    private static ViewContextManager fgManager;

    public static ViewContextManager getDefault() {
        if (fgManager == null) {
            fgManager = new ViewContextManager();
        }
        return fgManager;
    }

    private ViewContextManager() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] workbenchWindows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < workbenchWindows.length) {
            IWorkbenchWindow window = workbenchWindows[i];
            this.windowOpened(window);
            ++i;
        }
        workbench.addWindowListener((IWindowListener)this);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        ViewContextService service = (ViewContextService)this.fWindowToService.get(window);
        if (service != null) {
            service.dispose();
        }
    }

    public void windowOpened(IWorkbenchWindow window) {
        ViewContextService service = (ViewContextService)this.fWindowToService.get(window);
        if (service == null) {
            service = new ViewContextService(window);
            this.fWindowToService.put(window, service);
        }
    }

    public ViewContextService getService(IWorkbenchWindow window) {
        return (ViewContextService)this.fWindowToService.get(window);
    }
}

