/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.CopyBreakpointsAction;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.PasteBreakpointsAction;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.RemoveFromWorkingSetAction;
import org.eclipse.debug.internal.ui.actions.breakpoints.OpenBreakpointMarkerAction;
import org.eclipse.debug.internal.ui.actions.breakpoints.ShowSupportedBreakpointsAction;
import org.eclipse.debug.internal.ui.actions.breakpoints.SkipAllBreakpointsAction;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointOrganizerManager;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsComparator;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsContentProvider;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsDragAdapter;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsDropAdapter;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsLabelProvider;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewEventHandler;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewer;
import org.eclipse.debug.internal.ui.views.breakpoints.IBreakpointOrganizer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class BreakpointsView
extends AbstractDebugView
implements ISelectionListener,
IBreakpointManagerListener,
IPerspectiveListener2 {
    private BreakpointsViewEventHandler fEventHandler;
    private ICheckStateListener fCheckListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object source = event.getElement();
            if (source instanceof BreakpointContainer) {
                BreakpointsView.this.handleContainerChecked(event, (BreakpointContainer)((Object)source));
            } else if (source instanceof IBreakpoint) {
                BreakpointsView.this.handleBreakpointChecked(event, (IBreakpoint)source);
            }
        }
    };
    private boolean fIsTrackingSelection = false;
    private static String KEY_IS_TRACKING_SELECTION = "isTrackingSelection";
    private static String KEY_VALUE = "value";
    private static final String ACTION_REMOVE_FROM_GROUP = "RemoveFromGroup";
    private BreakpointsContentProvider fContentProvider;
    private Clipboard fClipboard;
    private IContextActivation fActivatedContext;
    private static IMemento fgMemento;
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.getSite().getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    protected Viewer createViewer(Composite parent) {
        this.fContentProvider = new BreakpointsContentProvider();
        BreakpointsViewer viewer = new BreakpointsViewer(new Tree(parent, 802));
        this.setViewer((Viewer)viewer);
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.setComparator(new BreakpointsComparator());
        viewer.setInput(DebugPlugin.getDefault().getBreakpointManager());
        viewer.addCheckStateListener(this.fCheckListener);
        viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                ((BreakpointsViewer)BreakpointsView.this.getViewer()).updateCheckedState(event.getElement());
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new BreakpointsLabelProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        this.initIsTrackingSelection();
        this.initBreakpointOrganizers();
        this.setEventHandler(new BreakpointsViewEventHandler(this));
        this.initDragAndDrop();
        return viewer;
    }

    private void initDragAndDrop() {
        BreakpointsViewer viewer = (BreakpointsViewer)this.getViewer();
        int ops = 3;
        viewer.addDropSupport(ops, new Transfer[]{LocalSelectionTransfer.getInstance()}, (DropTargetListener)new BreakpointsDropAdapter(viewer));
        viewer.addDragSupport(ops, new Transfer[]{LocalSelectionTransfer.getInstance()}, (DragSourceListener)new BreakpointsDragAdapter(viewer));
    }

    private void initIsTrackingSelection() {
        IMemento node;
        IMemento memento = this.getMemento();
        if (memento != null && (node = memento.getChild(KEY_IS_TRACKING_SELECTION)) != null) {
            this.setTrackSelection(Boolean.valueOf(node.getString(KEY_VALUE)));
            return;
        }
        this.setTrackSelection(false);
    }

    private void initBreakpointOrganizers() {
        IMemento memento = this.getMemento();
        if (memento != null) {
            IMemento node = memento.getChild("breakpointOrganizers");
            if (node == null) {
                this.fContentProvider.setOrganizers(null);
            } else {
                String value = node.getString(KEY_VALUE);
                if (value != null) {
                    String[] ids = value.split(",");
                    BreakpointOrganizerManager manager = BreakpointOrganizerManager.getDefault();
                    ArrayList<IBreakpointOrganizer> organziers = new ArrayList<IBreakpointOrganizer>();
                    int i = 0;
                    while (i < ids.length) {
                        IBreakpointOrganizer organizer = manager.getOrganizer(ids[i]);
                        if (organizer != null) {
                            organziers.add(organizer);
                        }
                        ++i;
                    }
                    this.fContentProvider.setOrganizers(organziers.toArray(new IBreakpointOrganizer[organziers.size()]));
                }
            }
        }
    }

    protected IMemento getMemento() {
        if (fgMemento != null) {
            return fgMemento;
        }
        return super.getMemento();
    }

    public void updateCheckedState(Object element) {
        ((BreakpointsViewer)this.getViewer()).updateCheckedState(element);
    }

    public CheckboxTreeViewer getCheckboxViewer() {
        return (CheckboxTreeViewer)this.getViewer();
    }

    public ITreeContentProvider getTreeContentProvider() {
        return this.fContentProvider;
    }

    private void handleBreakpointChecked(final CheckStateChangedEvent event, final IBreakpoint breakpoint) {
        final boolean enable = event.getChecked();
        String jobName = enable ? DebugUIViewsMessages.BreakpointsView_0 : DebugUIViewsMessages.BreakpointsView_1;
        new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    breakpoint.setEnabled(enable);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    Display.getDefault().asyncExec(new Runnable(this, enable, e, event, breakpoint){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ boolean val$enable;
                        private final /* synthetic */ CoreException val$e;
                        private final /* synthetic */ CheckStateChangedEvent val$event;
                        private final /* synthetic */ IBreakpoint val$breakpoint;
                        {
                            this.this$1 = var1_1;
                            this.val$enable = bl;
                            this.val$e = coreException;
                            this.val$event = checkStateChangedEvent;
                            this.val$breakpoint = iBreakpoint;
                        }

                        public void run() {
                            String titleState = this.val$enable ? DebugUIViewsMessages.BreakpointsView_6 : DebugUIViewsMessages.BreakpointsView_7;
                            String messageState = this.val$enable ? DebugUIViewsMessages.BreakpointsView_8 : DebugUIViewsMessages.BreakpointsView_9;
                            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), MessageFormat.format((String)DebugUIViewsMessages.BreakpointsView_10, (Object[])new String[]{titleState}), MessageFormat.format((String)DebugUIViewsMessages.BreakpointsView_11, (Object[])new String[]{messageState}), this.val$e);
                            3.access$0(this.this$1).getCheckboxViewer().removeCheckStateListener(BreakpointsView.access$2(3.access$0(this.this$1)));
                            this.val$event.getCheckable().setChecked((Object)this.val$breakpoint, !this.val$event.getChecked());
                            3.access$0(this.this$1).getCheckboxViewer().addCheckStateListener(BreakpointsView.access$2(3.access$0(this.this$1)));
                        }
                    });
                    return Status.CANCEL_STATUS;
                }
            }

            static /* synthetic */ BreakpointsView access$0(3 var0) {
                return var0.BreakpointsView.this;
            }
        }.schedule();
    }

    private void handleContainerChecked(CheckStateChangedEvent event, BreakpointContainer container) {
        final IBreakpoint[] breakpoints = container.getBreakpoints();
        final boolean enable = event.getChecked();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    int i = 0;
                    while (i < breakpoints.length) {
                        IBreakpoint breakpoint = breakpoints[i];
                        breakpoint.setEnabled(enable);
                        ++i;
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        };
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.busyCursorWhile(runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.breakpoint_view_context";
    }

    public void dispose() {
        IAction action;
        this.disposeAction("org.eclipse.ui.edit.copy");
        this.disposeAction("org.eclipse.ui.edit.paste");
        this.disposeAction(ACTION_REMOVE_FROM_GROUP);
        if (this.getCheckboxViewer() != null) {
            this.getCheckboxViewer().removeCheckStateListener(this.fCheckListener);
        }
        if ((action = this.getAction("ShowBreakpointsForModel")) != null) {
            ((ShowSupportedBreakpointsAction)action).dispose();
        }
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        super.dispose();
        if (this.getEventHandler() != null) {
            this.getEventHandler().dispose();
        }
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
        }
        this.getSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
    }

    protected void createActions() {
        OpenBreakpointMarkerAction action = new OpenBreakpointMarkerAction((ISelectionProvider)this.getViewer());
        this.setAction("GotoMarker", (IAction)action);
        this.setAction("Double_Click_ActionId", (IAction)action);
        this.setAction("ShowBreakpointsForModel", (IAction)new ShowSupportedBreakpointsAction(this.getStructuredViewer(), this));
        this.setAction("SkipBreakpoints", (IAction)new SkipAllBreakpointsAction((IWorkbenchPart)this));
        this.fClipboard = new Clipboard(this.getSite().getShell().getDisplay());
        PasteBreakpointsAction paste = new PasteBreakpointsAction(this);
        this.configure(paste, ActionFactory.PASTE.getCommandId(), ActionFactory.PASTE.getId(), "IMG_TOOL_PASTE");
        CopyBreakpointsAction copy = new CopyBreakpointsAction(this, this.fClipboard, paste);
        this.configure(copy, ActionFactory.COPY.getCommandId(), ActionFactory.COPY.getId(), "IMG_TOOL_COPY");
        RemoveFromWorkingSetAction remove = new RemoveFromWorkingSetAction(this);
        this.setAction(ACTION_REMOVE_FROM_GROUP, (IAction)remove);
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)remove);
    }

    private void configure(SelectionListenerAction action, String defId, String globalId, String imgId) {
        this.setAction(defId, (IAction)action);
        action.setActionDefinitionId(defId);
        this.getViewSite().getActionBars().setGlobalActionHandler(globalId, (IAction)action);
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)action);
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imgId));
    }

    private void disposeAction(String id) {
        IAction action = this.getAction(id);
        if (action instanceof SelectionListenerAction) {
            SelectionListenerAction sla = (SelectionListenerAction)action;
            if (this.getViewer() != null) {
                this.getViewer().removeSelectionChangedListener((ISelectionChangedListener)sla);
            }
        }
    }

    protected void fillContextMenu(IMenuManager menu) {
        this.updateObjects();
        menu.add((IContributionItem)new Separator("emptyNavigationGroup"));
        menu.add((IContributionItem)new Separator("navigationGroup"));
        menu.add(this.getAction("GotoMarker"));
        menu.add((IContributionItem)new Separator("emptyBreakpointGroup"));
        menu.add((IContributionItem)new Separator("breakpointGroup"));
        menu.add(this.getAction("org.eclipse.ui.edit.copy"));
        menu.add(this.getAction("org.eclipse.ui.edit.paste"));
        IAction action = this.getAction(ACTION_REMOVE_FROM_GROUP);
        if (action.isEnabled()) {
            menu.add(action);
        }
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("breakpointGroupGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("breakpointGroup"));
        tbm.add(this.getAction("ShowBreakpointsForModel"));
        tbm.add(this.getAction("GotoMarker"));
        tbm.add(this.getAction("SkipBreakpoints"));
        tbm.add((IContributionItem)new Separator("renderGroup"));
    }

    protected BreakpointsViewEventHandler getEventHandler() {
        return this.fEventHandler;
    }

    private void setEventHandler(BreakpointsViewEventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    protected void becomesVisible() {
        super.becomesVisible();
        CheckboxTreeViewer viewer = this.getCheckboxViewer();
        ISelection selection = viewer.getSelection();
        viewer.getControl().setRedraw(false);
        ((BreakpointsContentProvider)viewer.getContentProvider()).reorganize();
        viewer.setSelection((ISelection)new StructuredSelection((Object)selection));
        viewer.getControl().setRedraw(true);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        if (sel.isEmpty() || !this.isTrackingSelection()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        Iterator iter = selection.iterator();
        Object firstElement = iter.next();
        if (firstElement == null || iter.hasNext()) {
            return;
        }
        IThread thread = null;
        if (firstElement instanceof IStackFrame) {
            thread = ((IStackFrame)firstElement).getThread();
        } else if (firstElement instanceof IThread) {
            thread = (IThread)firstElement;
        } else {
            return;
        }
        Object[] breakpoints = thread.getBreakpoints();
        this.getViewer().setSelection((ISelection)new StructuredSelection(breakpoints), true);
    }

    public boolean isTrackingSelection() {
        return this.fIsTrackingSelection;
    }

    public void setTrackSelection(boolean trackSelection) {
        this.fIsTrackingSelection = trackSelection;
        if (trackSelection) {
            this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        } else {
            this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        IMemento node = memento.createChild(KEY_IS_TRACKING_SELECTION);
        node.putString(KEY_VALUE, String.valueOf(this.fIsTrackingSelection));
        StringBuffer buffer = new StringBuffer();
        IBreakpointOrganizer[] organizers = this.fContentProvider.getOrganizers();
        if (organizers != null) {
            int i = 0;
            while (i < organizers.length) {
                IBreakpointOrganizer organizer = organizers[i];
                buffer.append(organizer.getIdentifier());
                if (i < organizers.length - 1) {
                    buffer.append(',');
                }
                ++i;
            }
            node = memento.createChild("breakpointOrganizers");
            node.putString(KEY_VALUE, buffer.toString());
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IAction action = BreakpointsView.this.getAction("SkipBreakpoints");
                if (action != null) {
                    ((SkipAllBreakpointsAction)action).updateActionCheckedState();
                }
            }
        });
    }

    public void doubleClick(DoubleClickEvent event) {
        Object element;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof BreakpointContainer) {
            this.getCheckboxViewer().setExpandedState(element, !this.getCheckboxViewer().getExpandedState(element));
            return;
        }
        super.doubleClick(event);
    }

    public void setBreakpointOrganizers(IBreakpointOrganizer[] organizers) {
        Viewer viewer = this.getViewer();
        ISelection selection = viewer.getSelection();
        this.fContentProvider.setOrganizers(organizers);
        viewer.setSelection(selection);
    }

    public IBreakpointOrganizer[] getBreakpointOrganizers() {
        return this.fContentProvider.getOrganizers();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        String id;
        if (partRef instanceof IViewReference && changeId.equals("viewHide") && (id = ((IViewReference)partRef).getId()).equals(this.getViewSite().getId())) {
            fgMemento = XMLMemento.createWriteRoot((String)"BreakpointsViewMemento");
            this.saveState(fgMemento);
        }
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    public IDebugModelPresentation getPresentation(String id) {
        if (this.getViewer() instanceof StructuredViewer) {
            Object lp = ((StructuredViewer)this.getViewer()).getLabelProvider();
            if (lp instanceof BreakpointsLabelProvider) {
                BreakpointsLabelProvider blp = (BreakpointsLabelProvider)((Object)lp);
                lp = blp.getPresentation();
            }
            if (lp instanceof DelegatingModelPresentation) {
                return ((DelegatingModelPresentation)lp).getPresentation(id);
            }
            if (lp instanceof LazyModelPresentation && ((LazyModelPresentation)lp).getDebugModelIdentifier().equals(id)) {
                return (IDebugModelPresentation)lp;
            }
        }
        return null;
    }

    public void preserveSelection(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            TreeItem item = (TreeItem)((BreakpointsViewer)this.getCheckboxViewer()).searchItem(selection.getFirstElement());
            Object toselect = null;
            if (item != null) {
                TreeItem parent = item.getParentItem();
                if (parent != null) {
                    int idx = 0;
                    if (parent.getItemCount() == 1) {
                        toselect = parent.getData();
                    }
                    if ((idx = parent.indexOf(item)) == 0) {
                        toselect = parent.getItemCount() > 1 ? parent.getItem(1).getData() : parent.getItem(0).getData();
                    }
                    if (idx > 0) {
                        toselect = parent.getItem(idx - 1).getData();
                    }
                } else {
                    Tree tree = item.getParent();
                    TreeItem[] items = tree.getItems();
                    if (items.length > 1) {
                        int i = 0;
                        while (i < items.length) {
                            if (item.equals(items[i])) {
                                if (i + 1 >= items.length) {
                                    toselect = items[i - 1].getData();
                                    break;
                                }
                                toselect = items[i + 1].getData();
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
            if (toselect != null) {
                this.getViewer().setSelection((ISelection)new StructuredSelection(toselect), true);
            }
        }
    }

    public boolean canPaste(Object target, ISelection selection) {
        if (!(target instanceof BreakpointContainer)) {
            return false;
        }
        if (selection.isEmpty()) {
            return false;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        BreakpointContainer container = (BreakpointContainer)((Object)target);
        IBreakpoint breakpoint = null;
        Object element = null;
        Iterator iter = ss.iterator();
        while (iter.hasNext()) {
            element = iter.next();
            if (!(element instanceof IBreakpoint)) {
                return false;
            }
            breakpoint = element;
            if (!container.contains(breakpoint) && container.getOrganizer().canAdd(breakpoint, container.getCategory())) continue;
            return false;
        }
        return true;
    }

    public boolean performPaste(Object target, ISelection selection) {
        if (target instanceof BreakpointContainer && selection instanceof IStructuredSelection) {
            BreakpointContainer container = (BreakpointContainer)((Object)target);
            Object[] objects = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (i < objects.length) {
                container.getOrganizer().addBreakpoint((IBreakpoint)objects[i], container.getCategory());
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isShowingGroups() {
        return this.fContentProvider.isShowingGroups();
    }

    public void partActivated(IWorkbenchPart part) {
        if (part.equals(this)) {
            IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.contexts.IContextService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IContextService contextService = (IContextService)iWorkbenchPartSite.getService((Class)clazz);
            this.fActivatedContext = contextService.activateContext("org.eclipse.debug.ui.BreakpointView");
        }
        super.partActivated(part);
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (part.equals(this)) {
            IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.contexts.IContextService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IContextService contextService = (IContextService)iWorkbenchPartSite.getService((Class)clazz);
            contextService.deactivateContext(this.fActivatedContext);
        }
        super.partDeactivated(part);
    }

    static /* synthetic */ ICheckStateListener access$2(BreakpointsView breakpointsView) {
        return breakpointsView.fCheckListener;
    }
}

