/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.policy.definitions.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.configuration.ConfigurationConsumer;
import org.eclipse.swordfish.core.resolver.policy.PolicyDefinitionDescription;
import org.eclipse.swordfish.core.resolver.policy.PolicyDefinitionProvider;
import org.eclipse.swordfish.internal.resolver.policy.definitions.WsPolicyStreamDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesystemPolicyDefinitionProvider
implements PolicyDefinitionProvider,
ConfigurationConsumer<String> {
    private static final Log LOG = LogFactory.getLog(FilesystemPolicyDefinitionProvider.class);
    private static final String POLICY_STORAGE_PROPERTY = "policyStorage";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int PRIORITY = 5;
    private URL policyStorage;
    private final Map<String, List<String>> directory = new HashMap<String, List<String>>();
    private final Map<String, byte[]> policies = new HashMap<String, byte[]>();

    public Collection<PolicyDefinitionDescription> getPolicyDefinitions(QName serviceProviderName) {
        String key = serviceProviderName.toString();
        List<String> values = this.directory.get(key);
        if (values == null) {
            return FilesystemPolicyDefinitionProvider.emptyList();
        }
        LinkedList<PolicyDefinitionDescription> result = new LinkedList<PolicyDefinitionDescription>();
        for (String value : values) {
            byte[] b = this.policies.get(value);
            if (b == null) continue;
            WsPolicyStreamDefinition d = new WsPolicyStreamDefinition(serviceProviderName, b);
            result.add((PolicyDefinitionDescription)d);
        }
        return result;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public void onReceiveConfiguration(Map<String, String> configuration) {
        if (configuration == null || !configuration.containsKey(POLICY_STORAGE_PROPERTY)) {
            LOG.error((Object)"Invalid configuration for FilesystemPolicyDefinitionProvider. ");
            throw new SwordfishException("Invalid configuration for FilesystemPolicyDefinitionProvider. ");
        }
        try {
            this.policyStorage = new URL(configuration.get(POLICY_STORAGE_PROPERTY));
        }
        catch (MalformedURLException malformedURLException) {
            LOG.error((Object)"Bad policy storage property value. ");
            throw new SwordfishException("Bad policy storage property value. ");
        }
        String urlName = this.policyStorage.toString();
        if (!urlName.endsWith(".zip") && !urlName.endsWith(".jar")) {
            throw new SwordfishException("Currently only policy storage in ZIP files supported. ");
        }
        try {
            InputStream is = this.policyStorage.openStream();
            try {
                ZipInputStream in = new ZipInputStream(is);
                this.readOut(in);
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new SwordfishException("Policy storage read error. ", (Throwable)e);
        }
    }

    public int getPriority() {
        return 5;
    }

    private void readOut(ZipInputStream in) throws IOException {
        Properties dirProps = null;
        ZipEntry e = in.getNextEntry();
        while (e != null) {
            String n;
            if (!(e.isDirectory() || (n = e.getName()).startsWith("_") || n.startsWith("."))) {
                if (n.endsWith("policies.dir")) {
                    dirProps = new Properties();
                    dirProps.load(in);
                } else {
                    byte[] bytes = FilesystemPolicyDefinitionProvider.streamToByteArray(in);
                    this.policies.put(n, bytes);
                }
            }
            e = in.getNextEntry();
        }
        if (dirProps == null) {
            throw new SwordfishException("Directory file policies.dir missing in archive. ");
        }
        for (String fname : this.policies.keySet()) {
            String pname = dirProps.getProperty(fname);
            if (pname == null) continue;
            List<String> fnames = this.directory.get(pname);
            if (fnames == null) {
                fnames = new LinkedList<String>();
                this.directory.put(pname, fnames);
            }
            fnames.add(fname);
        }
    }

    private static byte[] streamToByteArray(InputStream is) throws IOException {
        int bytesRead;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((bytesRead = is.read(buffer, 0, 4096)) != -1) {
            bos.write(buffer, 0, bytesRead);
        }
        return bos.toByteArray();
    }

    private static List<PolicyDefinitionDescription> emptyList() {
        return Collections.EMPTY_LIST;
    }
}

