/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.policy.processor;

import java.util.List;
import org.apache.neethi.Policy;
import org.eclipse.swordfish.core.resolver.policy.PolicyDescription;
import org.eclipse.swordfish.core.resolver.policy.PolicyProcessor;
import org.eclipse.swordfish.core.resolver.policy.PolicyRole;
import org.eclipse.swordfish.core.resolver.policy.PolicyStatus;
import org.eclipse.swordfish.internal.resolver.policy.processor.WsPolicyDescription;
import org.eclipse.swordfish.internal.resolver.policy.trading.PolicyIntersector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsPolicyProcessor
implements PolicyProcessor<Policy> {
    private PolicyIntersector policyIntersector;

    public Class<Policy> getPlatformPolicyClass() {
        return Policy.class;
    }

    public PolicyDescription<Policy> tradeAgreedPolicy(PolicyDescription<?> consumerPolicy, List<PolicyDescription<?>> providerPolicies) {
        PolicyDescription<Policy> cpd = WsPolicyProcessor.asCheckedPD(consumerPolicy);
        for (PolicyDescription<?> providerPolicy : providerPolicies) {
            PolicyDescription<Policy> ppd = WsPolicyProcessor.asCheckedPD(providerPolicy);
            PolicyDescription<Policy> result = this.doTradeAgreedPolicy(cpd, ppd);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public PolicyDescription<Policy> tradeAgreedPolicy(PolicyDescription<?> consumerPolicy, PolicyDescription<?> ... providerPolicies) {
        PolicyDescription<Policy> cpd = WsPolicyProcessor.asCheckedPD(consumerPolicy);
        int i = 0;
        while (i < providerPolicies.length) {
            PolicyDescription<Policy> ppd = WsPolicyProcessor.asCheckedPD(providerPolicies[i]);
            PolicyDescription<Policy> result = this.doTradeAgreedPolicy(cpd, ppd);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public PolicyDescription<Policy> tradeAgreedPolicy(PolicyDescription<?> consumerPolicy, PolicyDescription<?> providerPolicy) {
        PolicyDescription<Policy> cpd = WsPolicyProcessor.asCheckedPD(consumerPolicy);
        PolicyDescription<Policy> ppd = WsPolicyProcessor.asCheckedPD(providerPolicy);
        return this.doTradeAgreedPolicy(cpd, ppd);
    }

    public PolicyIntersector getPolicyIntersector() {
        return this.policyIntersector;
    }

    public void setPolicyIntersector(PolicyIntersector policyIntersector) {
        this.policyIntersector = policyIntersector;
    }

    private PolicyDescription<Policy> doTradeAgreedPolicy(PolicyDescription<Policy> consumerPolicy, PolicyDescription<Policy> providerPolicy) {
        Policy agreed = this.policyIntersector.intersect((Policy)consumerPolicy.getPolicy(), (Policy)providerPolicy.getPolicy());
        if (agreed == null) {
            return null;
        }
        WsPolicyDescription result = new WsPolicyDescription();
        result.setPolicy(agreed);
        result.setPolicyRole(PolicyRole.AGREED_POLICY);
        result.setPolicyStatus(PolicyStatus.UNKNOWN);
        return result;
    }

    private static PolicyDescription<Policy> asCheckedPD(PolicyDescription<?> pd) {
        if (pd.getPolicy() instanceof Policy) {
            return pd;
        }
        throw new ClassCastException("Incompatible PolicyDescription. ");
    }
}

