/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.exporter.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.service.dependency.DependentServiceExporter;

public abstract class AbstractDependentServiceExporter
implements DependentServiceExporter,
InitializingBean {
    private static final Log log = LogFactory.getLog((Class)AbstractDependentServiceExporter.class);
    private boolean publishAtStartup = true;
    private final Object monitor = new Object();
    private boolean running = false;
    private boolean initialized = false;

    protected boolean shouldPublishAtStartup() {
        return this.publishAtStartup;
    }

    public void setPublishAtStartup(boolean publish) {
        this.publishAtStartup = publish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Object object = this.monitor;
        synchronized (object) {
            this.initialized = true;
            if (this.publishAtStartup) {
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.monitor;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.running) {
                if (this.initialized) {
                    this.running = true;
                    this.registerService();
                } else {
                    this.publishAtStartup = true;
                }
            }
        }
        if (!this.initialized) {
            log.trace((Object)"exporter not initialized, service not exported but registered for publication at startup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.running) {
                if (this.initialized) {
                    this.running = false;
                    this.unregisterService();
                } else {
                    this.publishAtStartup = false;
                }
            }
        }
    }

    abstract void registerService();

    abstract void unregisterService();
}

