/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.util.ViewerPane;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class OverrideMethodDialog
extends SourceActionDialog {
    private CompilationUnit fUnit = null;

    private static ITypeBinding getSuperType(ITypeBinding binding, String name) {
        ITypeBinding result;
        if (binding.isArray() || binding.isPrimitive()) {
            return null;
        }
        if (binding.getQualifiedName().startsWith(name)) {
            return binding;
        }
        ITypeBinding type = binding.getSuperclass();
        if (type != null && (result = OverrideMethodDialog.getSuperType(type, name)) != null) {
            return result;
        }
        ITypeBinding[] types = binding.getInterfaces();
        int index = 0;
        while (index < types.length) {
            ITypeBinding result2 = OverrideMethodDialog.getSuperType(types[index], name);
            if (result2 != null) {
                return result2;
            }
            ++index;
        }
        return null;
    }

    public OverrideMethodDialog(Shell shell, CompilationUnitEditor editor, IType type, boolean isSubType) throws JavaModelException {
        super(shell, (ILabelProvider)new BindingLabelProvider(), new OverrideMethodContentProvider(), editor, type, false);
        ITypeBinding cloneable;
        IMethodBinding[] methods;
        RefactoringASTParser parser = new RefactoringASTParser(3);
        this.fUnit = parser.parse((ITypeRoot)type.getCompilationUnit(), true);
        ITypeBinding binding = ASTNodes.getTypeBinding(this.fUnit, type);
        ArrayList<IMethodBinding> toImplement = new ArrayList<IMethodBinding>();
        IMethodBinding[] overridable = null;
        if (binding != null) {
            IPackageBinding pack = binding.getPackage();
            methods = StubUtility2.getOverridableMethods(this.fUnit.getAST(), binding, false);
            ArrayList<IMethodBinding> list = new ArrayList<IMethodBinding>(methods.length);
            int index = 0;
            while (index < methods.length) {
                IMethodBinding cur = methods[index];
                if (Bindings.isVisibleInHierarchy(cur, pack)) {
                    list.add(cur);
                }
                ++index;
            }
            overridable = list.toArray(new IMethodBinding[list.size()]);
        } else {
            overridable = new IMethodBinding[]{};
        }
        int i = 0;
        while (i < overridable.length) {
            if (Modifier.isAbstract((int)overridable[i].getModifiers())) {
                toImplement.add(overridable[i]);
            }
            ++i;
        }
        if (binding != null && (cloneable = OverrideMethodDialog.getSuperType(binding, "java.lang.Cloneable")) != null) {
            methods = this.fUnit.getAST().resolveWellKnownType("java.lang.Object").getDeclaredMethods();
            int index = 0;
            while (index < methods.length) {
                IMethodBinding method = methods[index];
                if (method.getName().equals("clone") && method.getParameterTypes().length == 0) {
                    toImplement.add(method);
                }
                ++index;
            }
        }
        Object[] toImplementArray = toImplement.toArray(new IMethodBinding[toImplement.size()]);
        this.setInitialSelections(toImplementArray);
        HashSet<Object> expanded = new HashSet<Object>(toImplementArray.length);
        int i2 = 0;
        while (i2 < toImplementArray.length) {
            expanded.add(toImplementArray[i2].getDeclaringClass());
            ++i2;
        }
        HashSet<ITypeBinding> types = new HashSet<ITypeBinding>(overridable.length);
        int i3 = 0;
        while (i3 < overridable.length) {
            types.add(overridable[i3].getDeclaringClass());
            ++i3;
        }
        Object[] typesArrays = types.toArray(new ITypeBinding[types.size()]);
        OverrideMethodComparator comparator = new OverrideMethodComparator(binding);
        if (expanded.isEmpty() && typesArrays.length > 0) {
            comparator.sort(null, typesArrays);
            expanded.add(typesArrays[0]);
        }
        this.setExpandedElements(expanded.toArray());
        ((OverrideMethodContentProvider)this.getContentProvider()).init(overridable, (ITypeBinding[])typesArrays);
        this.setTitle(JavaUIMessages.OverrideMethodDialog_dialog_title);
        this.setMessage(null);
        this.setValidator(new OverrideMethodValidator(overridable.length));
        this.setComparator(comparator);
        this.setContainerMode(true);
        this.setSize(60, 18);
        this.setInput(new Object());
    }

    public CompilationUnit getCompilationUnit() {
        return this.fUnit;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.override_tree_selection_dialog_context");
    }

    protected Control createLinkControl(Composite composite) {
        Link link = new Link(composite, 64);
        link.setText(JavaUIMessages.OverrideMethodDialog_link_message);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverrideMethodDialog.this.openCodeTempatePage("org.eclipse.jdt.ui.text.codetemplates.overridecomment");
            }
        });
        link.setToolTipText(JavaUIMessages.OverrideMethodDialog_link_tooltip);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        link.setLayoutData((Object)gridData);
        return link;
    }

    protected CheckboxTreeViewer createTreeViewer(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        ViewerPane pane = new ViewerPane(composite, 0x800800);
        pane.setText(JavaUIMessages.OverrideMethodDialog_dialog_description);
        CheckboxTreeViewer treeViewer = super.createTreeViewer((Composite)pane);
        pane.setContent(treeViewer.getControl());
        GridLayout paneLayout = new GridLayout();
        paneLayout.marginHeight = 0;
        paneLayout.marginWidth = 0;
        paneLayout.numColumns = 1;
        pane.setLayout((Layout)paneLayout);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        pane.setLayoutData(gd);
        ToolBarManager manager = pane.getToolBarManager();
        manager.add((IAction)new OverrideFlatTreeAction());
        manager.update(true);
        treeViewer.getTree().setFocus();
        return treeViewer;
    }

    public boolean hasMethodsToOverride() {
        return this.getContentProvider().getElements(null).length > 0;
    }

    private class OverrideFlatTreeAction
    extends Action {
        private boolean fToggle;

        public OverrideFlatTreeAction() {
            this.setToolTipText(JavaUIMessages.OverrideMethodDialog_groupMethodsByTypes);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "impl_co.gif");
            this.fToggle = this.getOverrideContentProvider().isShowTypes();
            this.setChecked(this.fToggle);
        }

        private OverrideMethodContentProvider getOverrideContentProvider() {
            return (OverrideMethodContentProvider)OverrideMethodDialog.this.getContentProvider();
        }

        public void run() {
            Object[] elementList = this.getOverrideContentProvider().getViewer().getCheckedElements();
            this.fToggle = !this.fToggle;
            this.setChecked(this.fToggle);
            this.getOverrideContentProvider().setShowTypes(this.fToggle);
            this.getOverrideContentProvider().getViewer().setCheckedElements(elementList);
        }
    }

    private static class OverrideMethodComparator
    extends ViewerComparator {
        private ITypeBinding[] fAllTypes = new ITypeBinding[0];

        public OverrideMethodComparator(ITypeBinding curr) {
            if (curr != null) {
                ITypeBinding[] superTypes = Bindings.getAllSuperTypes(curr);
                this.fAllTypes = new ITypeBinding[superTypes.length + 1];
                this.fAllTypes[0] = curr;
                System.arraycopy(superTypes, 0, this.fAllTypes, 1, superTypes.length);
            }
        }

        public int compare(Viewer viewer, Object first, Object second) {
            if (first instanceof ITypeBinding && second instanceof ITypeBinding) {
                ITypeBinding left = (ITypeBinding)first;
                ITypeBinding right = (ITypeBinding)second;
                if (right.getQualifiedName().equals("java.lang.Object")) {
                    return -1;
                }
                if (left.isEqualTo((IBinding)right)) {
                    return 0;
                }
                if (Bindings.isSuperType(left, right)) {
                    return 1;
                }
                if (Bindings.isSuperType(right, left)) {
                    return -1;
                }
                return 0;
            }
            return super.compare(viewer, first, second);
        }
    }

    private static class OverrideMethodContentProvider
    implements ITreeContentProvider {
        private final Object[] fEmpty = new Object[0];
        private IMethodBinding[] fMethods;
        private IDialogSettings fSettings;
        private boolean fShowTypes;
        private Object[] fTypes;
        private ContainerCheckedTreeViewer fViewer;
        private final String SETTINGS_SECTION = "OverrideMethodDialog";
        private final String SETTINGS_SHOWTYPES = "showtypes";

        public OverrideMethodContentProvider() {
            IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
            this.fSettings = dialogSettings.getSection("OverrideMethodDialog");
            if (this.fSettings == null) {
                this.fSettings = dialogSettings.addNewSection("OverrideMethodDialog");
                this.fSettings.put("showtypes", true);
            }
            this.fShowTypes = this.fSettings.getBoolean("showtypes");
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ITypeBinding) {
                ArrayList<IMethodBinding> result = new ArrayList<IMethodBinding>(this.fMethods.length);
                int index = 0;
                while (index < this.fMethods.length) {
                    if (this.fMethods[index].getDeclaringClass().isEqualTo((IBinding)parentElement)) {
                        result.add(this.fMethods[index]);
                    }
                    ++index;
                }
                return result.toArray();
            }
            return this.fEmpty;
        }

        public Object[] getElements(Object inputElement) {
            return this.fShowTypes ? this.fTypes : this.fMethods;
        }

        public Object getParent(Object element) {
            if (element instanceof IMethodBinding) {
                return ((IMethodBinding)element).getDeclaringClass();
            }
            return null;
        }

        public ContainerCheckedTreeViewer getViewer() {
            return this.fViewer;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void init(IMethodBinding[] methods, ITypeBinding[] types) {
            this.fMethods = methods;
            this.fTypes = types;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fViewer = (ContainerCheckedTreeViewer)viewer;
        }

        public boolean isShowTypes() {
            return this.fShowTypes;
        }

        public void setShowTypes(boolean showTypes) {
            if (this.fShowTypes != showTypes) {
                this.fShowTypes = showTypes;
                this.fSettings.put("showtypes", showTypes);
                if (this.fViewer != null) {
                    this.fViewer.refresh();
                }
            }
        }
    }

    private static class OverrideMethodValidator
    implements ISelectionStatusValidator {
        private static int fNumMethods;

        public OverrideMethodValidator(int entries) {
            fNumMethods = entries;
        }

        public IStatus validate(Object[] selection) {
            int count = 0;
            int index = 0;
            while (index < selection.length) {
                if (selection[index] instanceof IMethodBinding) {
                    ++count;
                }
                ++index;
            }
            if (count == 0) {
                return new StatusInfo(4, "");
            }
            return new StatusInfo(1, Messages.format(JavaUIMessages.OverrideMethodDialog_selectioninfo_more, new String[]{String.valueOf(count), String.valueOf(fNumMethods)}));
        }
    }
}

