/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaElementImplementationHyperlink
implements IHyperlink {
    private final IRegion fRegion;
    private final SelectionDispatchAction fOpenAction;
    private final IJavaElement fElement;
    private final boolean fQualify;
    private ITextEditor fEditor;
    static /* synthetic */ Class class$0;

    public JavaElementImplementationHyperlink(IRegion region, SelectionDispatchAction openAction, IJavaElement element, boolean qualify, ITextEditor editor) {
        Assert.isNotNull((Object)((Object)openAction));
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)element);
        this.fRegion = region;
        this.fOpenAction = openAction;
        this.fElement = element;
        this.fQualify = qualify;
        this.fEditor = editor;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getHyperlinkText() {
        if (this.fQualify) {
            String elementLabel = JavaElementLabels.getElementLabel(this.fElement, JavaElementLabels.ALL_FULLY_QUALIFIED);
            return Messages.format(JavaEditorMessages.JavaElementImplementationHyperlink_hyperlinkText_qualified, new Object[]{elementLabel});
        }
        return JavaEditorMessages.JavaElementImplementationHyperlink_hyperlinkText;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        ArrayList links;
        block12: {
            IType type;
            ITypeRoot editorInput = EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false);
            CompilationUnit ast = SharedASTProvider.getAST(editorInput, SharedASTProvider.WAIT_ACTIVE_ONLY, null);
            if (ast == null) {
                this.openQuickHierarchy();
                return;
            }
            ASTNode node = NodeFinder.perform((ASTNode)ast, (int)this.fRegion.getOffset(), (int)this.fRegion.getLength());
            ITypeBinding parentTypeBinding = null;
            if (node instanceof SimpleName) {
                ASTNode parent = node.getParent();
                if (parent instanceof MethodInvocation) {
                    Expression expression = ((MethodInvocation)parent).getExpression();
                    parentTypeBinding = expression == null ? Bindings.getBindingOfParentType(node) : expression.resolveTypeBinding();
                } else {
                    if (parent instanceof SuperMethodInvocation) {
                        this.fOpenAction.run((IStructuredSelection)new StructuredSelection((Object)this.fElement));
                        return;
                    }
                    if (parent instanceof MethodDeclaration) {
                        parentTypeBinding = Bindings.getBindingOfParentType(node);
                    }
                }
            }
            IType iType = type = parentTypeBinding != null ? (IType)parentTypeBinding.getJavaElement() : null;
            if (type == null) {
                this.openQuickHierarchy();
                return;
            }
            final String dummyString = new String();
            links = new ArrayList();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    try {
                        try {
                            String methodLabel = JavaElementLabels.getElementLabel(JavaElementImplementationHyperlink.this.fElement, JavaElementLabels.DEFAULT_QUALIFIED);
                            monitor.beginTask(Messages.format(JavaEditorMessages.JavaElementImplementationHyperlink_search_method_implementors, methodLabel), 100);
                            SearchRequestor requestor = new SearchRequestor(this, links, dummyString){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ ArrayList val$links;
                                private final /* synthetic */ String val$dummyString;
                                {
                                    this.this$1 = var1_1;
                                    this.val$links = arrayList;
                                    this.val$dummyString = string;
                                }

                                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                                    IJavaElement element;
                                    if (match.getAccuracy() == 0 && (element = (IJavaElement)match.getElement()) instanceof IMethod && !JdtFlags.isAbstract((IMember)((IMethod)element))) {
                                        this.val$links.add(element);
                                        if (this.val$links.size() > 1) {
                                            throw new OperationCanceledException(this.val$dummyString);
                                        }
                                    }
                                }
                            };
                            int limitTo = 48;
                            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)JavaElementImplementationHyperlink.this.fElement, (int)limitTo);
                            Assert.isNotNull((Object)pattern);
                            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
                            SearchEngine engine = new SearchEngine();
                            engine.search(pattern, participants, SearchEngine.createHierarchyScope((IType)type), requestor, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                IWorkbenchWindow context = this.fEditor.getSite().getWorkbenchWindow();
                context.run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                Status status = new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(JavaEditorMessages.JavaElementImplementationHyperlink_error_status_message, this.fElement.getElementName()), e.getCause());
                JavaPlugin.log((IStatus)status);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)JavaEditorMessages.JavaElementImplementationHyperlink_hyperlinkText, (String)JavaEditorMessages.JavaElementImplementationHyperlink_error_no_implementations_found_message, (IStatus)status);
            }
            catch (InterruptedException e) {
                if (e.getMessage() == dummyString) break block12;
                return;
            }
        }
        if (links.size() == 1) {
            this.fOpenAction.run((IStructuredSelection)new StructuredSelection(links.get(0)));
        } else {
            this.openQuickHierarchy();
        }
    }

    private void openQuickHierarchy() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITextOperationTarget textOperationTarget = (ITextOperationTarget)this.fEditor.getAdapter((Class)clazz);
        textOperationTarget.doOperation(53);
    }
}

