/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.NativeLibrariesConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class NativeLibrariesPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    private NativeLibrariesConfigurationBlock fConfigurationBlock;
    private boolean fIsValidElement;
    private IClasspathEntry fEntry;
    private IPath fContainerPath;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createControl(Composite parent) {
        IJavaElement elem = this.getJavaElement();
        try {
            if (elem instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)elem;
                IClasspathEntry entry = root.getRawClasspathEntry();
                if (entry == null) {
                    this.fIsValidElement = false;
                    this.setDescription(PreferencesMessages.NativeLibrariesPropertyPage_invalidElementSelection_desription);
                } else if (entry.getEntryKind() == 5) {
                    this.fContainerPath = entry.getPath();
                    this.fEntry = this.handleContainerEntry(this.fContainerPath, elem.getJavaProject(), root.getPath());
                    this.fIsValidElement = this.fEntry != null;
                } else {
                    this.fContainerPath = null;
                    this.fEntry = entry;
                    this.fIsValidElement = true;
                }
            } else {
                this.fIsValidElement = false;
                this.setDescription(PreferencesMessages.NativeLibrariesPropertyPage_invalidElementSelection_desription);
            }
        }
        catch (JavaModelException javaModelException) {
            this.fIsValidElement = false;
            this.setDescription(PreferencesMessages.NativeLibrariesPropertyPage_invalidElementSelection_desription);
        }
        super.createControl(parent);
    }

    private IClasspathEntry handleContainerEntry(IPath containerPath, IJavaProject jproject, IPath jarPath) throws JavaModelException {
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
        if (initializer == null || container == null) {
            this.setDescription(Messages.format(PreferencesMessages.NativeLibrariesPropertyPage_invalid_container, BasicElementLabels.getPathLabel(containerPath, false)));
            return null;
        }
        String containerName = container.getDescription();
        IStatus status = initializer.getAttributeStatus(containerPath, jproject, JavaRuntime.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY);
        if (status.getCode() == 1) {
            this.setDescription(Messages.format(PreferencesMessages.NativeLibrariesPropertyPage_not_supported, containerName));
            return null;
        }
        if (status.getCode() == 2) {
            this.setDescription(Messages.format(PreferencesMessages.NativeLibrariesPropertyPage_read_only, containerName));
            return null;
        }
        IClasspathEntry entry = JavaModelUtil.findEntryInContainer(container, jarPath);
        Assert.isNotNull((Object)entry);
        return entry;
    }

    protected Control createContents(Composite parent) {
        if (!this.fIsValidElement) {
            return new Composite(parent, 0);
        }
        IJavaElement elem = this.getJavaElement();
        if (elem == null) {
            return new Composite(parent, 0);
        }
        String nativeLibPath = null;
        IClasspathAttribute[] extraAttributes = this.fEntry.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            if (extraAttributes[i].getName().equals(JavaRuntime.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY)) {
                nativeLibPath = extraAttributes[i].getValue();
                break;
            }
            ++i;
        }
        this.fConfigurationBlock = new NativeLibrariesConfigurationBlock(this, this.getShell(), nativeLibPath, this.fEntry);
        Control control = this.fConfigurationBlock.createContents(parent);
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    protected void performDefaults() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performDefaults();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fConfigurationBlock != null) {
            String nativeLibraryPath = this.fConfigurationBlock.getNativeLibraryPath();
            if (nativeLibraryPath == null) {
                return true;
            }
            IJavaElement elem = this.getJavaElement();
            try {
                IRunnableWithProgress runnable = NativeLibrariesPropertyPage.getRunnable(this.getShell(), elem, nativeLibraryPath, this.fEntry, this.fContainerPath);
                PlatformUI.getWorkbench().getProgressService().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                String title = PreferencesMessages.NativeLibrariesPropertyPage_errorAttaching_title;
                String message = PreferencesMessages.NativeLibrariesPropertyPage_errorAttaching_message;
                ExceptionHandler.handle(e, this.getShell(), title, message);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    private static IRunnableWithProgress getRunnable(final Shell shell, final IJavaElement elem, final String nativeLibraryPath, final IClasspathEntry entry, final IPath containerPath) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IJavaProject project = elem.getJavaProject();
                    if (elem instanceof IPackageFragmentRoot) {
                        CPListElement cpElem = CPListElement.createFromExisting(entry, project);
                        cpElem.setAttribute(CPListElement.NATIVE_LIB_PATH, nativeLibraryPath);
                        IClasspathEntry newEntry = cpElem.getClasspathEntry();
                        String[] changedAttributes = new String[]{CPListElement.NATIVE_LIB_PATH};
                        BuildPathSupport.modifyClasspathEntry(shell, newEntry, changedAttributes, project, containerPath, monitor);
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    private IJavaElement getJavaElement() {
        IJavaElement elem;
        IAdaptable adaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((elem = (IJavaElement)adaptable.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IResource resource = (IResource)adaptable.getAdapter((Class)clazz2);
            try {
                IProject proj;
                if (resource instanceof IFile && ArchiveFileFilter.isArchivePath(resource.getFullPath(), false) && (proj = resource.getProject()).hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject jproject = JavaCore.create((IProject)proj);
                    elem = jproject.getPackageFragmentRoot(resource);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return elem;
    }
}

