/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MatchLocations {
    public static String getMatchLocationDescription(int locations, int entryLimit) {
        int nOptions = MatchLocations.getNumberOfSelectedSettings(locations, entryLimit);
        if (nOptions > entryLimit) {
            return SearchMessages.MatchLocations_match_locations_description;
        }
        ArrayList<String> args = new ArrayList<String>(3);
        if (MatchLocations.isSet(locations, 512)) {
            args.add(SearchMessages.MatchLocations_super_types_description);
        }
        if (MatchLocations.isSet(locations, 65536)) {
            args.add(SearchMessages.MatchLocations_annotations_description);
        }
        if (MatchLocations.isSet(locations, 64)) {
            args.add(SearchMessages.MatchLocations_field_types_description);
        }
        if (MatchLocations.isSet(locations, 128)) {
            args.add(SearchMessages.MatchLocations_local_types_description);
        }
        if (MatchLocations.isSet(locations, 16384)) {
            args.add(SearchMessages.MatchLocations_method_types_description);
        }
        if (MatchLocations.isSet(locations, 256)) {
            args.add(SearchMessages.MatchLocations_parameter_types_description);
        }
        if (MatchLocations.isSet(locations, 1024)) {
            args.add(SearchMessages.MatchLocations_thrown_exceptions_description);
        }
        if (MatchLocations.isSet(locations, 262144)) {
            args.add(SearchMessages.MatchLocations_type_parameter_bounds_description);
        }
        if (MatchLocations.isSet(locations, 524288)) {
            args.add(SearchMessages.MatchLocations_wildcard_bounds_description);
        }
        if (MatchLocations.isSet(locations, 0x100000)) {
            args.add(SearchMessages.MatchLocations_instanceof_description);
        }
        if (MatchLocations.isSet(locations, 131072)) {
            args.add(SearchMessages.MatchLocations_type_arguments_description);
        }
        if (MatchLocations.isSet(locations, 2048)) {
            args.add(SearchMessages.MatchLocations_casts_description);
        }
        if (MatchLocations.isSet(locations, 4096)) {
            args.add(SearchMessages.MatchLocations_catch_clauses_description);
        }
        if (MatchLocations.isSet(locations, 8192)) {
            args.add(SearchMessages.MatchLocations_class_instance_description);
        }
        if (MatchLocations.isSet(locations, 0x1000000)) {
            args.add(SearchMessages.MatchLocations_super_description);
        }
        if (MatchLocations.isSet(locations, 0x2000000)) {
            args.add(SearchMessages.MatchLocations_qualified_description);
        }
        if (MatchLocations.isSet(locations, 0x4000000)) {
            args.add(SearchMessages.MatchLocations_this_description);
        }
        if (MatchLocations.isSet(locations, 0x8000000)) {
            args.add(SearchMessages.MatchLocations_implicit_this_description);
        }
        if (args.size() == 1) {
            return (String)args.get(0);
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < args.size()) {
            if (i > 0) {
                buf.append(JavaElementLabels.COMMA_STRING);
            }
            buf.append((String)args.get(i));
            ++i;
        }
        return buf.toString();
    }

    private static boolean isSet(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static int getTotalNumberOfSettings(int searchFor) {
        if (searchFor == 0) {
            return 14;
        }
        if (searchFor == 1 || searchFor == 4) {
            return 4;
        }
        return 0;
    }

    public static int getNumberOfSelectedSettings(int locations, int searchFor) {
        int count = 0;
        if (searchFor == 0) {
            if (MatchLocations.isSet(locations, 512)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 65536)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 64)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 128)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 16384)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 256)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 1024)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 262144)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 524288)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 0x100000)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 131072)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 2048)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 4096)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 8192)) {
                ++count;
            }
        } else if (searchFor == 1 || searchFor == 4) {
            if (MatchLocations.isSet(locations, 0x1000000)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 0x2000000)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 0x4000000)) {
                ++count;
            }
            if (MatchLocations.isSet(locations, 0x8000000)) {
                ++count;
            }
        }
        return count;
    }

    public static class MatchLocationSelectionDialog
    extends TrayDialog {
        private final ArrayList fButtons;
        private final int fSearchFor;
        private int fCurrentSelection;

        public MatchLocationSelectionDialog(Shell parent, int initialSelection, int searchFor) {
            super(parent);
            this.fSearchFor = searchFor;
            this.fButtons = new ArrayList();
            this.fCurrentSelection = initialSelection;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(SearchMessages.MatchLocations_dialog_title);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            Composite contents = (Composite)super.createDialogArea(parent);
            GridLayout layout = (GridLayout)contents.getLayout();
            layout.numColumns = 2;
            layout.makeColumnsEqualWidth = true;
            Label label = new Label(contents, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
            label.setText(SearchMessages.MatchLocations_dialog_description);
            if (this.fSearchFor == 0) {
                this.createTypeMatchLocationsControls(contents);
            } else {
                this.createMethodFieldMatchLocationsControls(contents);
            }
            Composite buttonComposite = new Composite(contents, 0);
            buttonComposite.setLayoutData((Object)new GridData(16384, 1, true, true, 2, 1));
            GridLayout blayout = new GridLayout(2, false);
            blayout.marginWidth = 0;
            blayout.marginHeight = 0;
            buttonComposite.setLayout((Layout)blayout);
            Button selectAllButton = new Button(buttonComposite, 8);
            selectAllButton.setLayoutData((Object)new GridData());
            selectAllButton.setText(SearchMessages.MatchLocations_select_all_button_label);
            selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ MatchLocationSelectionDialog this$1;
                {
                    this.this$1 = matchLocationSelectionDialog;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.this$1.performSelectAction(true);
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.performSelectAction(true);
                }
            });
            SWTUtil.setButtonDimensionHint(selectAllButton);
            Button deselectAllButton = new Button(buttonComposite, 8);
            deselectAllButton.setLayoutData((Object)new GridData());
            deselectAllButton.setText(SearchMessages.MatchLocations_deselect_all_button_label);
            deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ MatchLocationSelectionDialog this$1;
                {
                    this.this$1 = matchLocationSelectionDialog;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.this$1.performSelectAction(false);
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.performSelectAction(false);
                }
            });
            SWTUtil.setButtonDimensionHint(deselectAllButton);
            Dialog.applyDialogFont((Control)contents);
            return contents;
        }

        private void createMethodFieldMatchLocationsControls(Composite contents) {
            Composite composite = new Composite(contents, 0);
            composite.setLayoutData((Object)new GridData(16384, 1, true, true, 2, 1));
            GridLayout blayout = new GridLayout(1, false);
            blayout.marginWidth = 0;
            blayout.marginHeight = 0;
            composite.setLayout((Layout)blayout);
            this.createButton(composite, SearchMessages.MatchLocations_this_label, 0x4000000);
            this.createButton(composite, SearchMessages.MatchLocations_implicit_this_label, 0x8000000);
            this.createButton(composite, SearchMessages.MatchLocations_super_label, 0x1000000);
            this.createButton(composite, SearchMessages.MatchLocations_qualified_label, 0x2000000);
        }

        private void createTypeMatchLocationsControls(Composite contents) {
            Group group = new Group(contents, 0);
            group.setLayoutData((Object)new GridData(4, 4, true, false, 1, 2));
            group.setLayout((Layout)new GridLayout(1, false));
            group.setText(SearchMessages.MatchLocations_declaration_group_label);
            int superTypes = 512;
            this.createButton((Composite)group, SearchMessages.MatchLocations_super_types_label, superTypes);
            this.addSeparator((Composite)group);
            this.createButton((Composite)group, SearchMessages.MatchLocations_annotations_label, 65536);
            this.addSeparator((Composite)group);
            this.createButton((Composite)group, SearchMessages.MatchLocations_field_types_label, 64);
            this.createButton((Composite)group, SearchMessages.MatchLocations_local_types_label, 128);
            this.addSeparator((Composite)group);
            this.createButton((Composite)group, SearchMessages.MatchLocations_method_types_label, 16384);
            this.createButton((Composite)group, SearchMessages.MatchLocations_parameter_types_label, 256);
            this.createButton((Composite)group, SearchMessages.MatchLocations_thrown_exceptions_label, 1024);
            Group ptGroup = new Group(contents, 0);
            ptGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            ptGroup.setLayout((Layout)new GridLayout(1, false));
            ptGroup.setText(SearchMessages.MatchLocations_in_parameterized_types_group_label);
            this.createButton((Composite)ptGroup, SearchMessages.MatchLocations_type_parameter_bounds_label, 262144);
            this.createButton((Composite)ptGroup, SearchMessages.MatchLocations_wildcard_bounds_label, 524288);
            this.createButton((Composite)ptGroup, SearchMessages.MatchLocations_type_arguments_label, 131072);
            Group statementGroup = new Group(contents, 0);
            statementGroup.setLayoutData((Object)new GridData(4, 1, true, false));
            statementGroup.setLayout((Layout)new GridLayout(1, false));
            statementGroup.setText(SearchMessages.MatchLocations_expression_group_label);
            this.createButton((Composite)statementGroup, SearchMessages.MatchLocations_casts_label, 2048);
            this.createButton((Composite)statementGroup, SearchMessages.MatchLocations_catch_clauses_label, 4096);
            this.addSeparator((Composite)statementGroup);
            this.createButton((Composite)statementGroup, SearchMessages.MatchLocations_class_instance_label, 8192);
            this.createButton((Composite)statementGroup, SearchMessages.MatchLocations_instanceof_label, 0x100000);
        }

        protected final void performSelectAction(boolean selectAll) {
            int i = 0;
            while (i < this.fButtons.size()) {
                Button button = (Button)this.fButtons.get(i);
                button.setSelection(selectAll);
                ++i;
            }
            this.validateSettings();
        }

        private void addSeparator(Composite parent) {
            Label label = new Label(parent, 0);
            GridData data = new GridData();
            data.heightHint = 4;
            label.setLayoutData((Object)data);
        }

        private Button createButton(Composite parent, String text, int data) {
            boolean isSelected = (this.fCurrentSelection & data) != 0;
            Button button = new Button(parent, 32);
            button.setText(text);
            button.setData((Object)new Integer(data));
            button.setLayoutData((Object)new GridData());
            button.setSelection(isSelected);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ MatchLocationSelectionDialog this$1;
                {
                    this.this$1 = matchLocationSelectionDialog;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.this$1.performOptionChanged();
                }

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }
            });
            this.fButtons.add(button);
            return button;
        }

        private int getIntValue(Button button) {
            Integer bData = (Integer)button.getData();
            if (bData != null) {
                return bData;
            }
            return 0;
        }

        protected final void performOptionChanged() {
            this.validateSettings();
        }

        private void validateSettings() {
            int selected = 0;
            int i = 0;
            while (i < this.fButtons.size()) {
                Button button = (Button)this.fButtons.get(i);
                if (button.getSelection()) {
                    selected |= this.getIntValue(button);
                }
                ++i;
            }
            this.fCurrentSelection = selected;
            this.getButton(0).setEnabled(selected != 0);
        }

        public int getCurrentSelection() {
            return this.fCurrentSelection;
        }
    }
}

