/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StyledString;

public class JavaElementLabelComposer {
    public static final String ADDITIONAL_DELIMITERS = "<>(),?{} ";
    private static final long QUALIFIER_FLAGS = 0x1002000000000L;
    private static final StyledString.Styler QUALIFIER_STYLE = StyledString.QUALIFIER_STYLER;
    private static final StyledString.Styler COUNTER_STYLE = StyledString.COUNTER_STYLER;
    private static final StyledString.Styler DECORATIONS_STYLE = StyledString.DECORATIONS_STYLER;
    private static String fgPkgNamePattern = "";
    private static String fgPkgNamePrefix;
    private static String fgPkgNamePostfix;
    private static int fgPkgNameChars;
    private static int fgPkgNameLength;
    private final FlexibleBuffer fBuffer;

    static {
        fgPkgNameLength = -1;
    }

    private static final boolean getFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public JavaElementLabelComposer(FlexibleBuffer buffer) {
        this.fBuffer = buffer;
    }

    public JavaElementLabelComposer(StyledString buffer) {
        this(new FlexibleStyledString(buffer));
    }

    public JavaElementLabelComposer(StringBuffer buffer) {
        this(new FlexibleStringBuffer(buffer));
    }

    public void appendElementLabel(IJavaElement element, long flags) {
        int type = element.getElementType();
        IPackageFragmentRoot root = null;
        if (type != 1 && type != 2 && type != 3) {
            root = JavaModelUtil.getPackageFragmentRoot(element);
        }
        if (root != null && JavaElementLabelComposer.getFlag(flags, 0x100000000000L)) {
            this.appendPackageFragmentRootLabel(root, 0x20000000000L);
            this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
        }
        switch (type) {
            case 9: {
                this.appendMethodLabel((IMethod)element, flags);
                break;
            }
            case 8: {
                this.appendFieldLabel((IField)element, flags);
                break;
            }
            case 14: {
                this.appendLocalVariableLabel((ILocalVariable)element, flags);
                break;
            }
            case 15: {
                this.appendTypeParameterLabel((ITypeParameter)element, flags);
                break;
            }
            case 10: {
                this.appendInitializerLabel((IInitializer)element, flags);
                break;
            }
            case 7: {
                this.appendTypeLabel((IType)element, flags);
                break;
            }
            case 6: {
                this.appendClassFileLabel((IClassFile)element, flags);
                break;
            }
            case 5: {
                this.appendCompilationUnitLabel((ICompilationUnit)element, flags);
                break;
            }
            case 4: {
                this.appendPackageFragmentLabel((IPackageFragment)element, flags);
                break;
            }
            case 3: {
                this.appendPackageFragmentRootLabel((IPackageFragmentRoot)element, flags);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.appendDeclarationLabel(element, flags);
                break;
            }
            case 1: 
            case 2: {
                this.fBuffer.append(element.getElementName());
                break;
            }
            default: {
                this.fBuffer.append(element.getElementName());
            }
        }
        if (root != null && JavaElementLabelComposer.getFlag(flags, 0x80000000000L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
            this.appendPackageFragmentRootLabel(root, 0x20000000000L);
            if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public void appendMethodLabel(IMethod method, long flags) {
        try {
            String[] types;
            String resolvedSig;
            BindingKey resolvedKey = JavaElementLabelComposer.getFlag(flags, 0x1000000000000L) && method.isResolved() ? new BindingKey(method.getKey()) : null;
            String string = resolvedSig = resolvedKey != null ? resolvedKey.toSignature() : null;
            if (JavaElementLabelComposer.getFlag(flags, 4L)) {
                ITypeParameter[] typeParameters;
                if (resolvedKey != null) {
                    if (resolvedKey.isParameterizedMethod()) {
                        String[] typeArgRefs = resolvedKey.getTypeArguments();
                        if (typeArgRefs.length > 0) {
                            this.appendTypeArgumentSignaturesLabel((IJavaElement)method, typeArgRefs, flags);
                            this.fBuffer.append(' ');
                        }
                    } else {
                        String[] typeParameterSigs = Signature.getTypeParameters((String)resolvedSig);
                        if (typeParameterSigs.length > 0) {
                            this.appendTypeParameterSignaturesLabel(typeParameterSigs, flags);
                            this.fBuffer.append(' ');
                        }
                    }
                } else if (method.exists() && (typeParameters = method.getTypeParameters()).length > 0) {
                    this.appendTypeParametersLabels(typeParameters, flags);
                    this.fBuffer.append(' ');
                }
            }
            if (JavaElementLabelComposer.getFlag(flags, 64L) && method.exists() && !method.isConstructor()) {
                String returnTypeSig = resolvedSig != null ? Signature.getReturnType((String)resolvedSig) : method.getReturnType();
                this.appendTypeSignatureLabel((IJavaElement)method, returnTypeSig, flags);
                this.fBuffer.append(' ');
            }
            if (JavaElementLabelComposer.getFlag(flags, 128L)) {
                this.appendTypeLabel(method.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
                this.fBuffer.append('.');
            }
            this.fBuffer.append(this.getElementName((IJavaElement)method));
            this.fBuffer.append('(');
            if (JavaElementLabelComposer.getFlag(flags, 3L)) {
                types = null;
                int nParams = 0;
                boolean renderVarargs = false;
                if (JavaElementLabelComposer.getFlag(flags, 1L)) {
                    types = resolvedSig != null ? Signature.getParameterTypes((String)resolvedSig) : method.getParameterTypes();
                    nParams = types.length;
                    renderVarargs = method.exists() && Flags.isVarargs((int)method.getFlags());
                }
                String[] names = null;
                if (JavaElementLabelComposer.getFlag(flags, 2L) && method.exists()) {
                    names = method.getParameterNames();
                    if (types == null) {
                        nParams = names.length;
                    } else if (nParams != names.length) {
                        if (resolvedSig != null && types.length > names.length) {
                            nParams = names.length;
                            String[] typesWithoutSyntheticParams = new String[nParams];
                            System.arraycopy(types, types.length - nParams, typesWithoutSyntheticParams, 0, nParams);
                            types = typesWithoutSyntheticParams;
                        } else {
                            names = null;
                        }
                    }
                }
                int i = 0;
                while (i < nParams) {
                    if (i > 0) {
                        this.fBuffer.append(JavaElementLabels.COMMA_STRING);
                    }
                    if (types != null) {
                        String paramSig = types[i];
                        if (renderVarargs && i == nParams - 1) {
                            int newDim = Signature.getArrayCount((String)paramSig) - 1;
                            this.appendTypeSignatureLabel((IJavaElement)method, Signature.getElementType((String)paramSig), flags);
                            int k = 0;
                            while (k < newDim) {
                                this.fBuffer.append('[').append(']');
                                ++k;
                            }
                            this.fBuffer.append("...");
                        } else {
                            this.appendTypeSignatureLabel((IJavaElement)method, paramSig, flags);
                        }
                    }
                    if (names != null) {
                        if (types != null) {
                            this.fBuffer.append(' ');
                        }
                        this.fBuffer.append(names[i]);
                    }
                    ++i;
                }
            } else if (method.getParameterTypes().length > 0) {
                this.fBuffer.append("...");
            }
            this.fBuffer.append(')');
            if (JavaElementLabelComposer.getFlag(flags, 16L)) {
                if (resolvedKey != null) {
                    types = resolvedKey.getThrownExceptions();
                } else {
                    String[] stringArray = types = method.exists() ? method.getExceptionTypes() : new String[]{};
                }
                if (types.length > 0) {
                    this.fBuffer.append(" throws ");
                    int i = 0;
                    while (i < types.length) {
                        if (i > 0) {
                            this.fBuffer.append(JavaElementLabels.COMMA_STRING);
                        }
                        this.appendTypeSignatureLabel((IJavaElement)method, types[i], flags);
                        ++i;
                    }
                }
            }
            if (JavaElementLabelComposer.getFlag(flags, 8L)) {
                ITypeParameter[] typeParameters;
                int offset = this.fBuffer.length();
                if (resolvedKey != null) {
                    if (resolvedKey.isParameterizedMethod()) {
                        String[] typeArgRefs = resolvedKey.getTypeArguments();
                        if (typeArgRefs.length > 0) {
                            this.fBuffer.append(' ');
                            this.appendTypeArgumentSignaturesLabel((IJavaElement)method, typeArgRefs, flags);
                        }
                    } else {
                        String[] typeParameterSigs = Signature.getTypeParameters((String)resolvedSig);
                        if (typeParameterSigs.length > 0) {
                            this.fBuffer.append(' ');
                            this.appendTypeParameterSignaturesLabel(typeParameterSigs, flags);
                        }
                    }
                } else if (method.exists() && (typeParameters = method.getTypeParameters()).length > 0) {
                    this.fBuffer.append(' ');
                    this.appendTypeParametersLabels(typeParameters, flags);
                }
                if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L) && offset != this.fBuffer.length()) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, DECORATIONS_STYLE);
                }
            }
            if (JavaElementLabelComposer.getFlag(flags, 32L) && method.exists() && !method.isConstructor()) {
                int offset = this.fBuffer.length();
                this.fBuffer.append(JavaElementLabels.DECL_STRING);
                String returnTypeSig = resolvedSig != null ? Signature.getReturnType((String)resolvedSig) : method.getReturnType();
                this.appendTypeSignatureLabel((IJavaElement)method, returnTypeSig, flags);
                if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, DECORATIONS_STYLE);
                }
            }
            if (JavaElementLabelComposer.getFlag(flags, 0x4000000000000L) && method.exists()) {
                this.appendCategoryLabel((IMember)method, flags);
            }
            if (JavaElementLabelComposer.getFlag(flags, 256L)) {
                int offset = this.fBuffer.length();
                this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
                this.appendTypeLabel(method.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
                if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private void appendCategoryLabel(IMember member, long flags) throws JavaModelException {
        String[] categories = member.getCategories();
        if (categories.length > 0) {
            int offset = this.fBuffer.length();
            StringBuffer categoriesBuf = new StringBuffer();
            int i = 0;
            while (i < categories.length) {
                if (i > 0) {
                    categoriesBuf.append(JavaElementLabels.CATEGORY_SEPARATOR_STRING);
                }
                categoriesBuf.append(categories[i]);
                ++i;
            }
            this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
            this.fBuffer.append(Messages.format(JavaUIMessages.JavaElementLabels_category, categoriesBuf.toString()));
            if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, COUNTER_STYLE);
            }
        }
    }

    private void appendTypeParametersLabels(ITypeParameter[] typeParameters, long flags) {
        if (typeParameters.length > 0) {
            this.fBuffer.append(this.getLT());
            int i = 0;
            while (i < typeParameters.length) {
                if (i > 0) {
                    this.fBuffer.append(JavaElementLabels.COMMA_STRING);
                }
                this.fBuffer.append(this.getElementName((IJavaElement)typeParameters[i]));
                ++i;
            }
            this.fBuffer.append(this.getGT());
        }
    }

    public void appendFieldLabel(IField field, long flags) {
        try {
            int offset;
            if (JavaElementLabelComposer.getFlag(flags, 32768L) && field.exists() && !Flags.isEnum((int)field.getFlags())) {
                if (JavaElementLabelComposer.getFlag(flags, 0x1000000000000L) && field.isResolved()) {
                    this.appendTypeSignatureLabel((IJavaElement)field, new BindingKey(field.getKey()).toSignature(), flags);
                } else {
                    this.appendTypeSignatureLabel((IJavaElement)field, field.getTypeSignature(), flags);
                }
                this.fBuffer.append(' ');
            }
            if (JavaElementLabelComposer.getFlag(flags, 65536L)) {
                this.appendTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
                this.fBuffer.append('.');
            }
            this.fBuffer.append(this.getElementName((IJavaElement)field));
            if (JavaElementLabelComposer.getFlag(flags, 16384L) && field.exists() && !Flags.isEnum((int)field.getFlags())) {
                offset = this.fBuffer.length();
                this.fBuffer.append(JavaElementLabels.DECL_STRING);
                if (JavaElementLabelComposer.getFlag(flags, 0x1000000000000L) && field.isResolved()) {
                    this.appendTypeSignatureLabel((IJavaElement)field, new BindingKey(field.getKey()).toSignature(), flags);
                } else {
                    this.appendTypeSignatureLabel((IJavaElement)field, field.getTypeSignature(), flags);
                }
                if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, DECORATIONS_STYLE);
                }
            }
            if (JavaElementLabelComposer.getFlag(flags, 0x2000000000000L) && field.exists()) {
                this.appendCategoryLabel((IMember)field, flags);
            }
            if (JavaElementLabelComposer.getFlag(flags, 131072L)) {
                offset = this.fBuffer.length();
                this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
                this.appendTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
                if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    public void appendLocalVariableLabel(ILocalVariable localVariable, long flags) {
        if (JavaElementLabelComposer.getFlag(flags, 32768L)) {
            this.appendTypeSignatureLabel((IJavaElement)localVariable, localVariable.getTypeSignature(), flags);
            this.fBuffer.append(' ');
        }
        if (JavaElementLabelComposer.getFlag(flags, 65536L)) {
            this.appendElementLabel(localVariable.getParent(), 0x40081L | flags & 0x1002000000000L);
            this.fBuffer.append('.');
        }
        this.fBuffer.append(this.getElementName((IJavaElement)localVariable));
        if (JavaElementLabelComposer.getFlag(flags, 16384L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabels.DECL_STRING);
            this.appendTypeSignatureLabel((IJavaElement)localVariable, localVariable.getTypeSignature(), flags);
            if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, DECORATIONS_STYLE);
            }
        }
        if (JavaElementLabelComposer.getFlag(flags, 131072L)) {
            this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
            this.appendElementLabel(localVariable.getParent(), 0x40081L | flags & 0x1002000000000L);
        }
    }

    public void appendTypeParameterLabel(ITypeParameter typeParameter, long flags) {
        try {
            this.fBuffer.append(this.getElementName((IJavaElement)typeParameter));
            IMember declaringMember = typeParameter.getDeclaringMember();
            ITypeParameter[] params = null;
            String[] paramSigs = null;
            if (declaringMember instanceof IType) {
                IType type = (IType)declaringMember;
                params = type.getTypeParameters();
                paramSigs = type.getTypeParameterSignatures();
            } else if (declaringMember instanceof IMethod) {
                IMethod method = (IMethod)declaringMember;
                params = method.getTypeParameters();
                paramSigs = method.getTypeParameterSignatures();
            }
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    if (params[i].equals(typeParameter)) {
                        String paramSig;
                        String[] bounds;
                        if (paramSigs.length <= i || (bounds = Signature.getTypeParameterBounds((String)(paramSig = paramSigs[i]))).length <= 0) break;
                        if (bounds.length != 1 || !"Ljava.lang.Object;".equals(bounds[0])) {
                            this.fBuffer.append(" extends ");
                            int j = 0;
                            while (j < bounds.length) {
                                if (j > 0) {
                                    this.fBuffer.append(JavaElementLabels.COMMA_STRING);
                                }
                                this.appendTypeSignatureLabel((IJavaElement)typeParameter, bounds[j], flags);
                                ++j;
                            }
                            break;
                        }
                    }
                    ++i;
                }
            }
            if (JavaElementLabelComposer.getFlag(flags, 0x400000L)) {
                this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
                this.appendElementLabel((IJavaElement)declaringMember, 0x40081L | flags & 0x1002000000000L);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    public void appendInitializerLabel(IInitializer initializer, long flags) {
        if (JavaElementLabelComposer.getFlag(flags, 1024L)) {
            this.appendTypeLabel(initializer.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
            this.fBuffer.append('.');
        }
        this.fBuffer.append(JavaUIMessages.JavaElementLabels_initializer);
        if (JavaElementLabelComposer.getFlag(flags, 2048L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
            this.appendTypeLabel(initializer.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
            if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    protected void appendTypeSignatureLabel(IJavaElement enclosingElement, String typeSig, long flags) {
        int sigKind = Signature.getTypeSignatureKind((String)typeSig);
        switch (sigKind) {
            case 2: {
                this.fBuffer.append(Signature.toString((String)typeSig));
                break;
            }
            case 4: {
                this.appendTypeSignatureLabel(enclosingElement, Signature.getElementType((String)typeSig), flags);
                int dim = Signature.getArrayCount((String)typeSig);
                while (dim > 0) {
                    this.fBuffer.append('[').append(']');
                    --dim;
                }
                break;
            }
            case 1: {
                String baseType = this.getSimpleTypeName(enclosingElement, Signature.getTypeErasure((String)typeSig));
                this.fBuffer.append(baseType);
                String[] typeArguments = Signature.getTypeArguments((String)typeSig);
                this.appendTypeArgumentSignaturesLabel(enclosingElement, typeArguments, flags);
                break;
            }
            case 3: {
                this.fBuffer.append(this.getSimpleTypeName(enclosingElement, typeSig));
                break;
            }
            case 5: {
                char ch = typeSig.charAt(0);
                if (ch == '*') {
                    this.fBuffer.append('?');
                    break;
                }
                if (ch == '+') {
                    this.fBuffer.append("? extends ");
                    this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1), flags);
                    break;
                }
                if (ch != '-') break;
                this.fBuffer.append("? super ");
                this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1), flags);
                break;
            }
            case 6: {
                this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1), flags);
            }
        }
    }

    protected String getSimpleTypeName(IJavaElement enclosingElement, String typeSig) {
        return Signature.getSimpleName((String)Signature.toString((String)typeSig));
    }

    private void appendTypeArgumentSignaturesLabel(IJavaElement enclosingElement, String[] typeArgsSig, long flags) {
        if (typeArgsSig.length > 0) {
            this.fBuffer.append(this.getLT());
            int i = 0;
            while (i < typeArgsSig.length) {
                if (i > 0) {
                    this.fBuffer.append(JavaElementLabels.COMMA_STRING);
                }
                this.appendTypeSignatureLabel(enclosingElement, typeArgsSig[i], flags);
                ++i;
            }
            this.fBuffer.append(this.getGT());
        }
    }

    private void appendTypeParameterSignaturesLabel(String[] typeParamSigs, long flags) {
        if (typeParamSigs.length > 0) {
            this.fBuffer.append(this.getLT());
            int i = 0;
            while (i < typeParamSigs.length) {
                if (i > 0) {
                    this.fBuffer.append(JavaElementLabels.COMMA_STRING);
                }
                this.fBuffer.append(Signature.getTypeVariable((String)typeParamSigs[i]));
                ++i;
            }
            this.fBuffer.append(this.getGT());
        }
    }

    protected String getLT() {
        return "<";
    }

    protected String getGT() {
        return ">";
    }

    public void appendTypeLabel(IType type, long flags) {
        String typeName;
        IPackageFragment pack;
        if (JavaElementLabelComposer.getFlag(flags, 262144L) && !(pack = type.getPackageFragment()).isDefaultPackage()) {
            this.appendPackageFragmentLabel(pack, flags & 0x1002000000000L);
            this.fBuffer.append('.');
        }
        if (JavaElementLabelComposer.getFlag(flags, 786432L)) {
            int parentType;
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                this.appendTypeLabel(declaringType, 0x80000L | flags & 0x1002000000000L);
                this.fBuffer.append('.');
            }
            if ((parentType = type.getParent().getElementType()) == 9 || parentType == 8 || parentType == 10) {
                this.appendElementLabel(type.getParent(), 0L);
                this.fBuffer.append('.');
            }
        }
        if ((typeName = this.getElementName((IJavaElement)type)).length() == 0) {
            try {
                if (type.getParent() instanceof IField && type.isEnum()) {
                    typeName = "{...}";
                } else {
                    String[] superInterfaceSignatures = type.getSuperInterfaceTypeSignatures();
                    String supertypeName = superInterfaceSignatures.length > 0 ? this.getSimpleTypeName((IJavaElement)type, superInterfaceSignatures[0]) : this.getSimpleTypeName((IJavaElement)type, type.getSuperclassTypeSignature());
                    typeName = Messages.format(JavaUIMessages.JavaElementLabels_anonym_type, supertypeName);
                }
            }
            catch (JavaModelException javaModelException) {
                typeName = JavaUIMessages.JavaElementLabels_anonym;
            }
        }
        this.fBuffer.append(typeName);
        if (JavaElementLabelComposer.getFlag(flags, 0x200000L)) {
            if (JavaElementLabelComposer.getFlag(flags, 0x1000000000000L) && type.isResolved()) {
                BindingKey key = new BindingKey(type.getKey());
                if (key.isParameterizedType()) {
                    String[] typeArguments = key.getTypeArguments();
                    this.appendTypeArgumentSignaturesLabel((IJavaElement)type, typeArguments, flags);
                } else {
                    String[] typeParameters = Signature.getTypeParameters((String)key.toSignature());
                    this.appendTypeParameterSignaturesLabel(typeParameters, flags);
                }
            } else if (type.exists()) {
                try {
                    this.appendTypeParametersLabels(type.getTypeParameters(), flags);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        if (JavaElementLabelComposer.getFlag(flags, 0x8000000000000L) && type.exists()) {
            try {
                this.appendCategoryLabel((IMember)type, flags);
            }
            catch (JavaModelException javaModelException) {}
        }
        if (JavaElementLabelComposer.getFlag(flags, 0x100000L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                this.appendTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L);
                int parentType = type.getParent().getElementType();
                if (parentType == 9 || parentType == 8 || parentType == 10) {
                    this.fBuffer.append('.');
                    this.appendElementLabel(type.getParent(), 0L);
                }
            } else {
                this.appendPackageFragmentLabel(type.getPackageFragment(), flags & 0x1002000000000L);
            }
            if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    protected String getElementName(IJavaElement element) {
        return element.getElementName();
    }

    public void appendDeclarationLabel(IJavaElement declaration, long flags) {
        IJavaElement openable;
        if (JavaElementLabelComposer.getFlag(flags, 0x1000000L) && (openable = (IJavaElement)declaration.getOpenable()) != null) {
            this.appendElementLabel(openable, 0x88000000L | flags & 0x1002000000000L);
            this.fBuffer.append('/');
        }
        if (declaration.getElementType() == 12) {
            this.fBuffer.append(JavaUIMessages.JavaElementLabels_import_container);
        } else {
            this.fBuffer.append(declaration.getElementName());
        }
        if (JavaElementLabelComposer.getFlag(flags, 0x2000000L)) {
            int offset = this.fBuffer.length();
            IJavaElement openable2 = (IJavaElement)declaration.getOpenable();
            if (openable2 != null) {
                this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
                this.appendElementLabel(openable2, 0x88000000L | flags & 0x1002000000000L);
            }
            if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public void appendClassFileLabel(IClassFile classFile, long flags) {
        IPackageFragment pack;
        if (JavaElementLabelComposer.getFlag(flags, 0x8000000L) && !(pack = (IPackageFragment)classFile.getParent()).isDefaultPackage()) {
            this.appendPackageFragmentLabel(pack, flags & 0x1002000000000L);
            this.fBuffer.append('.');
        }
        this.fBuffer.append(classFile.getElementName());
        if (JavaElementLabelComposer.getFlag(flags, 0x10000000L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
            this.appendPackageFragmentLabel((IPackageFragment)classFile.getParent(), flags & 0x1002000000000L);
            if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public void appendCompilationUnitLabel(ICompilationUnit cu, long flags) {
        IPackageFragment pack;
        if (JavaElementLabelComposer.getFlag(flags, 0x80000000L) && !(pack = (IPackageFragment)cu.getParent()).isDefaultPackage()) {
            this.appendPackageFragmentLabel(pack, flags & 0x1002000000000L);
            this.fBuffer.append('.');
        }
        this.fBuffer.append(cu.getElementName());
        if (JavaElementLabelComposer.getFlag(flags, 0x100000000L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
            this.appendPackageFragmentLabel((IPackageFragment)cu.getParent(), flags & 0x1002000000000L);
            if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public void appendPackageFragmentLabel(IPackageFragment pack, long flags) {
        if (JavaElementLabelComposer.getFlag(flags, 0x800000000L)) {
            this.appendPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x20000000000L);
            this.fBuffer.append('/');
        }
        if (pack.isDefaultPackage()) {
            this.fBuffer.append(JavaElementLabels.DEFAULT_PACKAGE);
        } else if (JavaElementLabelComposer.getFlag(flags, 0x2000000000L)) {
            this.appendCompressedPackageFragment(pack);
        } else {
            this.fBuffer.append(pack.getElementName());
        }
        if (JavaElementLabelComposer.getFlag(flags, 0x1000000000L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
            this.appendPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x20000000000L);
            if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    private void appendCompressedPackageFragment(IPackageFragment pack) {
        this.refreshPackageNamePattern();
        if (fgPkgNameLength < 0) {
            this.fBuffer.append(pack.getElementName());
            return;
        }
        String name = pack.getElementName();
        int start = 0;
        int dot = name.indexOf(46, start);
        while (dot > 0) {
            if (dot - start > fgPkgNameLength - 1) {
                this.fBuffer.append(fgPkgNamePrefix);
                if (fgPkgNameChars > 0) {
                    this.fBuffer.append(name.substring(start, Math.min(start + fgPkgNameChars, dot)));
                }
                this.fBuffer.append(fgPkgNamePostfix);
            } else {
                this.fBuffer.append(name.substring(start, dot + 1));
            }
            start = dot + 1;
            dot = name.indexOf(46, start);
        }
        this.fBuffer.append(name.substring(start));
    }

    public void appendPackageFragmentRootLabel(IPackageFragmentRoot root, long flags) {
        if (JavaElementLabelComposer.getFlag(flags, 0x10000000000L) && this.appendVariableLabel(root, flags)) {
            return;
        }
        if (root.isArchive()) {
            this.appendArchiveLabel(root, flags);
        } else {
            this.appendFolderLabel(root, flags);
        }
    }

    private void appendArchiveLabel(IPackageFragmentRoot root, long flags) {
        boolean external = root.isExternal();
        if (external) {
            this.appendExternalArchiveLabel(root, flags);
        } else {
            this.appendInternalArchiveLabel(root, flags);
        }
    }

    private boolean appendVariableLabel(IPackageFragmentRoot root, long flags) {
        try {
            IClasspathEntry rawEntry = root.getRawClasspathEntry();
            if (rawEntry != null && rawEntry.getEntryKind() == 4) {
                IPath path = rawEntry.getPath().makeRelative();
                if (JavaElementLabelComposer.getFlag(flags, 0x200000000000L)) {
                    int segements = path.segmentCount();
                    if (segements > 0) {
                        this.fBuffer.append(path.segment(segements - 1));
                        if (segements > 1) {
                            int offset = this.fBuffer.length();
                            this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
                            this.fBuffer.append(path.removeLastSegments(1).toOSString());
                            if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
                            }
                        }
                    } else {
                        this.fBuffer.append(path.toString());
                    }
                } else {
                    this.fBuffer.append(path.toString());
                }
                int offset = this.fBuffer.length();
                this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
                if (root.isExternal()) {
                    this.fBuffer.append(root.getPath().toOSString());
                } else {
                    this.fBuffer.append(root.getPath().makeRelative().toString());
                }
                if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
                }
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        return false;
    }

    private void appendExternalArchiveLabel(IPackageFragmentRoot root, long flags) {
        IPath path;
        try {
            IClasspathEntry rawClasspathEntry = root.getRawClasspathEntry();
            IPath rawPath = rawClasspathEntry.getPath();
            path = rawClasspathEntry.getEntryKind() != 5 && !rawPath.isAbsolute() ? rawPath : root.getPath();
        }
        catch (JavaModelException javaModelException) {
            path = root.getPath();
        }
        if (JavaElementLabelComposer.getFlag(flags, 0x200000000000L)) {
            int segements = path.segmentCount();
            if (segements > 0) {
                this.fBuffer.append(path.segment(segements - 1));
                int offset = this.fBuffer.length();
                if (segements > 1 || path.getDevice() != null) {
                    this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
                    this.fBuffer.append(path.removeLastSegments(1).toOSString());
                }
                if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
                }
            } else {
                this.fBuffer.append(path.toOSString());
            }
        } else {
            this.fBuffer.append(path.toOSString());
        }
    }

    private void appendInternalArchiveLabel(IPackageFragmentRoot root, long flags) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = JavaElementLabelComposer.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = JavaElementLabelComposer.getFlag(flags, 0x200000000000L) && this.isReferenced(root);
        if (rootQualified) {
            this.fBuffer.append(root.getPath().makeRelative().toString());
        } else {
            this.fBuffer.append(root.getElementName());
            int offset = this.fBuffer.length();
            if (referencedQualified) {
                this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
                this.fBuffer.append(resource.getParent().getFullPath().makeRelative().toString());
            } else if (JavaElementLabelComposer.getFlag(flags, 0x40000000000L)) {
                this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
                this.fBuffer.append(root.getParent().getPath().makeRelative().toString());
            } else {
                return;
            }
            if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    private void appendFolderLabel(IPackageFragmentRoot root, long flags) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        if (resource == null) {
            this.appendExternalArchiveLabel(root, flags);
            return;
        }
        boolean rootQualified = JavaElementLabelComposer.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = JavaElementLabelComposer.getFlag(flags, 0x200000000000L) && this.isReferenced(root);
        if (rootQualified) {
            this.fBuffer.append(root.getPath().makeRelative().toString());
        } else {
            IPath projectRelativePath = resource.getProjectRelativePath();
            if (projectRelativePath.segmentCount() == 0) {
                this.fBuffer.append(resource.getName());
                referencedQualified = false;
            } else {
                this.fBuffer.append(projectRelativePath.toString());
            }
            int offset = this.fBuffer.length();
            if (referencedQualified) {
                this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
                this.fBuffer.append(resource.getProject().getName());
            } else if (JavaElementLabelComposer.getFlag(flags, 0x40000000000L)) {
                this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
                this.fBuffer.append(root.getParent().getElementName());
            } else {
                return;
            }
            if (JavaElementLabelComposer.getFlag(flags, 0x80000000000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    private boolean isReferenced(IPackageFragmentRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject jarProject = resource.getProject();
            IProject container = root.getJavaProject().getProject();
            return !container.equals((Object)jarProject);
        }
        return false;
    }

    private void refreshPackageNamePattern() {
        String pattern = this.getPkgNamePatternForPackagesView();
        if (pattern.equals(fgPkgNamePattern)) {
            return;
        }
        if (pattern.length() == 0) {
            fgPkgNamePattern = "";
            fgPkgNameLength = -1;
            return;
        }
        fgPkgNamePattern = pattern;
        int i = 0;
        fgPkgNameChars = 0;
        fgPkgNamePrefix = "";
        fgPkgNamePostfix = "";
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (Character.isDigit(ch)) {
                fgPkgNameChars = ch - 48;
                if (i > 0) {
                    fgPkgNamePrefix = pattern.substring(0, i);
                }
                if (i >= 0) {
                    fgPkgNamePostfix = pattern.substring(i + 1);
                }
                fgPkgNameLength = fgPkgNamePrefix.length() + fgPkgNameChars + fgPkgNamePostfix.length();
                return;
            }
            ++i;
        }
        fgPkgNamePrefix = pattern;
        fgPkgNameLength = pattern.length();
    }

    private String getPkgNamePatternForPackagesView() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        if (!store.getBoolean("org.eclipse.jdt.ui.compresspackagenames")) {
            return "";
        }
        return store.getString("PackagesView.pkgNamePatternForPackagesView");
    }

    public static abstract class FlexibleBuffer {
        public abstract FlexibleBuffer append(char var1);

        public abstract FlexibleBuffer append(String var1);

        public abstract int length();

        public abstract void setStyle(int var1, int var2, StyledString.Styler var3);
    }

    public static class FlexibleStringBuffer
    extends FlexibleBuffer {
        private final StringBuffer fStringBuffer;

        public FlexibleStringBuffer(StringBuffer stringBuffer) {
            this.fStringBuffer = stringBuffer;
        }

        public FlexibleBuffer append(char ch) {
            this.fStringBuffer.append(ch);
            return this;
        }

        public FlexibleBuffer append(String string) {
            this.fStringBuffer.append(string);
            return this;
        }

        public int length() {
            return this.fStringBuffer.length();
        }

        public void setStyle(int offset, int length, StyledString.Styler styler) {
        }

        public String toString() {
            return this.fStringBuffer.toString();
        }
    }

    public static class FlexibleStyledString
    extends FlexibleBuffer {
        private final StyledString fStyledString;

        public FlexibleStyledString(StyledString stringBuffer) {
            this.fStyledString = stringBuffer;
        }

        public FlexibleBuffer append(char ch) {
            this.fStyledString.append(ch);
            return this;
        }

        public FlexibleBuffer append(String string) {
            this.fStyledString.append(string);
            return this;
        }

        public int length() {
            return this.fStyledString.length();
        }

        public void setStyle(int offset, int length, StyledString.Styler styler) {
            this.fStyledString.setStyle(offset, length, styler);
        }

        public String toString() {
            return this.fStyledString.toString();
        }
    }
}

