/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.xbean;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilder;
import org.apache.servicemix.common.Container;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.util.DOMUtil;
import org.apache.xbean.classloader.JarFileClassLoader;
import org.apache.xbean.spring.context.SpringApplicationContext;
import org.apache.xbean.spring.context.SpringXmlPreprocessor;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ClassLoaderXmlPreprocessor
implements SpringXmlPreprocessor {
    public static final String CLASSPATH_XML = "classpath.xml";
    public static final String LIB_DIR = "/lib";
    private final File root;
    private final ServiceMixComponent component;

    public ClassLoaderXmlPreprocessor(File root) {
        this(root, null);
    }

    public ClassLoaderXmlPreprocessor(File root, ServiceMixComponent component) {
        this.root = root;
        this.component = component;
    }

    public void preprocess(SpringApplicationContext applicationContext, XmlBeanDefinitionReader reader, Document document) {
        ClassLoader classLoader;
        NodeList classpathElements = document.getDocumentElement().getElementsByTagName("classpath");
        if (classpathElements.getLength() == 0) {
            URL url = this.getResource(CLASSPATH_XML);
            if (url != null) {
                DocumentBuilder builder = null;
                try {
                    builder = DOMUtil.getBuilder();
                    Document doc = builder.parse(url.toString());
                    classLoader = this.getClassLoader(applicationContext, reader, doc);
                }
                catch (Exception e) {
                    throw new FatalBeanException("Unable to load classpath.xml file", (Throwable)e);
                }
                finally {
                    DOMUtil.releaseBuilder(builder);
                }
            } else {
                try {
                    URL[] urls = this.getDefaultLocations();
                    ClassLoader parentLoader = this.getParentClassLoader(applicationContext);
                    classLoader = new JarFileClassLoader(applicationContext.getDisplayName(), urls, parentLoader);
                }
                catch (Exception e) {
                    throw new FatalBeanException("Unable to create default classloader for SU", (Throwable)e);
                }
            }
        } else {
            classLoader = this.getClassLoader(applicationContext, reader, document);
        }
        reader.setBeanClassLoader(classLoader);
        applicationContext.setClassLoader(classLoader);
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    protected URL getResource(String location) {
        URI uri = this.root.toURI().resolve(location);
        File file = new File(uri);
        if (!file.canRead()) {
            return null;
        }
        try {
            return file.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed resource " + uri);
        }
    }

    protected URL[] getDefaultLocations() {
        try {
            File[] jars = new File(this.root, LIB_DIR).listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return (name = name.toLowerCase()).endsWith(".jar") || name.endsWith(".zip");
                }
            });
            URL[] urls = new URL[jars != null ? jars.length + 1 : 1];
            urls[0] = this.root.toURL();
            if (jars != null) {
                for (int i = 0; i < jars.length; ++i) {
                    urls[i + 1] = jars[i].toURL();
                }
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new FatalBeanException("Unable to get default classpath locations", (Throwable)e);
        }
    }

    protected ClassLoader getClassLoader(SpringApplicationContext applicationContext, XmlBeanDefinitionReader reader, Document document) {
        ClassLoader classLoader;
        NodeList classpathElements = document.getDocumentElement().getElementsByTagName("classpath");
        if (classpathElements.getLength() < 1) {
            classLoader = this.getParentClassLoader(applicationContext);
        } else {
            ClassLoader cl;
            URL[] urls;
            if (classpathElements.getLength() > 1) {
                throw new FatalBeanException("Expected only classpath element but found " + classpathElements.getLength());
            }
            Element classpathElement = (Element)classpathElements.item(0);
            boolean inverse = false;
            String inverseAttr = classpathElement.getAttribute("inverse");
            if (inverseAttr != null && "true".equalsIgnoreCase(inverseAttr)) {
                inverse = true;
            }
            ArrayList<String> hidden = new ArrayList<String>();
            NodeList hiddenElems = classpathElement.getElementsByTagName("hidden");
            for (int i = 0; i < hiddenElems.getLength(); ++i) {
                Element hiddenElement = (Element)hiddenElems.item(i);
                String pattern = ((Text)hiddenElement.getFirstChild()).getData().trim();
                hidden.add(pattern);
            }
            ArrayList<String> nonOverridable = new ArrayList<String>();
            NodeList nonOverridableElems = classpathElement.getElementsByTagName("nonOverridable");
            for (int i = 0; i < nonOverridableElems.getLength(); ++i) {
                Element nonOverridableElement = (Element)nonOverridableElems.item(i);
                String pattern = ((Text)nonOverridableElement.getFirstChild()).getData().trim();
                nonOverridable.add(pattern);
            }
            ArrayList<String> classpath = new ArrayList<String>();
            NodeList locations = classpathElement.getElementsByTagName("location");
            for (int i = 0; i < locations.getLength(); ++i) {
                Element locationElement = (Element)locations.item(i);
                String location = ((Text)locationElement.getFirstChild()).getData().trim();
                classpath.add(location);
            }
            ArrayList<String> sls = new ArrayList<String>();
            NodeList libraries = classpathElement.getElementsByTagName("library");
            for (int i = 0; i < libraries.getLength(); ++i) {
                Element locationElement = (Element)libraries.item(i);
                String library = ((Text)locationElement.getFirstChild()).getData().trim();
                sls.add(library);
            }
            if (sls.size() > 0 && this.component.getContainer().getType() != Container.Type.ServiceMix3) {
                throw new IllegalStateException("Can not reference shared libraries if the component is not deployed in ServiceMix 3");
            }
            ArrayList<String> components = new ArrayList<String>();
            NodeList componentList = classpathElement.getElementsByTagName("component");
            for (int i = 0; i < componentList.getLength(); ++i) {
                Element locationElement = (Element)componentList.item(i);
                String component = ((Text)locationElement.getFirstChild()).getData().trim();
                components.add(component);
            }
            if (components.size() > 0 && this.component.getContainer().getType() != Container.Type.ServiceMix3) {
                throw new IllegalStateException("Can not reference other components if the component is not deployed in ServiceMix 3");
            }
            if (classpath.size() != 0) {
                urls = new URL[classpath.size()];
                ListIterator iterator = classpath.listIterator();
                while (iterator.hasNext()) {
                    String location = (String)iterator.next();
                    URL url = this.getResource(location);
                    if (url == null) {
                        throw new FatalBeanException("Unable to resolve classpath location " + location);
                    }
                    urls[iterator.previousIndex()] = url;
                }
            } else {
                urls = this.getDefaultLocations();
            }
            ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>();
            parents.add(this.getParentClassLoader(applicationContext));
            for (String library : sls) {
                cl = this.component.getContainer().getSharedLibraryClassLoader(library);
                if (cl == null) {
                    throw new IllegalStateException("No such shared library: " + library);
                }
                parents.add(cl);
            }
            for (String component : components) {
                cl = this.component.getContainer().getComponentClassLoader(component);
                if (cl == null) {
                    throw new IllegalStateException("No such component: " + component);
                }
                parents.add(cl);
            }
            classLoader = new JarFileClassLoader(applicationContext.getDisplayName(), urls, parents.toArray(new ClassLoader[parents.size()]), inverse, hidden.toArray(new String[hidden.size()]), nonOverridable.toArray(new String[nonOverridable.size()]));
            document.getDocumentElement().removeChild(classpathElement);
        }
        return classLoader;
    }

    protected ClassLoader getParentClassLoader(SpringApplicationContext applicationContext) {
        ClassLoader classLoader = applicationContext.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }
}

