/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.util.ColumnExtractor;
import org.apache.servicemix.components.util.ContentConverter;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.LineIterator;
import org.apache.servicemix.components.util.NoConversion;
import org.apache.servicemix.components.util.StringUtils;
import org.apache.servicemix.components.util.TextStripConverter;
import org.apache.servicemix.components.util.XmlEscapingConverter;

public class SimpleFlatFileMarshaler
extends DefaultFileMarshaler {
    public static final String XMLDECLARATION_LINE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    public static final ContentConverter NO_CONVERSION = new NoConversion();
    public static final ContentConverter TEXT_STRIPPER = new TextStripConverter();
    public static final ContentConverter XML_CONVERTER = new XmlEscapingConverter();
    public static final int LINEFORMAT_FIXLENGTH = 0;
    public static final int LINEFORMAT_CSV = 1;
    public static final int LINEFORMAT_VARIABLE = 2;
    public static final int LINEFORMAT_DEFAULT = 0;
    private static final String XML_OPEN = "<";
    private static final String XML_OPEN_END = "</";
    private static final String XML_CLOSE = ">";
    private static final String XML_CLOSE_NEWLINE = ">\n";
    private static final String XML_CLOSE_ATTR_NEWLINE = "\">\n";
    private static final String XML_CLOSE_ATTR = "\">";
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean xmlDeclaration = true;
    private String encoding;
    private String docElementNamespace;
    private String docElementname = "File";
    private String lineElementname = "Line";
    private String columnElementname = "Column";
    private int lineFormat = 0;
    private String columnSeparator = ";";
    private String lineSeparator;
    private ColumnExtractor columnExtractor;
    private int[] columnLengths;
    private List columnConverters;
    private String[] columnNames;
    private boolean insertLineNumbers = true;
    private boolean insertColNumbers;
    private boolean skipKnownEmptyCols = true;
    private boolean skipAnyEmptyCols;
    private boolean alwaysStripColContents = true;
    private boolean alwaysEscapeColContents;
    private boolean insertRawData;
    private boolean insertColContentInAttribut;
    private int headerlinesCount;
    private int columnNamesInLineNumber = -1;

    public boolean isSkipAnyEmptyCols() {
        return this.skipAnyEmptyCols;
    }

    public void setSkipAnyEmptyCols(boolean skipAnyEmptyCols) {
        this.skipAnyEmptyCols = skipAnyEmptyCols;
    }

    public void readMessage(MessageExchange exchange, NormalizedMessage message, InputStream in, String path) throws IOException, JBIException {
        message.setContent((Source)new StreamSource(this.convertLines(message, in, path)));
        message.setProperty("org.apache.servicemix.file.name", (Object)new File(path).getName());
        message.setProperty("org.apache.servicemix.file.path", (Object)path);
    }

    protected InputStream convertLinesToStream(NormalizedMessage message, InputStream in, String path) throws IOException {
        String wholeFileConverted = this.convertLinesToString(message, in, path);
        if (wholeFileConverted != null) {
            return new ByteArrayInputStream(wholeFileConverted.getBytes("UTF-8"));
        }
        return new InputStreamWrapper(in, path, "UTF-8");
    }

    protected InputStream convertLines(NormalizedMessage message, InputStream in, String path) throws IOException {
        return this.convertLinesToStream(message, in, path);
    }

    @Deprecated
    protected String convertLinesToString(NormalizedMessage message, InputStream in, String path) throws IOException {
        return null;
    }

    @Deprecated
    protected void processHeaderLines(StringBuffer buffer, Iterator lines) {
    }

    protected void convertHeaderline(StringBuffer buffer, String headerLine) {
        buffer.append("<!-- ");
        headerLine = TEXT_STRIPPER.convertToXml(headerLine);
        headerLine = headerLine.replaceAll("--", "__");
        buffer.append(" -->\n");
    }

    protected void extractColumns(StringBuffer buffer, String lineText, Iterator lines) {
        String[] rawcolContents = this.extractColumnContents(lineText, lines);
        if (rawcolContents != null && rawcolContents.length > 0) {
            for (int i = 0; i < rawcolContents.length; ++i) {
                String colText = rawcolContents[i];
                String colName = this.findColumnname(i);
                String colContents = this.convertColumnContents(i, colText);
                if (colContents == null || colContents.length() == 0 && (this.skipAnyEmptyCols || this.skipKnownEmptyCols && !this.columnElementname.equals(colName))) continue;
                if (this.insertColContentInAttribut) {
                    buffer.append(XML_OPEN + colName);
                    if (this.insertColNumbers) {
                        buffer.append(" number=\"");
                        buffer.append(i + 1);
                        buffer.append("\"");
                    }
                    buffer.append(" value=\"");
                    buffer.append(colContents);
                    buffer.append("\"/>");
                    continue;
                }
                if (!this.insertColNumbers) {
                    buffer.append(XML_OPEN + colName + XML_CLOSE);
                } else {
                    buffer.append(XML_OPEN + colName);
                    buffer.append(" number=\"");
                    buffer.append(i + 1);
                    buffer.append("\"/>");
                }
                buffer.append(colContents);
                buffer.append(XML_OPEN_END + colName + XML_CLOSE);
            }
        }
    }

    protected String[] extractColumnContents(String lineText, Iterator lines) {
        String[] result = null;
        if (lineText != null && lineText.length() > 0) {
            if (this.lineFormat == 0) {
                if (this.columnLengths != null && this.columnLengths.length > 0) {
                    result = new String[this.columnLengths.length];
                    int curIndex = 0;
                    for (int i = 0; i < this.columnLengths.length; ++i) {
                        try {
                            result[i] = lineText.substring(curIndex, curIndex + this.columnLengths[i]);
                            curIndex += this.columnLengths[i];
                            continue;
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            break;
                        }
                    }
                }
            } else if (this.lineFormat == 1) {
                result = StringUtils.splitWorker(lineText, this.columnSeparator, -1, true);
            } else if (this.lineFormat == 2) {
                if (this.columnExtractor == null) {
                    throw new IllegalStateException("No Column Extractor defined");
                }
                result = this.columnExtractor.extractColumns(lineText);
            } else {
                throw new IllegalStateException("Unknown line format '" + this.lineFormat + "'");
            }
        }
        return result;
    }

    protected String findColumnname(int index) {
        String result = this.columnElementname;
        if (this.columnNames != null && this.columnNames.length > index && this.columnNames[index] != null) {
            return this.columnNames[index];
        }
        return result;
    }

    protected String convertColumnContents(int index, String contents) {
        if (this.columnConverters != null && this.columnConverters.size() > index && this.columnConverters.get(index) != null) {
            ContentConverter converter = (ContentConverter)this.columnConverters.get(index);
            return converter.convertToXml(contents);
        }
        if (this.alwaysEscapeColContents) {
            return XML_CONVERTER.convertToXml(contents);
        }
        if (this.alwaysStripColContents) {
            return TEXT_STRIPPER.convertToXml(contents);
        }
        return NO_CONVERSION.convertToXml(contents);
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final String getColumnElementname() {
        return this.columnElementname;
    }

    public final void setColumnElementname(String columnElementname) {
        this.columnElementname = columnElementname;
    }

    public final String getDocElementname() {
        return this.docElementname;
    }

    public final void setDocElementname(String docElementname) {
        this.docElementname = docElementname;
    }

    public final String getLineElementname() {
        return this.lineElementname;
    }

    public final void setLineElementname(String lineElementname) {
        this.lineElementname = lineElementname;
    }

    public final void setColumnLengths(String[] columnLengths) {
        this.columnLengths = new int[columnLengths.length];
        for (int i = 0; i < columnLengths.length; ++i) {
            this.columnLengths[i] = Integer.parseInt(columnLengths[i]);
        }
    }

    public final boolean isXmlDeclaration() {
        return this.xmlDeclaration;
    }

    public final void setXmlDeclaration(boolean xmlDeclaration) {
        this.xmlDeclaration = xmlDeclaration;
    }

    public final void setInsertLineNumbers(boolean insertLineNumbers) {
        this.insertLineNumbers = insertLineNumbers;
    }

    public final void setColumnConverters(List columnConverters) {
        this.columnConverters = columnConverters;
    }

    public final void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public final boolean isSkipKnownEmptyCols() {
        return this.skipKnownEmptyCols;
    }

    public final void setSkipKnownEmptyCols(boolean skipKnownEmptyCols) {
        this.skipKnownEmptyCols = skipKnownEmptyCols;
    }

    public final void setInsertRawData(boolean insertRawData) {
        this.insertRawData = insertRawData;
    }

    public final boolean isAlwaysStripColContents() {
        return this.alwaysStripColContents;
    }

    public final void setAlwaysStripColContents(boolean alwaysStripColContents) {
        this.alwaysStripColContents = alwaysStripColContents;
    }

    public final boolean isAlwaysEscapeColContents() {
        return this.alwaysEscapeColContents;
    }

    public final void setAlwaysEscapeColContents(boolean alwaysEscapeColContents) {
        this.alwaysEscapeColContents = alwaysEscapeColContents;
    }

    public final int getLineFormat() {
        return this.lineFormat;
    }

    public final void setLineFormat(int lineFormat) {
        this.lineFormat = lineFormat;
    }

    public final String getColumnSeparator() {
        return this.columnSeparator;
    }

    public final void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public final void setColumnSeparatorCode(int columnSeparatorCode) {
        this.columnSeparator = new String(new char[]{(char)columnSeparatorCode});
    }

    public final String getLineSeparator() {
        return this.lineSeparator;
    }

    public final void setLineSeparator(String lineSeparator) {
        if (lineSeparator != null && lineSeparator.length() > 1) {
            throw new IllegalArgumentException("Currently only 1 character separators are supported, or null.");
        }
        this.lineSeparator = lineSeparator;
    }

    public final void setLineSeparatorCode(int lineSeparatorCode) {
        this.lineSeparator = new String(new char[]{(char)lineSeparatorCode});
    }

    public final String getDocElementNamespace() {
        return this.docElementNamespace;
    }

    public final void setDocElementNamespace(String docElementNamespace) {
        this.docElementNamespace = docElementNamespace;
    }

    public final int getHeaderlinesCount() {
        return this.headerlinesCount;
    }

    public final void setHeaderlinesCount(int headerlinesCount) {
        this.headerlinesCount = headerlinesCount;
    }

    public final int getColumnNamesInLineNumber() {
        return this.columnNamesInLineNumber;
    }

    public void setColumnNamesInLineNumber(int columnNamesInLineNumber) {
        this.columnNamesInLineNumber = columnNamesInLineNumber;
    }

    public final boolean isInsertColContentInAttribut() {
        return this.insertColContentInAttribut;
    }

    public final void setInsertColContentInAttribut(boolean insertColContentInAttribut) {
        this.insertColContentInAttribut = insertColContentInAttribut;
    }

    public final boolean isInsertColNumbers() {
        return this.insertColNumbers;
    }

    public final void setInsertColNumbers(boolean insertColNumbers) {
        this.insertColNumbers = insertColNumbers;
    }

    public final void setColumnExtractor(ColumnExtractor columnExtractor) {
        this.columnExtractor = columnExtractor;
    }

    protected static void closeQuietly(Reader input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ String[] access$502(SimpleFlatFileMarshaler x0, String[] x1) {
        x0.columnNames = x1;
        return x1;
    }

    private static class CustomEndOfLineIterator
    implements Iterator {
        private InputStreamReader inr;
        private String lineSeparator;
        private String next;
        private boolean eof;

        public CustomEndOfLineIterator(InputStream in, String encoding, String lineSeparator) {
            if (encoding == null) {
                this.inr = new InputStreamReader(in);
            } else {
                try {
                    this.inr = new InputStreamReader(in, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            this.lineSeparator = lineSeparator;
            this.eof = false;
            this.readNext();
        }

        public void close() {
            this.eof = true;
            SimpleFlatFileMarshaler.closeQuietly(this.inr);
            this.next = null;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove unsupported on CustomEndOfLineIterator");
        }

        public boolean hasNext() {
            if (this.next == null && !this.eof) {
                this.readNext();
            }
            return !this.eof;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String res = this.next;
            this.readNext();
            return res;
        }

        private void readNext() {
            if (this.eof) {
                this.next = null;
                return;
            }
            StringBuilder sb = new StringBuilder();
            while (true) {
                int b;
                try {
                    b = this.inr.read();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (b == -1) {
                    this.eof = true;
                    break;
                }
                if ((char)b == this.lineSeparator.charAt(0)) break;
                sb.append((char)b);
            }
            this.next = sb.toString();
        }
    }

    final class InputStreamWrapper
    extends InputStream {
        private boolean isEOF;
        private byte[] cache;
        private int cacheLen;
        private int cachePos;
        private InputStream in;
        private String path;
        private String outEncoding;
        private int headerlinesRead;
        private Iterator lines;
        private int lineNumber;
        private boolean isFooterFilled;

        InputStreamWrapper(InputStream in, String path, String outEncoding) throws UnsupportedEncodingException, IOException {
            SimpleFlatFileMarshaler.this.log.trace((Object)"Entered InputStreamWrapper constructor");
            " ".getBytes(outEncoding);
            this.in = in;
            this.path = path;
            this.outEncoding = outEncoding;
            if (SimpleFlatFileMarshaler.this.lineSeparator == null) {
                InputStreamReader reader = null;
                reader = SimpleFlatFileMarshaler.this.encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, SimpleFlatFileMarshaler.this.encoding);
                this.lines = new LineIterator(reader);
            } else {
                this.lines = new CustomEndOfLineIterator(in, SimpleFlatFileMarshaler.this.encoding, SimpleFlatFileMarshaler.this.lineSeparator);
            }
            SimpleFlatFileMarshaler.this.log.trace((Object)"Leaving InputStreamWrapper constructor");
        }

        public int read() throws IOException {
            this.fillCache();
            if (this.isEOF) {
                return -1;
            }
            return 0xFF & this.cache[this.cachePos++];
        }

        private void fillCache() throws IOException {
            if (this.cachePos < this.cacheLen || this.isEOF) {
                return;
            }
            if (this.cache == null) {
                this.fillInitial();
                return;
            }
            if (!this.lines.hasNext()) {
                if (!this.isFooterFilled) {
                    this.fillFooter();
                    return;
                }
                this.isEOF = true;
                this.cache = null;
                this.cachePos = 0;
                this.cacheLen = 0;
                return;
            }
            if (this.headerlinesRead < SimpleFlatFileMarshaler.this.headerlinesCount) {
                this.fillHeader();
            } else {
                this.fillBody();
            }
        }

        public int available() throws IOException {
            return this.cacheLen - this.cachePos + this.in.available();
        }

        public void close() throws IOException {
            this.in.close();
        }

        private void fill(String string) {
            if (SimpleFlatFileMarshaler.this.log.isTraceEnabled()) {
                SimpleFlatFileMarshaler.this.log.trace((Object)("InputStreamWrapper.fill(" + string + ")"));
            }
            try {
                this.cache = string.getBytes(this.outEncoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Bug in the code flow: unsupported encoding should be detected in constructor", ex);
            }
            this.cachePos = 0;
            this.cacheLen = this.cache.length;
        }

        private void fillFooter() {
            this.isFooterFilled = true;
            this.fill(SimpleFlatFileMarshaler.XML_OPEN_END + SimpleFlatFileMarshaler.this.docElementname + SimpleFlatFileMarshaler.XML_CLOSE_NEWLINE);
        }

        private void fillHeader() throws IOException {
            StringBuffer aBuffer = new StringBuffer(1024);
            String headerLine = (String)this.lines.next();
            if (SimpleFlatFileMarshaler.this.columnNamesInLineNumber == this.headerlinesRead++) {
                SimpleFlatFileMarshaler.access$502(SimpleFlatFileMarshaler.this, SimpleFlatFileMarshaler.this.extractColumnContents(headerLine, this.lines));
            }
            SimpleFlatFileMarshaler.this.convertHeaderline(aBuffer, headerLine);
            this.fill(aBuffer.toString());
        }

        private void fillInitial() throws IOException {
            StringBuffer aBuffer = new StringBuffer(1024);
            if (SimpleFlatFileMarshaler.this.xmlDeclaration) {
                aBuffer.append(SimpleFlatFileMarshaler.XMLDECLARATION_LINE);
            }
            aBuffer.append(SimpleFlatFileMarshaler.XML_OPEN + SimpleFlatFileMarshaler.this.docElementname);
            if (SimpleFlatFileMarshaler.this.docElementNamespace != null) {
                aBuffer.append("xmlns=\"");
                aBuffer.append(SimpleFlatFileMarshaler.this.docElementNamespace);
                aBuffer.append("\"");
            }
            aBuffer.append(" name=\"");
            aBuffer.append(new File(this.path).getName());
            aBuffer.append("\"");
            aBuffer.append(" location=\"");
            aBuffer.append(this.path);
            aBuffer.append(SimpleFlatFileMarshaler.XML_CLOSE_ATTR_NEWLINE);
            int overridenCheck = aBuffer.length();
            SimpleFlatFileMarshaler.this.processHeaderLines(aBuffer, this.lines);
            if (aBuffer.length() != overridenCheck) {
                this.headerlinesRead = Integer.MAX_VALUE;
            }
            this.fill(aBuffer.toString());
        }

        private void fillBody() throws IOException {
            ++this.lineNumber;
            StringBuffer aBuffer = new StringBuffer(1024);
            String lineText = (String)this.lines.next();
            aBuffer.append(SimpleFlatFileMarshaler.XML_OPEN + SimpleFlatFileMarshaler.this.lineElementname);
            if (SimpleFlatFileMarshaler.this.insertLineNumbers || SimpleFlatFileMarshaler.this.insertRawData) {
                if (SimpleFlatFileMarshaler.this.insertLineNumbers) {
                    aBuffer.append(" number=\"");
                    aBuffer.append(this.lineNumber);
                    if (!SimpleFlatFileMarshaler.this.insertRawData) {
                        aBuffer.append(SimpleFlatFileMarshaler.XML_CLOSE_ATTR);
                    } else {
                        aBuffer.append("\"");
                    }
                }
                if (SimpleFlatFileMarshaler.this.insertRawData) {
                    aBuffer.append(" raw=\"");
                    aBuffer.append(lineText);
                    aBuffer.append(SimpleFlatFileMarshaler.XML_CLOSE_ATTR);
                }
            } else {
                aBuffer.append(SimpleFlatFileMarshaler.XML_CLOSE);
            }
            if (SimpleFlatFileMarshaler.this.columnLengths != null || SimpleFlatFileMarshaler.this.lineFormat != 0) {
                SimpleFlatFileMarshaler.this.extractColumns(aBuffer, lineText, this.lines);
            } else {
                aBuffer.append(lineText);
            }
            aBuffer.append(SimpleFlatFileMarshaler.XML_OPEN_END + SimpleFlatFileMarshaler.this.lineElementname + SimpleFlatFileMarshaler.XML_CLOSE_NEWLINE);
            this.fill(aBuffer.toString());
        }
    }
}

