/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.bindings.soap;

import javax.xml.namespace.QName;
import org.apache.servicemix.soap.bindings.soap.SoapVersion;

public class Soap12
implements SoapVersion {
    public static final String SOAP_NAMESPACE = "http://www.w3.org/2003/05/soap-envelope";
    public static final String SOAP_DEFAULT_PREFIX = "soap";
    private static final Soap12 INSTANCE = new Soap12("soap");
    private final double version = 1.2;
    private final String namespace = "http://www.w3.org/2003/05/soap-envelope";
    private final String prefix;
    private final String noneRole = "http://www.w3.org/2003/05/soap-envelope/role/none";
    private final String ultimateReceiverRole = "http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver";
    private final String nextRole = "http://www.w3.org/2003/05/soap-envelope/role/next";
    private final String soapEncodingStyle = "http://www.w3.org/2003/05/soap-encoding";
    private final QName envelope;
    private final QName header;
    private final QName body;
    private final QName fault;

    public static Soap12 getInstance() {
        return INSTANCE;
    }

    public Soap12(String prefix) {
        this.prefix = prefix;
        this.envelope = new QName(SOAP_NAMESPACE, "Envelope", prefix);
        this.header = new QName(SOAP_NAMESPACE, "Header", prefix);
        this.body = new QName(SOAP_NAMESPACE, "Body", prefix);
        this.fault = new QName(SOAP_NAMESPACE, "Fault", prefix);
    }

    public String getSoapMimeType() {
        return "application/soap+xml; charset=utf-8";
    }

    public double getVersion() {
        return 1.2;
    }

    public String getNamespace() {
        return SOAP_NAMESPACE;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public QName getEnvelope() {
        return this.envelope;
    }

    public QName getHeader() {
        return this.header;
    }

    public QName getBody() {
        return this.body;
    }

    public QName getFault() {
        return this.fault;
    }

    public String getSoapEncodingStyle() {
        return "http://www.w3.org/2003/05/soap-encoding";
    }

    public String getNoneRole() {
        return "http://www.w3.org/2003/05/soap-envelope/role/none";
    }

    public String getUltimateReceiverRole() {
        return "http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver";
    }

    public String getNextRole() {
        return "http://www.w3.org/2003/05/soap-envelope/role/next";
    }

    public String getAttrNameRole() {
        return "role";
    }

    public String getAttrNameMustUnderstand() {
        return "mustUnderstand";
    }

    public SoapVersion getDerivedVersion(String prefix) {
        return new Soap12(prefix);
    }
}

