/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.bindings.soap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.servicemix.soap.bindings.soap.Soap11;
import org.apache.servicemix.soap.bindings.soap.Soap12;
import org.apache.servicemix.soap.bindings.soap.SoapVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapVersionFactory {
    private static SoapVersionFactory factory = new SoapVersionFactory();
    private Map<String, SoapVersion> versions = new HashMap<String, SoapVersion>();

    public static SoapVersionFactory getInstance() {
        return factory;
    }

    public SoapVersion getSoapVersion(QName name) {
        SoapVersion v = this.getSoapVersion(name.getNamespaceURI());
        if (v != null && name.getPrefix() != null && !name.getPrefix().equals(v.getPrefix())) {
            v = v.getDerivedVersion(name.getPrefix());
        }
        return v;
    }

    public SoapVersion getSoapVersion(String namespace) {
        return this.versions.get(namespace);
    }

    public void register(SoapVersion version) {
        this.versions.put(version.getNamespace(), version);
    }

    public Iterator<SoapVersion> getVersions() {
        return this.versions.values().iterator();
    }

    static {
        SoapVersionFactory.getInstance().register(Soap11.getInstance());
        SoapVersionFactory.getInstance().register(Soap12.getInstance());
    }
}

