/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.bindings.soap.interceptors;

import java.util.ArrayList;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.model.Binding;
import org.apache.servicemix.soap.api.model.Operation;
import org.apache.servicemix.soap.bindings.soap.model.SoapBinding;
import org.apache.servicemix.soap.bindings.soap.model.SoapOperation;
import org.apache.servicemix.soap.core.AbstractInterceptor;

public class SoapActionInOperationInterceptor
extends AbstractInterceptor {
    public void handleMessage(Message message) {
        if (message.get(Operation.class) != null) {
            return;
        }
        String soapAction = message.getTransportHeaders().get("SOAPAction");
        if (soapAction != null) {
            if ((soapAction = soapAction.trim()).startsWith("\"") && soapAction.endsWith("\"")) {
                soapAction = soapAction.substring(1, soapAction.length() - 1);
            }
            if (soapAction.length() > 0) {
                SoapBinding binding = (SoapBinding)message.get(Binding.class);
                ArrayList<SoapOperation> matching = new ArrayList<SoapOperation>();
                for (SoapOperation operation : binding.getOperations()) {
                    if (!soapAction.equals(operation.getSoapAction())) continue;
                    matching.add(operation);
                }
                if (matching.size() == 1) {
                    message.put(Operation.class, matching.get(0));
                }
            }
        }
    }
}

