/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.interceptors.mime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.servicemix.soap.api.Fault;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.core.AbstractInterceptor;

public class AttachmentsInInterceptor
extends AbstractInterceptor {
    public static final String MULTIPART_CONTENT = "multipart/";

    public void handleMessage(Message message) {
        InputStream is = message.getContent(InputStream.class);
        if (is == null) {
            throw new NullPointerException("InputStream content not found");
        }
        String contentType = (String)message.get("Content-Type");
        if (contentType != null && contentType.toLowerCase().startsWith(MULTIPART_CONTENT)) {
            try {
                Session session = Session.getDefaultInstance((Properties)new Properties());
                is = new SequenceInputStream(new ByteArrayInputStream(new byte[]{13, 10}), is);
                MimeMessage mime = new MimeMessage(session, is);
                mime.setHeader("Content-Type", contentType);
                this.read(message, mime);
            }
            catch (IOException e) {
                throw new Fault(e);
            }
            catch (MessagingException e) {
                throw new Fault(e);
            }
        }
    }

    public void read(Message message, MimeMessage mime) throws MessagingException, IOException {
        int i;
        Object content = mime.getContent();
        if (!(content instanceof MimeMultipart)) {
            throw new UnsupportedOperationException("Expected a javax.mail.internet.MimeMultipart object but found a " + content.getClass());
        }
        MimeMultipart multipart = (MimeMultipart)content;
        ContentType type = new ContentType(mime.getContentType());
        String contentId = type.getParameter("start");
        MimeBodyPart contentPart = null;
        if (contentId != null) {
            contentPart = (MimeBodyPart)multipart.getBodyPart(contentId);
        } else {
            for (i = 0; i < multipart.getCount(); ++i) {
                MimeBodyPart contentPart2 = (MimeBodyPart)multipart.getBodyPart(i);
                String contentType = contentPart2.getContentType();
                if (contentType.indexOf("xml") < 0) continue;
                contentPart = contentPart2;
                break;
            }
        }
        message.setContent(InputStream.class, contentPart != null ? contentPart.getInputStream() : null);
        for (i = 0; i < multipart.getCount(); ++i) {
            MimeBodyPart part = (MimeBodyPart)multipart.getBodyPart(i);
            if (part == contentPart) continue;
            String id = part.getContentID();
            if (id == null) {
                id = "Part" + i;
            } else if (id.startsWith("<")) {
                id = id.substring(1, id.length() - 1);
            }
            message.getAttachments().put(id, part.getDataHandler());
        }
    }
}

