/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.interceptors.wsdl;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.model.Binding;
import org.apache.servicemix.soap.api.model.Operation;
import org.apache.servicemix.soap.bindings.soap.SoapFault;
import org.apache.servicemix.soap.core.AbstractInterceptor;

public class WsdlOperationInInterceptor
extends AbstractInterceptor {
    public void handleMessage(Message message) {
        if (message.get(Operation.class) != null) {
            return;
        }
        XMLStreamReader reader = message.getContent(XMLStreamReader.class);
        if (reader == null || reader.getEventType() != 1) {
            return;
        }
        Binding binding = message.get(Binding.class);
        ArrayList<Operation> matching = new ArrayList<Operation>();
        QName name = reader.getName();
        for (Operation oper : binding.getOperations()) {
            if (!name.equals(oper.getInput().getElementName())) continue;
            matching.add(oper);
        }
        if (matching.size() != 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("No matching operation found for element: ");
            sb.append(name);
            sb.append("\n");
            sb.append("Expected one of: \n");
            for (Operation oper : binding.getOperations()) {
                sb.append("  - ");
                sb.append(oper.getInput().getElementName());
                sb.append("\n");
            }
            throw new SoapFault(SoapFault.SENDER, sb.toString());
        }
        Operation op = (Operation)matching.get(0);
        message.put(Operation.class, op);
        message.put(org.apache.servicemix.soap.api.model.Message.class, op.getInput());
    }
}

