/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.util.stax;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.servicemix.soap.util.stax.ExtendedNamespaceContext;

public class FragmentStreamReader
extends StreamReaderDelegate
implements XMLStreamReader {
    protected static final int STATE_START_DOC = 0;
    protected static final int STATE_FIRST_ELEM = 1;
    protected static final int STATE_FIRST_RUN = 2;
    protected static final int STATE_RUN = 3;
    protected static final int STATE_END_DOC = 4;
    protected int depth;
    protected int state = 0;
    protected int event = 7;
    protected List<String> rootPrefixes;

    public FragmentStreamReader(XMLStreamReader parent) {
        super(parent);
        NamespaceContext ctx = this.getParent().getNamespaceContext();
        if (ctx instanceof ExtendedNamespaceContext) {
            this.rootPrefixes = new ArrayList<String>(((ExtendedNamespaceContext)ctx).getPrefixes());
        }
    }

    public int getEventType() {
        return this.event;
    }

    public int next() throws XMLStreamException {
        switch (this.state) {
            case 0: {
                this.state = 1;
                this.event = 7;
                break;
            }
            case 1: {
                this.state = 2;
                ++this.depth;
                this.event = 1;
                break;
            }
            case 2: {
                this.state = 3;
            }
            case 3: {
                this.event = this.getParent().next();
                if (this.event == 1) {
                    ++this.depth;
                    break;
                }
                if (this.event != 2) break;
                --this.depth;
                if (this.depth != 0) break;
                this.state = 4;
                break;
            }
            case 4: {
                this.event = 8;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this.event;
    }

    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public int getNamespaceCount() {
        if (this.state == 2 && this.rootPrefixes != null) {
            return this.rootPrefixes.size();
        }
        return this.getParent().getNamespaceCount();
    }

    public String getNamespacePrefix(int i) {
        if (this.state == 2 && this.rootPrefixes != null) {
            return this.rootPrefixes.get(i);
        }
        return this.getParent().getNamespacePrefix(i);
    }

    public String getNamespaceURI(int i) {
        if (this.state == 2 && this.rootPrefixes != null) {
            return this.getParent().getNamespaceContext().getNamespaceURI(this.rootPrefixes.get(i));
        }
        return this.getParent().getNamespaceURI(i);
    }

    public String getNamespaceURI(String prefix) {
        if (this.state == 2) {
            return this.getParent().getNamespaceContext().getNamespaceURI(prefix);
        }
        return this.getParent().getNamespaceURI(prefix);
    }

    public boolean isStartElement() {
        return this.event == 1;
    }

    public boolean isEndElement() {
        return this.event == 2;
    }

    public boolean isCharacters() {
        return this.event == 4;
    }

    public boolean isWhiteSpace() {
        return this.event == 6;
    }

    public boolean hasName() {
        return this.event == 1 || this.event == 2;
    }

    public boolean hasText() {
        return this.event == 4 || this.event == 11 || this.event == 9 || this.event == 5 || this.event == 6;
    }
}

