/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.processors;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointComponentContext;
import org.apache.servicemix.http.ContextManager;
import org.apache.servicemix.http.HttpComponent;
import org.apache.servicemix.http.HttpEndpoint;
import org.apache.servicemix.http.HttpProcessor;
import org.apache.servicemix.http.SslParameters;
import org.apache.servicemix.http.jetty.JaasJettyPrincipal;
import org.apache.servicemix.http.processors.AbstractProcessor;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.soap.Context;
import org.apache.servicemix.soap.SoapEndpoint;
import org.apache.servicemix.soap.SoapExchangeProcessor;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.SoapHelper;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.apache.servicemix.soap.marshalers.SoapWriter;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerProcessor
extends AbstractProcessor
implements SoapExchangeProcessor,
HttpProcessor {
    private static Log log = LogFactory.getLog(ConsumerProcessor.class);
    protected Object httpContext;
    protected ComponentContext context;
    protected DeliveryChannel channel;
    protected SoapHelper soapHelper;
    protected Map<String, Continuation> locks;
    protected Map<String, MessageExchange> exchanges;
    protected int suspentionTime = 60000;
    protected boolean started = false;

    public ConsumerProcessor(HttpEndpoint endpoint) {
        super(endpoint);
        this.soapHelper = new SoapHelper((SoapEndpoint)endpoint);
        this.locks = new ConcurrentHashMap<String, Continuation>();
        this.exchanges = new ConcurrentHashMap<String, MessageExchange>();
        this.suspentionTime = endpoint.getTimeout();
        if (this.suspentionTime <= 0) {
            this.suspentionTime = this.getConfiguration().getConsumerProcessorSuspendTime();
        }
    }

    @Override
    public SslParameters getSsl() {
        return this.endpoint.getSsl();
    }

    @Override
    public String getAuthMethod() {
        return this.endpoint.getAuthMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        Continuation cont = this.locks.get(exchange.getExchangeId());
        if (cont == null) {
            throw new Exception("HTTP request has timed out");
        }
        Continuation continuation = cont;
        synchronized (continuation) {
            if (this.locks.remove(exchange.getExchangeId()) == null) {
                throw new Exception("HTTP request has timed out");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resuming continuation for exchange: " + exchange.getExchangeId()));
            }
            this.exchanges.put(exchange.getExchangeId(), exchange);
            cont.resume();
            if (!cont.isResumed()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Could not resume continuation for exchange: " + exchange.getExchangeId()));
                }
                this.exchanges.remove(exchange.getExchangeId());
                throw new Exception("HTTP request has timed out for exchange: " + exchange.getExchangeId());
            }
        }
    }

    public void init() throws Exception {
        String url = this.endpoint.getLocationURI();
        this.context = new EndpointComponentContext((Endpoint)this.endpoint);
        this.channel = this.context.getDeliveryChannel();
        this.httpContext = this.getServerManager().createContext(url, this);
    }

    public void shutdown() throws Exception {
        this.getServerManager().remove(this.httpContext);
    }

    public void start() throws Exception {
        this.started = true;
    }

    public void stop() throws Exception {
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object e2;
        MessageExchange exchange;
        block29: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Receiving HTTP request: " + request));
            }
            if ("GET".equals(request.getMethod())) {
                this.processGetRequest(request, response);
                return;
            }
            if (!"POST".equals(request.getMethod())) {
                response.sendError(405, request.getMethod() + " not supported");
                return;
            }
            Continuation cont = ContinuationSupport.getContinuation((HttpServletRequest)request, null);
            if (!cont.isPending()) {
                try {
                    if (!this.started) {
                        response.sendError(503, "Endpoint is stopped");
                        return;
                    }
                    Context ctx = this.createContext(request);
                    request.setAttribute(Context.class.getName(), (Object)ctx);
                    exchange = this.soapHelper.onReceive(ctx);
                    this.exchanges.put(exchange.getExchangeId(), exchange);
                    NormalizedMessage inMessage = exchange.getMessage("in");
                    if (this.getConfiguration().isWantHeadersFromHttpIntoExchange()) {
                        inMessage.setProperty("javax.jbi.messaging.protocol.headers", this.getHeaders(request));
                    }
                    this.locks.put(exchange.getExchangeId(), cont);
                    request.setAttribute(MessageExchange.class.getName(), (Object)exchange.getExchangeId());
                    Continuation continuation = cont;
                    synchronized (continuation) {
                        this.channel.send(exchange);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Suspending continuation for exchange: " + exchange.getExchangeId()));
                        }
                        boolean result = cont.suspend((long)this.suspentionTime);
                        exchange = this.exchanges.remove(exchange.getExchangeId());
                        request.removeAttribute(MessageExchange.class.getName());
                        if (!result) {
                            this.locks.remove(exchange.getExchangeId());
                            throw new Exception("Exchange timed out");
                        }
                        break block29;
                    }
                }
                catch (RetryRequest retry) {
                    throw retry;
                }
                catch (SoapFault fault) {
                    this.sendFault(fault, request, response);
                    return;
                }
                catch (Exception e2) {
                    this.sendFault(new SoapFault(e2), request, response);
                    return;
                }
            }
            e2 = cont;
            synchronized (e2) {
                String id = (String)request.getAttribute(MessageExchange.class.getName());
                this.locks.remove(id);
                exchange = this.exchanges.remove(id);
                request.removeAttribute(MessageExchange.class.getName());
                if (exchange == null) {
                    throw new IllegalStateException("Exchange not found");
                }
                if (!cont.isResumed()) {
                    Exception e3 = new Exception("Exchange timed out: " + exchange.getExchangeId());
                    this.sendFault(new SoapFault(e3), request, response);
                    return;
                }
            }
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            e2 = exchange.getError();
            if (e2 == null) {
                e2 = new Exception("Unkown error (exchange aborted ?)");
            }
            throw e2;
        }
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            try {
                Fault fault = exchange.getFault();
                if (fault != null) {
                    this.processFault(exchange, request, response);
                } else {
                    this.processResponse(exchange, request, response);
                }
                exchange.setStatus(ExchangeStatus.DONE);
                this.channel.send(exchange);
            }
            catch (Exception e4) {
                exchange.setError(e4);
                this.channel.send(exchange);
                throw e4;
            }
        } else if (exchange.getStatus() == ExchangeStatus.DONE) {
            response.setStatus(202);
        }
    }

    private Context createContext(HttpServletRequest request) throws Exception {
        SoapMessage message = this.soapHelper.getSoapMarshaler().createReader().read((InputStream)request.getInputStream(), request.getHeader("Content-Type"));
        Context ctx = this.soapHelper.createContext(message);
        if (request.getUserPrincipal() != null) {
            if (request.getUserPrincipal() instanceof JaasJettyPrincipal) {
                Subject subject = ((JaasJettyPrincipal)request.getUserPrincipal()).getSubject();
                ctx.getInMessage().setSubject(subject);
            } else {
                ctx.getInMessage().addPrincipal(request.getUserPrincipal());
            }
        }
        return ctx;
    }

    private void processResponse(MessageExchange exchange, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NormalizedMessage outMsg = exchange.getMessage("out");
        if (outMsg != null) {
            Context ctx = (Context)request.getAttribute(Context.class.getName());
            SoapMessage out = this.soapHelper.onReply(ctx, outMsg);
            SoapWriter writer = this.soapHelper.getSoapMarshaler().createWriter(out);
            response.setContentType(writer.getContentType());
            writer.write((OutputStream)response.getOutputStream());
        }
    }

    private void processFault(MessageExchange exchange, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SoapFault fault = new SoapFault((QName)exchange.getFault().getProperty("org.apache.servicemix.soap.fault.code"), (QName)exchange.getFault().getProperty("org.apache.servicemix.soap.fault.subcode"), (String)exchange.getFault().getProperty("org.apache.servicemix.soap.fault.reason"), (URI)exchange.getFault().getProperty("org.apache.servicemix.soap.fault.node"), (URI)exchange.getFault().getProperty("org.apache.servicemix.soap.fault.role"), exchange.getFault().getContent());
        this.sendFault(fault, request, response);
    }

    private void processGetRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String query = request.getQueryString();
        if (query != null && query.trim().equalsIgnoreCase("wsdl")) {
            String uri = request.getRequestURI();
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            uri = uri + "main.wsdl";
            response.sendRedirect(uri);
            return;
        }
        String path = request.getPathInfo();
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        HttpComponent comp = (HttpComponent)this.endpoint.getServiceUnit().getComponent();
        comp.setProtocol(request.getScheme());
        comp.setHost(request.getServerName());
        comp.setPort(request.getServerPort());
        comp.setPath(request.getContextPath());
        this.endpoint.reloadWsdl();
        Node node = (Node)this.endpoint.getWsdls().get(path);
        this.generateDocument(response, node);
    }

    protected void sendFault(SoapFault fault, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (SoapFault.SENDER.equals(fault.getCode())) {
            response.setStatus(400);
        } else {
            response.setStatus(500);
        }
        Context ctx = (Context)request.getAttribute(Context.class.getName());
        SoapMessage soapFault = this.soapHelper.onFault(ctx, fault);
        SoapWriter writer = this.soapHelper.getSoapMarshaler().createWriter(soapFault);
        response.setContentType(writer.getContentType());
        writer.write((OutputStream)response.getOutputStream());
    }

    protected Map<String, String> getHeaders(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = request.getHeader(name);
            headers.put(name, value);
        }
        return headers;
    }

    protected ContextManager getServerManager() {
        HttpComponent comp = (HttpComponent)this.endpoint.getServiceUnit().getComponent();
        return comp.getServer();
    }

    protected void generateDocument(HttpServletResponse response, Node node) throws Exception {
        if (node == null) {
            response.sendError(404, "Unable to find requested resource");
            return;
        }
        response.setStatus(200);
        response.setContentType("text/xml");
        new SourceTransformer().toResult((Source)new DOMSource(node), (Result)new StreamResult((OutputStream)response.getOutputStream()));
    }
}

