/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.plugins.ws.wsdlgenerator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.osgi.EndpointExporter;
import org.apache.servicemix.cxf.transport.nmr.NMRDestination;
import org.apache.servicemix.http.HttpEndpoint;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.core.InternalEndpointWrapper;
import org.eclipse.swordfish.internal.core.util.AopProxyUtil;
import org.eclipse.swordfish.internal.core.util.smx.ServiceMixSupport;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpEndpointListener
implements BundleContextAware,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(HttpEndpointListener.class);
    public static final long CXF_ENDPOINT_POLLING_DELAY = 1000L;
    public static final long CXF_ENDPOINT_POLLING_ATTEMPTS = 25L;
    private ExecutorService executorService;
    private BundleContext bundleContext;
    private Bus bus;
    private NMR nmr;

    public NMR getNmr() {
        return this.nmr;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.nmr, (String)"nmr property must be not null");
        Assert.notNull((Object)this.bus, (String)"bus property must be not null");
        this.executorService = Executors.newCachedThreadPool();
    }

    @Resource
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void register(Object key, Map<String, ?> properties) {
        Object deployedAssembly = AopProxyUtil.getTargetService((Object)key, (BundleContext)this.bundleContext);
        if (!(deployedAssembly instanceof EndpointExporter)) {
            return;
        }
        EndpointExporter endpointExporter = (EndpointExporter)deployedAssembly;
        for (final Endpoint endpoint : endpointExporter.getEndpoints()) {
            if (!(endpoint instanceof HttpEndpoint)) continue;
            this.executorService.execute(new Runnable(){

                public void run() {
                    HttpEndpointListener.this.processEndpoint((HttpEndpoint)endpoint);
                }
            });
        }
    }

    private void processEndpoint(HttpEndpoint endpoint) {
        try {
            NMRDestination destination = this.getCxfEndpoint(endpoint);
            if (destination == null) {
                return;
            }
            Definition definition = new ServiceWSDLBuilder(this.bus, new ServiceInfo[]{destination.getEndpointInfo().getService()}).build();
            Document document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
            this.addAddressElementIfNeeded(document, endpoint.getLocationURI());
            String wsdlSource = new SourceTransformer().toString(document.getFirstChild());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)wsdlSource);
            }
            String filePath = File.createTempFile("swordfish.wsdl.", null).getPath();
            FileWriter fstream = new FileWriter(filePath);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(wsdlSource);
            out.close();
            endpoint.setWsdlResource((org.springframework.core.io.Resource)new FileSystemResource(filePath));
        }
        catch (Exception ex) {
            LOG.error((Object)("Could not generate wsdl for endpoint " + endpoint), (Throwable)ex);
        }
    }

    protected NMRDestination getCxfEndpoint(HttpEndpoint endpoint) throws InterruptedException {
        HashMap<String, String> props = new HashMap<String, String>();
        if (endpoint.getTargetInterfaceName() != null) {
            props.put("INTERFACE_NAME", endpoint.getTargetInterfaceName().toString());
        }
        if (endpoint.getTargetEndpoint() != null) {
            props.put("ENDPOINT_NAME", endpoint.getTargetEndpoint());
        }
        if (endpoint.getTargetService() != null) {
            props.put("SERVICE_NAME", endpoint.getTargetService().toString());
        }
        if (props.isEmpty()) {
            LOG.info((Object)("No target endpoint properties specified for " + endpoint + " .Skipping"));
            return null;
        }
        InternalEndpoint internalEndpoint = ServiceMixSupport.getEndpoint((NMR)this.nmr, props);
        int i = 0;
        while ((long)i < 25L) {
            if (internalEndpoint != null) break;
            Thread.sleep(1000L);
            internalEndpoint = ServiceMixSupport.getEndpoint((NMR)this.nmr, props);
            ++i;
        }
        if (!(internalEndpoint instanceof InternalEndpointWrapper)) {
            return null;
        }
        InternalEndpointWrapper endpointWrapper = (InternalEndpointWrapper)internalEndpoint;
        if (!(endpointWrapper.getEndpoint() instanceof NMRDestination)) {
            return null;
        }
        return (NMRDestination)endpointWrapper.getEndpoint();
    }

    private void addAddressElementIfNeeded(Document document, String location) throws TransformerException {
        Element portElement;
        new SourceTransformer().toString(document.getFirstChild());
        List elementList = DOMUtils.findAllElementsByTagNameNS((Element)document.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"port");
        if (elementList.size() > 0 && DOMUtils.getFirstElement((Node)(portElement = (Element)elementList.get(0))) == null) {
            Element addressElement = document.createElementNS("http://schemas.xmlsoap.org/wsdl/soap/", "address");
            portElement.appendChild(addressElement);
            addressElement.setAttribute("location", location);
        }
    }
}

