/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.DebugHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.ProfileLock;
import org.eclipse.equinox.internal.p2.engine.ProfileParser;
import org.eclipse.equinox.internal.p2.engine.ProfileWriter;
import org.eclipse.equinox.internal.p2.engine.ProfileXMLConstants;
import org.eclipse.equinox.internal.p2.engine.SurrogateProfileHandler;
import org.eclipse.equinox.internal.p2.persistence.XMLParser;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.ISurrogateProfileHandler;
import org.eclipse.equinox.internal.provisional.p2.engine.ProfileEvent;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleProfileRegistry
implements IProfileRegistry {
    private static final String PROFILE_REGISTRY = "profile registry";
    private static final String PROFILE_EXT = ".profile";
    private static final String PROFILE_GZ_EXT = ".profile.gz";
    public static final String DEFAULT_STORAGE_DIR = "profileRegistry";
    private static final String DATA_EXT = ".data";
    private SoftReference profiles;
    private Map profileLocks = new HashMap();
    private String self;
    private boolean updateSelfProfile;
    private File store;
    ISurrogateProfileHandler surrogateProfileHandler;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public SimpleProfileRegistry() {
        this(null, new SurrogateProfileHandler(), true);
    }

    public SimpleProfileRegistry(File registryDirectory, ISurrogateProfileHandler handler, boolean updateSelfProfile) {
        this.store = registryDirectory != null ? registryDirectory : SimpleProfileRegistry.getDefaultRegistryDirectory();
        this.surrogateProfileHandler = handler;
        this.self = EngineActivator.getContext().getProperty("eclipse.p2.profile");
        this.updateSelfProfile = updateSelfProfile;
    }

    private static File getDefaultRegistryDirectory() {
        AgentLocation agent;
        File registryDirectory = null;
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((agent = (AgentLocation)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new IllegalStateException("Profile Registry inialization failed: Agent Location is not available");
        }
        try {
            URL registryURL = new URL(agent.getDataArea("org.eclipse.equinox.p2.engine"), DEFAULT_STORAGE_DIR);
            registryDirectory = new File(registryURL.getPath());
            registryDirectory.mkdirs();
        }
        catch (MalformedURLException malformedURLException) {}
        return registryDirectory;
    }

    private void updateSelfProfile(Map profileMap) {
        if (profileMap == null) {
            return;
        }
        Profile selfProfile = (Profile)profileMap.get(this.self);
        if (selfProfile == null) {
            return;
        }
        if (DebugHelper.DEBUG_PROFILE_REGISTRY) {
            DebugHelper.debug(PROFILE_REGISTRY, "SimpleProfileRegistry.updateSelfProfile");
        }
        boolean changed = false;
        if (Boolean.valueOf(selfProfile.getProperty("org.eclipse.equinox.p2.roaming")).booleanValue()) {
            changed = this.updateRoamingProfile(selfProfile);
        }
        if (this.surrogateProfileHandler != null && this.surrogateProfileHandler.isSurrogate(selfProfile)) {
            boolean bl = changed = changed || this.surrogateProfileHandler.updateProfile(selfProfile);
        }
        if (changed) {
            this.saveProfile(selfProfile);
        }
    }

    private boolean updateRoamingProfile(Profile selfProfile) {
        String propCache;
        if (DebugHelper.DEBUG_PROFILE_REGISTRY) {
            DebugHelper.debug(PROFILE_REGISTRY, "SimpleProfileRegistry.updateRoamingProfile");
        }
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Location installLocation = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.INSTALL_FILTER);
        File location = new File(installLocation.getURL().getPath());
        boolean changed = false;
        if (!location.equals(new File(selfProfile.getProperty("org.eclipse.equinox.p2.installFolder")))) {
            selfProfile.setProperty("org.eclipse.equinox.p2.installFolder", location.getAbsolutePath());
            changed = true;
        }
        if ((propCache = selfProfile.getProperty("org.eclipse.equinox.p2.cache")) != null && !location.equals(new File(propCache))) {
            selfProfile.setProperty("org.eclipse.equinox.p2.cache", location.getAbsolutePath());
            changed = true;
        }
        if (DebugHelper.DEBUG_PROFILE_REGISTRY) {
            DebugHelper.debug(PROFILE_REGISTRY, "SimpleProfileRegistry.updateRoamingProfile(changed=" + changed + ')');
        }
        return changed;
    }

    public synchronized String toString() {
        return this.getProfileMap().toString();
    }

    public synchronized IProfile getProfile(String id) {
        Profile profile = this.internalGetProfile(id);
        if (profile == null) {
            return null;
        }
        return profile.snapshot();
    }

    public synchronized IProfile getProfile(String id, long timestamp) {
        IProfile profile;
        if ("_SELF_".equals(id)) {
            id = this.self;
        }
        if (this.profiles != null && (profile = this.getProfile(id)) != null && profile.getTimestamp() == timestamp) {
            return profile;
        }
        File profileDirectory = new File(this.store, String.valueOf(SimpleProfileRegistry.escape(id)) + PROFILE_EXT);
        if (!profileDirectory.isDirectory()) {
            return null;
        }
        File profileFile = new File(profileDirectory, String.valueOf(Long.toString(timestamp)) + PROFILE_GZ_EXT);
        if (!profileFile.exists() && !(profileFile = new File(profileDirectory, String.valueOf(Long.toString(timestamp)) + PROFILE_EXT)).exists()) {
            return null;
        }
        Parser parser = new Parser(EngineActivator.getContext(), "org.eclipse.equinox.p2.engine");
        try {
            parser.parse(profileFile);
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.error_parsing_profile, (Object)profileFile), (Throwable)e));
        }
        return (IProfile)parser.getProfileMap().get(id);
    }

    public synchronized long[] listProfileTimestamps(String id) {
        if ("_SELF_".equals(id)) {
            id = this.self;
        }
        if (id == null) {
            return new long[0];
        }
        File profileDirectory = new File(this.store, String.valueOf(SimpleProfileRegistry.escape(id)) + PROFILE_EXT);
        if (!profileDirectory.isDirectory()) {
            return new long[0];
        }
        File[] profileFiles = profileDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return (pathname.getName().endsWith(SimpleProfileRegistry.PROFILE_EXT) || pathname.getName().endsWith(SimpleProfileRegistry.PROFILE_GZ_EXT)) && pathname.isFile();
            }
        });
        long[] timestamps = new long[profileFiles.length];
        int i = 0;
        while (i < profileFiles.length) {
            String filename = profileFiles[i].getName();
            int extensionIndex = filename.lastIndexOf(PROFILE_EXT);
            try {
                timestamps[i] = Long.parseLong(filename.substring(0, extensionIndex));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Incompatible profile file name. Expected format is {timestamp}.profile.gz (or {timestamp}.profile) but was " + filename + ".");
            }
            ++i;
        }
        Arrays.sort(timestamps);
        return timestamps;
    }

    private Profile internalGetProfile(String id) {
        Profile profile;
        if ("_SELF_".equals(id)) {
            id = this.self;
        }
        if ((profile = (Profile)this.getProfileMap().get(id)) == null && this.self != null && this.self.equals(id)) {
            profile = this.createSurrogateProfile(id);
        }
        return profile;
    }

    private Profile createSurrogateProfile(String id) {
        if (this.surrogateProfileHandler == null) {
            return null;
        }
        Profile profile = (Profile)this.surrogateProfileHandler.createProfile(id);
        if (profile == null) {
            return null;
        }
        this.saveProfile(profile);
        this.resetProfiles();
        return (Profile)this.getProfileMap().get(id);
    }

    public synchronized IProfile[] getProfiles() {
        Map profileMap = this.getProfileMap();
        IProfile[] result = new Profile[profileMap.size()];
        int i = 0;
        Iterator it = profileMap.values().iterator();
        while (it.hasNext()) {
            Profile profile = (Profile)it.next();
            result[i] = profile.snapshot();
            ++i;
        }
        return result;
    }

    protected Map getProfileMap() {
        LinkedHashMap result;
        if (this.profiles != null && (result = (Map)this.profiles.get()) != null) {
            return result;
        }
        result = this.restore();
        if (result == null) {
            result = new LinkedHashMap(8);
        }
        this.profiles = new SoftReference(result);
        if (this.updateSelfProfile) {
            this.updateSelfProfile(result);
        }
        return result;
    }

    public synchronized void updateProfile(Profile profile) {
        String id = profile.getProfileId();
        Profile current = this.internalGetProfile(id);
        if (current == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.profile_does_not_exist, (Object)id));
        }
        ProfileLock lock = (ProfileLock)this.profileLocks.get(id);
        lock.checkLocked();
        current.clearLocalProperties();
        current.clearInstallableUnits();
        current.addProperties(profile.getLocalProperties());
        Collector collector = profile.query((Query)InstallableUnitQuery.ANY, new Collector(), null);
        Iterator collectorIt = collector.iterator();
        while (collectorIt.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)collectorIt.next();
            current.addInstallableUnit(iu);
            Map iuProperties = profile.getInstallableUnitProperties(iu);
            if (iuProperties == null) continue;
            current.addInstallableUnitProperties(iu, iuProperties);
        }
        this.saveProfile(current);
        profile.clearOrphanedInstallableUnitProperties();
        profile.setTimestamp(current.getTimestamp());
        this.broadcastChangeEvent(id, (byte)2);
    }

    public IProfile addProfile(String id) throws ProvisionException {
        return this.addProfile(id, null, null);
    }

    public IProfile addProfile(String id, Map profileProperties) throws ProvisionException {
        return this.addProfile(id, profileProperties, null);
    }

    public synchronized IProfile addProfile(String id, Map profileProperties, String parentId) throws ProvisionException {
        Map profileMap;
        if ("_SELF_".equals(id)) {
            id = this.self;
        }
        if ((profileMap = this.getProfileMap()).get(id) != null) {
            throw new ProvisionException(NLS.bind((String)Messages.Profile_Duplicate_Root_Profile_Id, (Object)id));
        }
        Profile parent = null;
        if (parentId != null) {
            if ("_SELF_".equals(parentId)) {
                parentId = this.self;
            }
            if ((parent = (Profile)profileMap.get(parentId)) == null) {
                throw new ProvisionException(NLS.bind((String)Messages.Profile_Parent_Not_Found, (Object)parentId));
            }
        }
        Profile profile = new Profile(id, parent, profileProperties);
        if (this.surrogateProfileHandler != null && this.surrogateProfileHandler.isSurrogate(profile)) {
            profile.setSurrogateProfileHandler(this.surrogateProfileHandler);
        }
        profileMap.put(id, profile);
        this.saveProfile(profile);
        this.broadcastChangeEvent(id, (byte)0);
        return profile.snapshot();
    }

    public synchronized void removeProfile(String profileId) {
        Map profileMap;
        Profile profile;
        if ("_SELF_".equals(profileId)) {
            profileId = this.self;
        }
        if ((profile = (Profile)(profileMap = this.getProfileMap()).get(profileId)) == null) {
            return;
        }
        String[] subProfileIds = profile.getSubProfileIds();
        int i = 0;
        while (i < subProfileIds.length) {
            this.removeProfile(subProfileIds[i]);
            ++i;
        }
        this.internalLockProfile(profile);
        IProfile savedParent = profile.getParentProfile();
        try {
            profile.setParent(null);
        }
        finally {
            this.internalUnlockProfile(profile);
            if (savedParent != null) {
                this.internalUnlockProfile(savedParent);
            }
        }
        profileMap.remove(profileId);
        this.profileLocks.remove(profileId);
        this.deleteProfile(profileId);
        this.broadcastChangeEvent(profileId, (byte)1);
    }

    private void broadcastChangeEvent(String profileId, byte reason) {
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((IProvisioningEventBus)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())).publishEvent((EventObject)new ProfileEvent(profileId, reason));
    }

    /*
     * Unable to fully structure code
     */
    private Map restore() {
        if (this.store == null || !this.store.isDirectory()) {
            throw new IllegalStateException(Messages.reg_dir_not_available);
        }
        parser = new Parser(EngineActivator.getContext(), "org.eclipse.equinox.p2.engine");
        profileDirectories = this.store.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(SimpleProfileRegistry.PROFILE_EXT) && pathname.isDirectory();
            }
        });
        i = 0;
        while (i < profileDirectories.length) {
            directoryName = profileDirectories[i].getName();
            profileId = SimpleProfileRegistry.unescape(directoryName.substring(0, directoryName.lastIndexOf(".profile")));
            lock = (ProfileLock)this.profileLocks.get(profileId);
            if (lock == null) {
                lock = new ProfileLock(this, profileDirectories[i]);
                this.profileLocks.put(profileId, lock);
            }
            locked = false;
            if (lock.processHoldsLock() || (locked = lock.lock())) {
                try {
                    profileFile = this.findLatestProfileFile(profileDirectories[i]);
                    if (profileFile == null) ** GOTO lbl30
                    try {
                        parser.parse(profileFile);
                    }
                    catch (IOException e) {
                        LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.error_parsing_profile, (Object)profileFile), (Throwable)e));
                    }
                }
                finally {
                    if (locked) {
                        lock.unlock();
                    }
                }
            } else {
                parser.addProfilePlaceHolder(profileId);
            }
lbl30:
            // 4 sources

            ++i;
        }
        return parser.getProfileMap();
    }

    private File findLatestProfileFile(File profileDirectory) {
        File latest = null;
        long latestTimestamp = 0L;
        File[] profileFiles = profileDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return (pathname.getName().endsWith(SimpleProfileRegistry.PROFILE_GZ_EXT) || pathname.getName().endsWith(SimpleProfileRegistry.PROFILE_EXT)) && !pathname.isDirectory();
            }
        });
        int i = 0;
        while (i < profileFiles.length) {
            File profileFile = profileFiles[i];
            String fileName = profileFile.getName();
            try {
                long timestamp = Long.parseLong(fileName.substring(0, fileName.indexOf(PROFILE_EXT)));
                if (timestamp > latestTimestamp) {
                    latestTimestamp = timestamp;
                    latest = profileFile;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
        return latest;
    }

    private void saveProfile(Profile profile) {
        block16: {
            File profileDirectory = new File(this.store, String.valueOf(SimpleProfileRegistry.escape(profile.getProfileId())) + PROFILE_EXT);
            profileDirectory.mkdir();
            long previousTimestamp = profile.getTimestamp();
            long currentTimestamp = System.currentTimeMillis();
            if (currentTimestamp <= previousTimestamp) {
                currentTimestamp = previousTimestamp + 1L;
            }
            boolean shouldGzipFile = this.shouldGzipFile(profile);
            File profileFile = new File(profileDirectory, String.valueOf(Long.toString(currentTimestamp)) + (shouldGzipFile ? PROFILE_GZ_EXT : PROFILE_EXT));
            if (DebugHelper.DEBUG_PROFILE_REGISTRY) {
                DebugHelper.debug(PROFILE_REGISTRY, "Saving profile to: " + profileFile.getAbsolutePath());
            }
            profile.setTimestamp(currentTimestamp);
            profile.setChanged(false);
            OutputStream os = null;
            try {
                try {
                    os = shouldGzipFile ? new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(profileFile))) : new BufferedOutputStream(new FileOutputStream(profileFile));
                    Writer writer = new Writer(os);
                    writer.writeProfile(profile);
                }
                catch (IOException e) {
                    profile.setTimestamp(previousTimestamp);
                    profileFile.delete();
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.error_persisting_profile, (Object)profile.getProfileId()), (Throwable)e));
                    try {
                        if (os != null) {
                            os.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean shouldGzipFile(Profile profile) {
        String format = EngineActivator.getContext().getProperty("eclipse.p2.profileFormat");
        if (format != null && format.equals("uncompressed")) {
            return false;
        }
        return profile.available((Query)new InstallableUnitQuery("org.eclipse.equinox.p2.engine", new VersionRange("[0.0.0, 1.0.101)")), new Collector(), null).isEmpty();
    }

    private void deleteProfile(String profileId) {
        File profileDirectory = new File(this.store, String.valueOf(SimpleProfileRegistry.escape(profileId)) + PROFILE_EXT);
        FileUtils.deleteAll((File)profileDirectory);
    }

    public static String escape(String toEscape) {
        StringBuffer buffer = new StringBuffer();
        int length = toEscape.length();
        int i = 0;
        while (i < length) {
            char ch = toEscape.charAt(i);
            switch (ch) {
                case '\"': 
                case '%': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    buffer.append("%" + ch + ";");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String unescape(String text) {
        if (text.indexOf(37) == -1) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (ch == '%') {
                int colon = text.indexOf(59, i);
                if (colon == -1) {
                    throw new IllegalStateException("error unescaping the sequence at character (" + i + ") for " + text + ". Expected %{int};.");
                }
                ch = (char)Integer.parseInt(text.substring(i + 1, colon));
                i = colon;
            }
            buffer.append(ch);
            ++i;
        }
        return buffer.toString();
    }

    public synchronized boolean isCurrent(IProfile profile) {
        Profile internalProfile = this.internalGetProfile(profile.getProfileId());
        if (internalProfile == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.profile_not_registered, (Object)profile.getProfileId()));
        }
        if (!this.internalLockProfile(internalProfile)) {
            throw new IllegalStateException(Messages.SimpleProfileRegistry_Profile_in_use);
        }
        try {
            boolean bl = !((Profile)profile).isChanged() && this.checkTimestamps(profile, internalProfile);
            return bl;
        }
        finally {
            this.internalUnlockProfile(internalProfile);
        }
    }

    public synchronized void lockProfile(Profile profile) {
        Profile internalProfile = this.internalGetProfile(profile.getProfileId());
        if (internalProfile == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.profile_not_registered, (Object)profile.getProfileId()));
        }
        if (!this.internalLockProfile(internalProfile)) {
            throw new IllegalStateException(Messages.SimpleProfileRegistry_Profile_in_use);
        }
        boolean isCurrent = false;
        try {
            if (profile.isChanged()) {
                if (DebugHelper.DEBUG_PROFILE_REGISTRY) {
                    DebugHelper.debug(PROFILE_REGISTRY, "Profile is marked as changed.");
                }
                throw new IllegalStateException(NLS.bind((String)Messages.profile_not_current, (Object)profile.getProfileId()));
            }
            if (!this.checkTimestamps(profile, internalProfile)) {
                if (DebugHelper.DEBUG_PROFILE_REGISTRY) {
                    DebugHelper.debug(PROFILE_REGISTRY, "Unexpected timestamp difference in profile.");
                }
                throw new IllegalStateException(NLS.bind((String)Messages.profile_not_current, (Object)profile.getProfileId()));
            }
            isCurrent = true;
        }
        finally {
            if (!isCurrent) {
                this.internalUnlockProfile(internalProfile);
            }
        }
    }

    private boolean internalLockProfile(IProfile profile) {
        ProfileLock lock = (ProfileLock)this.profileLocks.get(profile.getProfileId());
        if (lock == null) {
            lock = new ProfileLock(this, new File(this.store, String.valueOf(SimpleProfileRegistry.escape(profile.getProfileId())) + PROFILE_EXT));
            this.profileLocks.put(profile.getProfileId(), lock);
        }
        if (!lock.lock()) {
            return false;
        }
        if (profile.getParentProfile() == null) {
            return true;
        }
        boolean locked = false;
        try {
            locked = this.internalLockProfile(profile.getParentProfile());
        }
        finally {
            if (!locked) {
                lock.unlock();
            }
        }
        return locked;
    }

    private boolean checkTimestamps(IProfile profile, IProfile internalProfile) {
        long currentTimestamp;
        long[] timestamps = this.listProfileTimestamps(profile.getProfileId());
        if (timestamps.length == 0) {
            if (DebugHelper.DEBUG_PROFILE_REGISTRY) {
                DebugHelper.debug(PROFILE_REGISTRY, "check timestamp: expected " + profile.getTimestamp() + " but no profiles were found");
            }
            this.resetProfiles();
            return false;
        }
        long l = currentTimestamp = timestamps.length == 0 ? -1L : timestamps[timestamps.length - 1];
        if (profile.getTimestamp() != currentTimestamp) {
            if (DebugHelper.DEBUG_PROFILE_REGISTRY) {
                DebugHelper.debug(PROFILE_REGISTRY, "check timestamp: expected " + profile.getTimestamp() + " but was " + currentTimestamp);
            }
            if (internalProfile.getTimestamp() != currentTimestamp) {
                this.resetProfiles();
            }
            return false;
        }
        if (profile.getParentProfile() != null) {
            return this.checkTimestamps(profile.getParentProfile(), internalProfile.getParentProfile());
        }
        return true;
    }

    public synchronized boolean containsProfile(String id) {
        if ("_SELF_".equals(id)) {
            id = this.self;
        }
        if (id == null) {
            return false;
        }
        if (this.profiles != null && this.getProfile(id) != null) {
            return true;
        }
        File profileDirectory = new File(this.store, String.valueOf(SimpleProfileRegistry.escape(id)) + PROFILE_EXT);
        if (!profileDirectory.isDirectory()) {
            return false;
        }
        File[] profileFiles = profileDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return (pathname.getName().endsWith(SimpleProfileRegistry.PROFILE_GZ_EXT) || pathname.getName().endsWith(SimpleProfileRegistry.PROFILE_EXT)) && pathname.isFile();
            }
        });
        return profileFiles.length > 0;
    }

    public synchronized void resetProfiles() {
        this.profiles = null;
    }

    public synchronized void unlockProfile(IProfile profile) {
        Profile internalProfile = this.internalGetProfile(profile.getProfileId());
        if (internalProfile == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.profile_not_registered, (Object)profile.getProfileId()));
        }
        this.internalUnlockProfile(internalProfile);
    }

    private void internalUnlockProfile(IProfile profile) {
        if (profile.getParentProfile() != null) {
            this.internalUnlockProfile(profile.getParentProfile());
        }
        ProfileLock lock = (ProfileLock)this.profileLocks.get(profile.getProfileId());
        lock.unlock();
    }

    public Profile validate(IProfile candidate) {
        if (candidate instanceof Profile) {
            return (Profile)candidate;
        }
        StringBuffer stringBuffer = new StringBuffer("Profile incompatible: expected ");
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.equinox.internal.p2.engine.Profile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        throw new IllegalArgumentException(stringBuffer.append(clazz.getName()).append(" but was ").append(candidate != null ? candidate.getClass().getName() : "null").append(".").toString());
    }

    public synchronized File getProfileDataDirectory(String id) {
        File profileDirectory;
        File profileDataArea;
        if ("_SELF_".equals(id)) {
            id = this.self;
        }
        if (!(profileDataArea = new File(profileDirectory = new File(this.store, String.valueOf(SimpleProfileRegistry.escape(id)) + PROFILE_EXT), DATA_EXT)).isDirectory() && !profileDataArea.mkdir()) {
            throw new IllegalStateException("Could not create profile data area " + profileDataArea.getAbsolutePath() + "for: " + id);
        }
        return profileDataArea;
    }

    class Parser
    extends ProfileParser {
        private final Map profileHandlers = new HashMap();

        public Parser(BundleContext context, String bundleId) {
            super(context, bundleId);
        }

        public void addProfilePlaceHolder(String profileId) {
            this.profileHandlers.put(profileId, new ProfileParser.ProfileHandler(profileId));
        }

        public void parse(File file) throws IOException {
            BufferedInputStream is = file.getName().endsWith(SimpleProfileRegistry.PROFILE_GZ_EXT) ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))) : new BufferedInputStream(new FileInputStream(file));
            this.parse(is);
        }

        public synchronized void parse(InputStream stream) throws IOException {
            this.status = null;
            try {
                try {
                    this.getParser();
                    ProfileParser.ProfileHandler profileHandler = new ProfileParser.ProfileHandler();
                    this.xmlReader.setContentHandler((ContentHandler)((Object)new ProfileDocHandler("profile", profileHandler)));
                    this.xmlReader.parse(new InputSource(stream));
                    this.profileHandlers.put(profileHandler.getProfileId(), profileHandler);
                }
                catch (SAXException e) {
                    throw new IOException(e.getMessage());
                }
                catch (ParserConfigurationException e) {
                    throw new IOException(e.getMessage());
                }
            }
            finally {
                stream.close();
            }
        }

        protected Object getRootObject() {
            return this;
        }

        public Map getProfileMap() {
            HashMap profileMap = new HashMap();
            Iterator it = this.profileHandlers.keySet().iterator();
            while (it.hasNext()) {
                String profileId = (String)it.next();
                this.addProfile(profileId, profileMap);
            }
            return profileMap;
        }

        private void addProfile(String profileId, Map profileMap) {
            if (profileMap.containsKey(profileId)) {
                return;
            }
            ProfileParser.ProfileHandler profileHandler = (ProfileParser.ProfileHandler)((Object)this.profileHandlers.get(profileId));
            Profile parentProfile = null;
            String parentId = profileHandler.getParentId();
            if (parentId != null) {
                this.addProfile(parentId, profileMap);
                parentProfile = (Profile)profileMap.get(parentId);
            }
            Profile profile = new Profile(profileId, parentProfile, profileHandler.getProperties());
            if (SimpleProfileRegistry.this.surrogateProfileHandler != null && SimpleProfileRegistry.this.surrogateProfileHandler.isSurrogate(profile)) {
                profile.setSurrogateProfileHandler(SimpleProfileRegistry.this.surrogateProfileHandler);
            }
            profile.setTimestamp(profileHandler.getTimestamp());
            IInstallableUnit[] ius = profileHandler.getInstallableUnits();
            if (ius != null) {
                int i = 0;
                while (i < ius.length) {
                    IInstallableUnit iu = ius[i];
                    profile.addInstallableUnit(iu);
                    Map iuProperties = profileHandler.getIUProperties(iu);
                    if (iuProperties != null) {
                        Iterator it = iuProperties.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            profile.setInstallableUnitProperty(iu, key, value);
                        }
                    }
                    ++i;
                }
            }
            profile.setChanged(false);
            profileMap.put(profileId, profile);
        }

        protected String getErrorMessage() {
            return Messages.SimpleProfileRegistry_Parser_Error_Parsing_Registry;
        }

        public String toString() {
            return null;
        }

        private final class ProfileDocHandler
        extends XMLParser.DocHandler {
            public ProfileDocHandler(String rootName, XMLParser.RootHandler rootHandler) {
                super((XMLParser)Parser.this, rootName, rootHandler);
            }

            public void processingInstruction(String target, String data) throws SAXException {
                Version repositoryVersion;
                if ("profile".equals(target) && !ProfileXMLConstants.XML_TOLERANCE.isIncluded(repositoryVersion = Parser.this.extractPIVersion(target, data))) {
                    throw new SAXException(NLS.bind((String)Messages.SimpleProfileRegistry_Parser_Has_Incompatible_Version, (Object)repositoryVersion, (Object)ProfileXMLConstants.XML_TOLERANCE));
                }
            }
        }
    }

    static class Writer
    extends ProfileWriter {
        public Writer(OutputStream output) throws IOException {
            super(output, new XMLWriter.ProcessingInstruction[]{XMLWriter.ProcessingInstruction.makeTargetVersionInstruction((String)"profile", (Version)ProfileXMLConstants.CURRENT_VERSION)});
        }
    }
}

