/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.DownloadManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.Engine;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.Phase;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.engine.phases.Collect;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.p2.internal.repository.tools.AbstractApplication;
import org.eclipse.equinox.p2.internal.repository.tools.Activator;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.osgi.framework.BundleContext;

public class Repo2Runnable
extends AbstractApplication
implements IApplication {
    private static final String NATIVE_ARTIFACTS = "nativeArtifacts";
    private static final String NATIVE_TYPE = "org.eclipse.equinox.p2.native";
    private static final String PARM_OPERAND = "operand";
    private Collection processedIUs = new ArrayList();

    public IStatus run(IProgressMonitor monitor) throws ProvisionException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        this.initializeRepos((IProgressMonitor)progress);
        this.validate();
        this.collectIUs((IProgressMonitor)progress.newChild(1));
        InstallableUnitOperand[] operands = new InstallableUnitOperand[this.processedIUs.size()];
        int i = 0;
        Iterator iter = this.processedIUs.iterator();
        while (iter.hasNext()) {
            operands[i++] = new InstallableUnitOperand(null, (IInstallableUnit)iter.next());
        }
        IProfile profile = this.createProfile();
        try {
            ProvisioningContext context = new ProvisioningContext();
            PhaseSet phaseSet = this.getPhaseSet();
            Engine engine = (Engine)ServiceHelper.getService((BundleContext)Activator.getBundleContext(), (String)IEngine.SERVICE_NAME);
            if (engine == null) {
                throw new ProvisionException(Messages.exception_noEngineService);
            }
            IStatus result = engine.perform(profile, phaseSet, (Operand[])operands, context, (IProgressMonitor)progress.newChild(1));
            if (result.matches(4)) {
                IStatus iStatus = result;
                return iStatus;
            }
            this.publishMetadata((IProgressMonitor)progress.newChild(1));
            IStatus iStatus = result;
            return iStatus;
        }
        finally {
            this.removeProfile(profile);
            this.finalizeRepositories();
        }
    }

    protected PhaseSet getPhaseSet() {
        return new PhaseSet(new Phase[]{new Collect(100), new CollectNativesPhase(100)}){};
    }

    private void collectIUs(IProgressMonitor monitor) throws ProvisionException {
        if (this.sourceIUs != null && !this.sourceIUs.isEmpty()) {
            this.processedIUs = this.sourceIUs;
            return;
        }
        if (!this.hasMetadataSources()) {
            throw new ProvisionException(Messages.exception_needIUsOrNonEmptyRepo);
        }
        this.processedIUs.addAll(this.getAllIUs(this.getCompositeMetadataRepository(), monitor).toCollection());
        if (this.processedIUs.isEmpty()) {
            throw new ProvisionException(Messages.exception_needIUsOrNonEmptyRepo);
        }
    }

    private void publishMetadata(IProgressMonitor monitor) {
        if (this.destinationMetadataRepository == null) {
            return;
        }
        this.destinationMetadataRepository.addInstallableUnits(this.processedIUs.toArray(new IInstallableUnit[this.processedIUs.size()]));
    }

    private Collector getAllIUs(IMetadataRepository repository, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            Collector collector = repository.query((Query)InstallableUnitQuery.ANY, new Collector(), (IProgressMonitor)progress.newChild(1));
            return collector;
        }
        finally {
            progress.done();
        }
    }

    private void removeProfile(IProfile profile) throws ProvisionException {
        IProfileRegistry registry = Activator.getProfileRegistry();
        registry.removeProfile(profile.getProfileId());
    }

    private IProfile createProfile() throws ProvisionException {
        Properties properties = new Properties();
        properties.put("org.eclipse.equinox.p2.cache", URIUtil.toFile((URI)this.destinationArtifactRepository.getLocation()).getAbsolutePath());
        properties.put("org.eclipse.equinox.p2.installFolder", URIUtil.toFile((URI)this.destinationArtifactRepository.getLocation()).getAbsolutePath());
        IProfileRegistry registry = Activator.getProfileRegistry();
        return registry.addProfile(String.valueOf(System.currentTimeMillis()) + "-" + Math.random(), (Map)properties);
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        this.processCommandLineArgs(args);
        this.run(null);
        return IApplication.EXIT_OK;
    }

    private void processCommandLineArgs(String[] args) throws URISyntaxException {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            String option = args[i];
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (option.equalsIgnoreCase("-source")) {
                    RepositoryDescriptor source = new RepositoryDescriptor();
                    source.setLocation(URIUtil.fromString((String)arg));
                    this.addSource(source);
                }
                if (option.equalsIgnoreCase("-destination")) {
                    RepositoryDescriptor destination = new RepositoryDescriptor();
                    destination.setLocation(URIUtil.fromString((String)arg));
                    this.addDestination(destination);
                }
            }
            ++i;
        }
    }

    private void validate() throws ProvisionException {
        if (!this.hasMetadataSources() && this.sourceIUs == null) {
            throw new ProvisionException(Messages.exception_needIUsOrNonEmptyRepo);
        }
        if (this.destinationArtifactRepository == null) {
            throw new ProvisionException(Messages.exception_needDestinationRepo);
        }
    }

    public void stop() {
    }

    protected class CollectNativesAction
    extends ProvisioningAction {
        protected CollectNativesAction() {
        }

        public IStatus execute(Map parameters) {
            InstallableUnitOperand operand = (InstallableUnitOperand)parameters.get(Repo2Runnable.PARM_OPERAND);
            IInstallableUnit installableUnit = operand.second();
            IArtifactRepositoryManager manager = null;
            try {
                manager = Activator.getArtifactRepositoryManager();
            }
            catch (ProvisionException e) {
                return e.getStatus();
            }
            IArtifactKey[] toDownload = installableUnit.getArtifacts();
            if (toDownload == null) {
                return Status.OK_STATUS;
            }
            List artifactRequests = (List)parameters.get(Repo2Runnable.NATIVE_ARTIFACTS);
            int i = 0;
            while (i < toDownload.length) {
                IArtifactRequest request = manager.createMirrorRequest(toDownload[i], Repo2Runnable.this.destinationArtifactRepository, null, null);
                artifactRequests.add(request);
                ++i;
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(Map parameters) {
            return Status.OK_STATUS;
        }
    }

    protected class CollectNativesPhase
    extends InstallableUnitPhase {
        public CollectNativesPhase(int weight) {
            super(Repo2Runnable.NATIVE_ARTIFACTS, weight);
        }

        protected ProvisioningAction[] getActions(InstallableUnitOperand operand) {
            IInstallableUnit unit = operand.second();
            if (unit.getTouchpointType().getId().equals(Repo2Runnable.NATIVE_TYPE)) {
                return new ProvisioningAction[]{new CollectNativesAction()};
            }
            return null;
        }

        protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
            parameters.put(Repo2Runnable.NATIVE_ARTIFACTS, new ArrayList());
            return null;
        }

        protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
            List artifactRequests = (List)parameters.get(Repo2Runnable.NATIVE_ARTIFACTS);
            ProvisioningContext context = (ProvisioningContext)parameters.get("context");
            DownloadManager dm = new DownloadManager(context);
            Iterator it = artifactRequests.iterator();
            while (it.hasNext()) {
                dm.add((IArtifactRequest)it.next());
            }
            return dm.start(monitor);
        }
    }
}

