/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.jres.ExecutionEnvironmentsLabelProvider;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.JREsEnvironmentComparator;
import org.eclipse.jdt.internal.debug.ui.jres.JREsEnvironmentLabelProvider;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ExecutionEnvironmentsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.jdt.debug.ui.jreProfiles";
    private TableViewer fProfilesViewer;
    private CheckboxTableViewer fJREsViewer;
    private Text fDescription;
    private Map fDefaults = new HashMap();

    public ExecutionEnvironmentsPreferencePage() {
        this.setTitle(JREMessages.JREProfilesPreferencePage_0);
        this.setDescription(JREMessages.JREProfilesPreferencePage_1);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ancestor, IJavaDebugHelpContextIds.JRE_PROFILES_PAGE);
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] environments = manager.getExecutionEnvironments();
        int i = 0;
        while (i < environments.length) {
            IExecutionEnvironment environment = environments[i];
            IVMInstall install = environment.getDefaultVM();
            if (install != null) {
                this.fDefaults.put(environment, install);
            }
            ++i;
        }
        Composite container = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        container.setFont(ancestor.getFont());
        Composite eeContainer = new Composite(container, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        eeContainer.setLayout((Layout)layout);
        eeContainer.setLayoutData((Object)new GridData(1808));
        Label label = new Label(eeContainer, 0);
        label.setFont(ancestor.getFont());
        label.setText(JREMessages.JREProfilesPreferencePage_2);
        label.setLayoutData((Object)new GridData(4, 0, true, false));
        Table table = new Table(eeContainer, 2052);
        table.setLayout((Layout)layout);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fProfilesViewer = new TableViewer(table);
        this.fProfilesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fProfilesViewer.setLabelProvider((IBaseLabelProvider)new ExecutionEnvironmentsLabelProvider());
        this.fProfilesViewer.setComparator(new ViewerComparator());
        this.fProfilesViewer.setInput((Object)JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments());
        Composite jreContainer = new Composite(container, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        jreContainer.setLayout((Layout)layout);
        jreContainer.setLayoutData((Object)new GridData(1808));
        label = new Label(jreContainer, 0);
        label.setFont(ancestor.getFont());
        label.setText(JREMessages.JREProfilesPreferencePage_3);
        label.setLayoutData((Object)new GridData(4, 0, true, false));
        table = new Table(jreContainer, 2084);
        table.setLayout((Layout)layout);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fJREsViewer = new CheckboxTableViewer(table);
        this.fJREsViewer.setContentProvider((IContentProvider)new JREsContentProvider());
        this.fJREsViewer.setLabelProvider((IBaseLabelProvider)new JREsEnvironmentLabelProvider(new JREsEnvironmentLabelProvider.IExecutionEnvironmentProvider(){

            public IExecutionEnvironment getEnvironment() {
                return (IExecutionEnvironment)ExecutionEnvironmentsPreferencePage.this.fJREsViewer.getInput();
            }
        }));
        this.fJREsViewer.setComparator((ViewerComparator)new JREsEnvironmentComparator());
        label = new Label(container, 0);
        label.setFont(ancestor.getFont());
        label.setText(JREMessages.JREProfilesPreferencePage_4);
        label.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        Text text = new Text(container, 2120);
        text.setFont(ancestor.getFont());
        text.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.fDescription = text;
        this.fProfilesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IExecutionEnvironment env = (IExecutionEnvironment)((IStructuredSelection)event.getSelection()).getFirstElement();
                ExecutionEnvironmentsPreferencePage.this.fJREsViewer.setInput((Object)env);
                String description = env.getDescription();
                if (description == null) {
                    description = "";
                }
                ExecutionEnvironmentsPreferencePage.this.fDescription.setText(description);
                IVMInstall jre = (IVMInstall)ExecutionEnvironmentsPreferencePage.this.fDefaults.get(env);
                if (jre != null) {
                    ExecutionEnvironmentsPreferencePage.this.fJREsViewer.setCheckedElements(new Object[]{jre});
                } else {
                    ExecutionEnvironmentsPreferencePage.this.fJREsViewer.setCheckedElements(new Object[0]);
                }
            }
        });
        this.fJREsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    Object element = event.getElement();
                    ExecutionEnvironmentsPreferencePage.this.fDefaults.put(ExecutionEnvironmentsPreferencePage.this.fJREsViewer.getInput(), element);
                    ExecutionEnvironmentsPreferencePage.this.fJREsViewer.setCheckedElements(new Object[]{element});
                } else {
                    ExecutionEnvironmentsPreferencePage.this.fDefaults.remove(ExecutionEnvironmentsPreferencePage.this.fJREsViewer.getInput());
                }
            }
        });
        Dialog.applyDialogFont((Control)ancestor);
        return ancestor;
    }

    public boolean performOk() {
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] environments = manager.getExecutionEnvironments();
        int i = 0;
        while (i < environments.length) {
            IExecutionEnvironment environment = environments[i];
            IVMInstall vm = (IVMInstall)this.fDefaults.get(environment);
            environment.setDefaultVM(vm);
            ++i;
        }
        return super.performOk();
    }

    class JREsContentProvider
    implements IStructuredContentProvider {
        JREsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((IExecutionEnvironment)inputElement).getCompatibleVMs();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

