/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.registry.tooling.popup.actions;

import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swordfish.registry.tooling.Activator;

public class UploadJob
extends Job {
    private static final String JOB_NAME = "Service Registry Upload";
    private final IStructuredSelection structuredSelection;

    public UploadJob(IStructuredSelection structuredSelection) {
        super(JOB_NAME);
        this.structuredSelection = structuredSelection;
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        monitor.beginTask(JOB_NAME, this.structuredSelection.size());
        try {
            try {
                HttpClient httpClient = new HttpClient();
                HttpMethodRetryHandler retryhandler = new HttpMethodRetryHandler(){

                    public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                        return false;
                    }
                };
                String serviceRegistryURL = Activator.getDefault().getPreferenceStore().getString("ServiceRegistryURL");
                for (Object element : this.structuredSelection) {
                    if (element instanceof IFile) {
                        IFile file = (IFile)element;
                        this.setName("Service Registry Upload: " + file.getName());
                        monitor.subTask("Processing " + file.getName());
                        PutMethod putMethod = new PutMethod(String.valueOf(serviceRegistryURL) + "/" + file.getName());
                        putMethod.getParams().setParameter("http.method.retry-handler", (Object)retryhandler);
                        InputStreamRequestEntity entity = new InputStreamRequestEntity(file.getContents());
                        putMethod.setRequestEntity((RequestEntity)entity);
                        try {
                            int statusCode = httpClient.executeMethod((HttpMethod)putMethod);
                            if (statusCode != 200) {
                                status = new Status(4, Activator.getId(), "Error in Service Registry Upload: [" + statusCode + "] " + putMethod.getStatusText());
                                break;
                            }
                            status = new Status(1, Activator.getId(), "Response from the Registry: " + putMethod.getResponseBodyAsString());
                            Activator.getDefault().getLog().log(status);
                        }
                        finally {
                            putMethod.releaseConnection();
                        }
                    }
                    monitor.worked(1);
                }
            }
            catch (Exception e) {
                status = new Status(4, Activator.getId(), 4, String.valueOf(e.getClass().getName()) + " : " + e.getMessage(), (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }
}

